/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prostoKnjigovodstvo.gui.knjizenje.akcije;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturausluga;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Uplata;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.prostoKnjigovodstvo.engine.sifreKnjizenja.manager.UplataManager;
import rs.pezar.prostoKnjigovodstvo.engine.sifreKnjizenja.manager.UplataPazaraManager;
import rs.pezar.prostoKnjigovodstvo.gui.knjizenje.akcije.PzComponentFactory;
import rs.pezar.prostoKnjigovodstvo.gui.knjizenje.akcije.PzDialogAkcija;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class UplataPazara
extends PzDialogAkcija {
    private static final long serialVersionUID = -756865764194830481L;
    private final PzPanel contentPanel = new PzPanel();
    private PzPanelHeader pnlHeader;
    private PzPanel pnlForm;
    private JLabel lblDatumKnjienja;
    private JLabel lblDatumUplate;
    private PzDateField datDatumKnjizenja;
    private PzDateField datDatumUplate;
    private PzRadioGroup<PzChoice> rgrTip;
    private PzPanel pnlGotovina;
    private JLabel lblGotovina;
    private JLabel lblekovi;
    private JLabel lblPlatneKartice;
    private PzDoubleField dblGotovina;
    private PzDoubleField dblCekovi;
    private PzDoubleField dblPlatneKartice;
    private PzPanel pnlVirman;
    private JLabel lblifraKupca_1;
    private JLabel lblOznakaFakture_1;
    private JLabel lblIznosUplate;
    private JLabel lblOpis;
    private PzNumericOnlyTextField numSifraKupcaVirman;
    private PzTextField txtOznFaktureVirman;
    private PzDoubleField dblIznosUplate;
    private PzNumericOnlyTextField numKonto;
    private PzTextField txtOpis;
    private PzTextField txtNazivKupcaVirman;
    private PropertiesConfiguration props;
    private File confFile;
    private Komitent komitent;
    private Radnajedinica rj;
    private PzDokument faktura;
    private Vector<PzDokument> dokumenti;
    private Uplata uplataVirman;

    public static void main(String[] args) {
        try {
            UplataPazara dialog = new UplataPazara();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public UplataPazara() {
        this.paintPanel();
    }

    public UplataPazara(PzDialog parent) {
        super(parent);
        this.paintPanel();
    }

    private void paintPanel() {
        this.contentPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.contentPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.contentPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void loadProperties() {
        this.props = new PropertiesConfiguration();
        this.confFile = new File(String.valueOf(PzApplication.getApplication().getDataFolder().getAbsolutePath()) + File.separator + "UplataPazara.properties");
        this.paintPanel();
        try {
            if (!this.confFile.exists()) {
                this.props.load(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prostoKnjigovodstvo/gui/knjizenje/akcije/resource/UplataPazara.properties"));
            } else {
                this.props.load(this.confFile);
            }
        }
        catch (ConfigurationException e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void initGUI() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setLayout((LayoutManager)new BorderLayout());
        this.contentPanel.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        buttonPane.setLayout(new FlowLayout(1));
        this.contentPanel.add((Component)buttonPane, (Object)"South");
        JButton okButton = new JButton("OK");
        okButton.setIcon(new ImageIcon(UplataPazara.class.getResource("/rs/pezar/prostoKnjigovodstvo/resource/img/check.png")));
        okButton.addActionListener((ActionListener)((Object)this));
        okButton.setActionCommand("OK");
        okButton.setName("okButton");
        buttonPane.add(okButton);
        this.pnlHeader = new PzPanelHeader();
        this.pnlHeader.setOpaque(false);
        this.pnlHeader.setTitle("Knji\u017eenje uplate pazara");
        this.contentPanel.add((Component)this.pnlHeader, (Object)"North");
        this.pnlForm = new PzPanel();
        GridBagLayout gbl_pnlForm = new GridBagLayout();
        this.contentPanel.add((Component)this.pnlForm, (Object)"Center");
        gbl_pnlForm.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
        gbl_pnlForm.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
        gbl_pnlForm.columnWidths = new int[]{7, 105, 7, 111, 7};
        gbl_pnlForm.rowHeights = new int[]{7, 7, 7, 7, 7};
        this.pnlForm.setLayout((LayoutManager)gbl_pnlForm);
        this.lblDatumKnjienja = new JLabel("Datum knji\u017eenja:");
        GridBagConstraints gbc_lblDatumKnjienja = new GridBagConstraints();
        gbc_lblDatumKnjienja.anchor = 13;
        gbc_lblDatumKnjienja.insets = new Insets(0, 0, 5, 5);
        gbc_lblDatumKnjienja.gridx = 0;
        gbc_lblDatumKnjienja.gridy = 0;
        this.pnlForm.add((Component)this.lblDatumKnjienja, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.datDatumKnjizenja = new PzDateField();
        this.datDatumKnjizenja.setColumns(6);
        GridBagConstraints gbc_datDatumKnjizenja = new GridBagConstraints();
        gbc_datDatumKnjizenja.insets = new Insets(0, 0, 5, 5);
        gbc_datDatumKnjizenja.fill = 2;
        gbc_datDatumKnjizenja.gridx = 1;
        gbc_datDatumKnjizenja.gridy = 0;
        this.pnlForm.add((Component)this.datDatumKnjizenja, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.datDatumKnjizenja.setName("datDatumKnjizenja");
        this.lblDatumUplate = new JLabel("Datum uplate:");
        GridBagConstraints gbc_lblDatumUplate = new GridBagConstraints();
        gbc_lblDatumUplate.anchor = 13;
        gbc_lblDatumUplate.insets = new Insets(0, 0, 5, 5);
        gbc_lblDatumUplate.gridx = 2;
        gbc_lblDatumUplate.gridy = 0;
        this.pnlForm.add((Component)this.lblDatumUplate, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 5), 0, 0));
        this.datDatumUplate = new PzDateField();
        this.datDatumUplate.setColumns(6);
        GridBagConstraints gbc_datDatumUplate = new GridBagConstraints();
        gbc_datDatumUplate.insets = new Insets(0, 0, 5, 5);
        gbc_datDatumUplate.fill = 2;
        gbc_datDatumUplate.gridx = 3;
        gbc_datDatumUplate.gridy = 0;
        this.pnlForm.add((Component)this.datDatumUplate, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.datDatumUplate.setName("datDatumUplate");
        this.rgrTip = PzComponentFactory.createGroupUplataPazara();
        this.rgrTip.setBorder((Border)new TitledBorder(null, "Na\u010din uplate", 4, 2, null, null));
        GridBagConstraints gbc_rgrTip = new GridBagConstraints();
        gbc_rgrTip.gridwidth = 3;
        gbc_rgrTip.insets = new Insets(0, 0, 5, 5);
        gbc_rgrTip.fill = 1;
        gbc_rgrTip.gridx = 1;
        gbc_rgrTip.gridy = 1;
        this.pnlForm.add(this.rgrTip, (Object)gbc_rgrTip);
        this.pnlForm.setOpaque(false);
        this.rgrTip.addRadioGroupListener(new PzRadioGroupListener(){

            public void selectionChanged(PzRadioGroupEvent evt) {
                UplataPazara.this.selectionChangedrgrTip(evt);
            }
        });
        this.pnlGotovina = new PzPanel();
        GridBagLayout gbl_pnlGotovina = new GridBagLayout();
        GridBagConstraints gbc_pnlGotovina = new GridBagConstraints();
        gbc_pnlGotovina.gridwidth = 6;
        gbc_pnlGotovina.insets = new Insets(0, 0, 5, 0);
        gbc_pnlGotovina.fill = 1;
        gbc_pnlGotovina.gridx = 0;
        gbc_pnlGotovina.gridy = 2;
        this.pnlForm.add((Component)this.pnlGotovina, (Object)new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        int[] nArray = new int[3];
        nArray[0] = 89;
        nArray[1] = 140;
        gbl_pnlGotovina.columnWidths = nArray;
        gbl_pnlGotovina.rowHeights = new int[3];
        gbl_pnlGotovina.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_pnlGotovina.rowWeights = new double[]{0.0, 0.0, 0.0};
        this.pnlGotovina.setLayout((LayoutManager)gbl_pnlGotovina);
        this.pnlGotovina.setOpaque(false);
        this.lblGotovina = new JLabel("Gotovina:");
        GridBagConstraints gbc_lblGotovina = new GridBagConstraints();
        gbc_lblGotovina.anchor = 13;
        gbc_lblGotovina.insets = new Insets(0, 0, 5, 5);
        gbc_lblGotovina.gridx = 0;
        gbc_lblGotovina.gridy = 0;
        this.pnlGotovina.add((Component)this.lblGotovina, (Object)gbc_lblGotovina);
        this.dblGotovina = new PzDoubleField();
        GridBagConstraints gbc_dblGotovina = new GridBagConstraints();
        gbc_dblGotovina.insets = new Insets(0, 0, 5, 5);
        gbc_dblGotovina.fill = 2;
        gbc_dblGotovina.gridx = 1;
        gbc_dblGotovina.gridy = 0;
        this.pnlGotovina.add((Component)this.dblGotovina, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.lblekovi = new JLabel("\u010cekovi:");
        GridBagConstraints gbc_lblekovi = new GridBagConstraints();
        gbc_lblekovi.anchor = 13;
        gbc_lblekovi.insets = new Insets(0, 0, 5, 5);
        gbc_lblekovi.gridx = 0;
        gbc_lblekovi.gridy = 1;
        this.pnlGotovina.add((Component)this.lblekovi, (Object)gbc_lblekovi);
        this.dblCekovi = new PzDoubleField();
        GridBagConstraints gbc_dblCekovi = new GridBagConstraints();
        gbc_dblCekovi.insets = new Insets(0, 0, 5, 5);
        gbc_dblCekovi.fill = 2;
        gbc_dblCekovi.gridx = 1;
        gbc_dblCekovi.gridy = 1;
        this.pnlGotovina.add((Component)this.dblCekovi, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.lblPlatneKartice = new JLabel("Platne kartice:");
        GridBagConstraints gbc_lblPlatneKartice = new GridBagConstraints();
        gbc_lblPlatneKartice.anchor = 13;
        gbc_lblPlatneKartice.insets = new Insets(0, 0, 5, 5);
        gbc_lblPlatneKartice.gridx = 0;
        gbc_lblPlatneKartice.gridy = 2;
        this.pnlGotovina.add((Component)this.lblPlatneKartice, (Object)gbc_lblPlatneKartice);
        this.dblPlatneKartice = new PzDoubleField();
        GridBagConstraints gbc_dblPlatneKartice = new GridBagConstraints();
        gbc_dblPlatneKartice.insets = new Insets(0, 0, 5, 5);
        gbc_dblPlatneKartice.fill = 2;
        gbc_dblPlatneKartice.gridx = 1;
        gbc_dblPlatneKartice.gridy = 2;
        this.pnlGotovina.add((Component)this.dblPlatneKartice, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.pnlVirman = new PzPanel();
        GridBagLayout gbl_pnlVirman = new GridBagLayout();
        GridBagConstraints gbc_pnlVirman = new GridBagConstraints();
        gbc_pnlVirman.gridwidth = 6;
        gbc_pnlVirman.fill = 1;
        gbc_pnlVirman.gridx = 0;
        gbc_pnlVirman.gridy = 3;
        this.pnlForm.add((Component)this.pnlVirman, (Object)new GridBagConstraints(0, 3, 5, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        int[] nArray2 = new int[6];
        nArray2[0] = 88;
        nArray2[1] = 82;
        nArray2[2] = 50;
        nArray2[3] = 136;
        nArray2[4] = 276;
        gbl_pnlVirman.columnWidths = nArray2;
        gbl_pnlVirman.rowHeights = new int[5];
        gbl_pnlVirman.columnWeights = new double[]{0.0, 0.0, 1.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_pnlVirman.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.pnlVirman.setLayout((LayoutManager)gbl_pnlVirman);
        this.pnlVirman.setOpaque(false);
        this.lblifraKupca_1 = new JLabel("\u0160ifra kupca:");
        GridBagConstraints gbc_lblifraKupca_1 = new GridBagConstraints();
        gbc_lblifraKupca_1.anchor = 13;
        gbc_lblifraKupca_1.insets = new Insets(0, 0, 5, 5);
        gbc_lblifraKupca_1.gridx = 0;
        gbc_lblifraKupca_1.gridy = 0;
        this.pnlVirman.add((Component)this.lblifraKupca_1, (Object)gbc_lblifraKupca_1);
        this.numSifraKupcaVirman = PzComponentFactory.createKomitentField();
        GridBagConstraints gbc_numSifraKupcaVirman = new GridBagConstraints();
        gbc_numSifraKupcaVirman.insets = new Insets(0, 0, 5, 5);
        gbc_numSifraKupcaVirman.fill = 2;
        gbc_numSifraKupcaVirman.gridx = 1;
        gbc_numSifraKupcaVirman.gridy = 0;
        this.pnlVirman.add((Component)this.numSifraKupcaVirman, (Object)gbc_numSifraKupcaVirman);
        this.txtNazivKupcaVirman = new PzTextField();
        this.txtNazivKupcaVirman.setFocusable(false);
        this.txtNazivKupcaVirman.setEditable(false);
        GridBagConstraints gbc_txtNazivKupcaVirman = new GridBagConstraints();
        gbc_txtNazivKupcaVirman.gridwidth = 3;
        gbc_txtNazivKupcaVirman.insets = new Insets(0, 0, 5, 5);
        gbc_txtNazivKupcaVirman.fill = 2;
        gbc_txtNazivKupcaVirman.gridx = 2;
        gbc_txtNazivKupcaVirman.gridy = 0;
        this.pnlVirman.add((Component)this.txtNazivKupcaVirman, (Object)gbc_txtNazivKupcaVirman);
        this.lblOznakaFakture_1 = new JLabel("Oznaka fakture:");
        GridBagConstraints gbc_lblOznakaFakture_1 = new GridBagConstraints();
        gbc_lblOznakaFakture_1.anchor = 13;
        gbc_lblOznakaFakture_1.insets = new Insets(0, 0, 5, 5);
        gbc_lblOznakaFakture_1.gridx = 0;
        gbc_lblOznakaFakture_1.gridy = 1;
        this.pnlVirman.add((Component)this.lblOznakaFakture_1, (Object)gbc_lblOznakaFakture_1);
        this.txtOznFaktureVirman = PzComponentFactory.createOznDokumentaField(this.numSifraKupcaVirman, 1, TipDokumentConfig.get().FAKTURA, null, this, this.rj, "E");
        GridBagConstraints gbc_txtOznFaktureVirman = new GridBagConstraints();
        gbc_txtOznFaktureVirman.gridwidth = 2;
        gbc_txtOznFaktureVirman.insets = new Insets(0, 0, 5, 5);
        gbc_txtOznFaktureVirman.fill = 2;
        gbc_txtOznFaktureVirman.gridx = 1;
        gbc_txtOznFaktureVirman.gridy = 1;
        this.pnlVirman.add((Component)this.txtOznFaktureVirman, (Object)gbc_txtOznFaktureVirman);
        this.lblIznosUplate = new JLabel("Iznos uplate:");
        GridBagConstraints gbc_lblIznosUplate = new GridBagConstraints();
        gbc_lblIznosUplate.anchor = 13;
        gbc_lblIznosUplate.insets = new Insets(0, 0, 5, 5);
        gbc_lblIznosUplate.gridx = 0;
        gbc_lblIznosUplate.gridy = 2;
        this.pnlVirman.add((Component)this.lblIznosUplate, (Object)gbc_lblIznosUplate);
        this.dblIznosUplate = new PzDoubleField();
        this.dblIznosUplate.setVerifyInput(true);
        GridBagConstraints gbc_dblIznosUplate = new GridBagConstraints();
        gbc_dblIznosUplate.insets = new Insets(0, 0, 5, 5);
        gbc_dblIznosUplate.fill = 2;
        gbc_dblIznosUplate.gridx = 1;
        gbc_dblIznosUplate.gridy = 2;
        this.pnlVirman.add((Component)this.dblIznosUplate, (Object)new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.lblOpis = new JLabel("Opis:");
        GridBagConstraints gbc_lblOpis = new GridBagConstraints();
        gbc_lblOpis.anchor = 13;
        gbc_lblOpis.insets = new Insets(0, 0, 0, 5);
        gbc_lblOpis.gridx = 0;
        gbc_lblOpis.gridy = 4;
        this.pnlVirman.add((Component)this.lblOpis, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.txtOpis = new PzTextField();
        GridBagConstraints gbc_txtOpis = new GridBagConstraints();
        gbc_txtOpis.gridwidth = 4;
        gbc_txtOpis.insets = new Insets(0, 0, 0, 5);
        gbc_txtOpis.fill = 2;
        gbc_txtOpis.gridx = 1;
        gbc_txtOpis.gridy = 4;
        this.pnlVirman.add((Component)this.txtOpis, (Object)new GridBagConstraints(1, 3, 4, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.pack();
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof PzDokument) {
            this.faktura = (PzDokument)entity;
            if (entity instanceof Faktura) {
                Faktura f = (Faktura)entity;
                this.dblIznosUplate.setVal((Object)f.getIznos().subtract(f.getStornoIznos()).subtract(f.getUplata()));
                this.txtOpis.setVal((Object)("Upl. po fak. " + this.faktura.getOznDokumenta() + " od kup. " + this.komitent.getSfrKomitent()));
            } else {
                Fakturausluga f = (Fakturausluga)entity;
                this.dblIznosUplate.setVal((Object)f.getIznos().subtract(f.getStornoIznos()).subtract(f.getUplata()));
                this.txtOpis.setVal((Object)("Upl. po fak. " + this.faktura.getOznDokumenta() + " od kup. " + this.komitent.getSfrKomitent()));
            }
        } else if (entity instanceof Komitent) {
            this.komitent = (Komitent)entity;
            this.txtNazivKupcaVirman.setVal((Object)this.komitent.getNaziv());
            this.numSifraKupcaVirman.setVal((Object)this.komitent.getSfrKomitent());
            this.txtOznFaktureVirman.setVal((Object)"");
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        try {
            if (((PzChoice)this.rgrTip.getSelectedValue()).getValue().equals(TipDokumentConfig.get().PODTIP_UPLATA_PAZARA_GOTOVINA)) {
                BigDecimal nula = new BigDecimal("0.00");
                if (this.dblCekovi.getBigDecimal().compareTo(nula) == 0 && this.dblGotovina.getBigDecimal().compareTo(nula) == 0 && this.dblPlatneKartice.getBigDecimal().compareTo(nula) == 0) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Gre\u0161ka! Makar jedan od iznosa mora biti ve\u0107i od 0.00!");
                    return;
                }
            } else if (!this.pnlForm.validateForm(true)) {
                return;
            }
            this.sastaviStavkeIDokumente();
            this.setDatKnjizenjaTemp(this.datDatumKnjizenja.getVal());
            this.setDatUplateTemp(this.datDatumUplate.getVal());
            this.commit();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    protected void selectionChangedrgrTip(PzRadioGroupEvent evt) {
        try {
            if (evt.getStateChange() == 1) {
                if (((PzChoice)evt.getValue()).getValue().equals(TipDokumentConfig.get().PODTIP_UPLATA_PAZARA_GOTOVINA)) {
                    this.pnlGotovina.setVisible(true);
                    this.pnlVirman.setVisible(false);
                } else {
                    this.pnlGotovina.setVisible(false);
                    this.pnlVirman.setVisible(true);
                }
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    @Override
    public Date getDatKnjizenja() {
        return this.datDatumKnjizenja.getVal();
    }

    @Override
    public List<PzDokument> getNewDokuments() {
        return this.dokumenti;
    }

    private void sastaviStavkeIDokumente() {
        this.dokumenti = new Vector();
        if (((PzChoice)this.rgrTip.getSelectedValue()).getValue().equals(TipDokumentConfig.get().PODTIP_UPLATA_PAZARA_GOTOVINA)) {
            Uplata uplata;
            if (this.dblGotovina.getBigDecimal().compareTo(new BigDecimal("0.00")) > 0) {
                uplata = this.createUplata();
                uplata.setIznos(this.dblGotovina.getBigDecimal());
                uplata.setPodTip(TipDokumentConfig.get().PODTIP_UPLATA_PAZARA_GOTOVINA);
                this.dokumenti.add((PzDokument)uplata);
            }
            if (this.dblCekovi.getBigDecimal().compareTo(new BigDecimal("0.00")) > 0) {
                uplata = this.createUplata();
                uplata.setIznos(this.dblCekovi.getBigDecimal());
                uplata.setPodTip(TipDokumentConfig.get().PODTIP_UPLATA_PAZARA_CEKOVI);
                this.dokumenti.add((PzDokument)uplata);
            }
            if (this.dblPlatneKartice.getBigDecimal().compareTo(new BigDecimal("0.00")) > 0) {
                uplata = this.createUplata();
                uplata.setIznos(this.dblPlatneKartice.getBigDecimal());
                uplata.setPodTip(TipDokumentConfig.get().PODTIP_UPLATA_PAZARA_PL_KARTICE);
                this.dokumenti.add((PzDokument)uplata);
            }
        } else if (this.dblIznosUplate.getBigDecimal().compareTo(new BigDecimal("0.00")) > 0) {
            this.uplataVirman = new Uplata();
            this.uplataVirman.setDatum(this.datDatumUplate.getVal());
            this.uplataVirman.setIznos(this.dblIznosUplate.getBigDecimal());
            this.uplataVirman.setPoDokumentu(this.faktura.getIdDok());
            this.uplataVirman.setTipDokumentaUpl(this.faktura.getTip());
            this.uplataVirman.setOznDokumenta(this.txtOznFaktureVirman.getVal());
            this.uplataVirman.setKomitent(this.komitent);
            this.uplataVirman.setTip(TipDokumentConfig.get().UPLATA_PAZARA);
            this.uplataVirman.setPodTip(TipDokumentConfig.get().PODTIP_UPLATA_PAZARA_VIRMAN);
            this.uplataVirman.setRadnajedinica(this.rj);
            this.uplataVirman.setSfrKnjizenja(Integer.valueOf(this.getSfrKnjizenja()));
            this.dokumenti.add((PzDokument)this.uplataVirman);
        }
    }

    private Uplata createUplata() {
        Uplata uplata = new Uplata();
        uplata.setDatum(this.datDatumUplate.getVal());
        uplata.setKomitent(this.komitent);
        uplata.setTip(TipDokumentConfig.get().UPLATA_PAZARA);
        uplata.setRadnajedinica(this.rj);
        uplata.setSfrKnjizenja(Integer.valueOf(this.getSfrKnjizenja()));
        return uplata;
    }

    public boolean shouldBeShown() {
        this.rj = PzDialogRJ.getRJ((PzDialog)this, (String[])new String[]{"EL", "EV"});
        if (this.rj != null) {
            try {
                this.loadProperties();
                this.initGUI();
                this.datDatumKnjizenja.setVal((Object)this.getDatKnjizenjaTemp());
                this.datDatumUplate.setVal((Object)this.getDatUplateTemp());
                this.pnlVirman.setVisible(false);
                return true;
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    @Override
    public UplataManager getUplataManager() {
        if (((PzChoice)this.rgrTip.getSelectedValue()).getValue().equals(TipDokumentConfig.get().PODTIP_UPLATA_PAZARA_VIRMAN)) {
            return new UplataPazaraManager(this.faktura, this.uplataVirman).addValue("TIP", ((PzChoice)this.rgrTip.getSelectedValue()).getValue());
        }
        return null;
    }

    @Override
    public PzDokument getNewDokument() throws Exception {
        return null;
    }
}

