/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prostoKnjigovodstvo.gui.util;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashMap;
import rs.pezar.core.PzApplication;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Nzk;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.prostoKnjigovodstvo.PzExtensionLoader;

public class LockUtility {
    private static HashMap<String, FileLock> locks = new HashMap();

    public static void lock(Nzk nzk) throws Exception {
        String lockDir = LockUtility.getLockDir();
        Pzuser user = PzExtensionLoader.getLoggedUser();
        if (lockDir == null) {
            if (!nzk.getPzuser().getPzusername().equals(user.getPzusername())) {
                throw new NzkLockException("Nije definisan deljeni direktorijum, a korisnik koji pokusava da otvori nalog nije vlasnik istog.");
            }
            return;
        }
        File dir = new File(lockDir);
        if (!dir.exists() || !dir.isDirectory()) {
            if (!nzk.getPzuser().getPzusername().equals(user.getPzusername())) {
                throw new NzkLockException("Ne postoji deljeni direktorijum, a korisnik koji pokusava da otvori nalog nije vlasnik istog.");
            }
        } else {
            FileChannel channel;
            FileLock lock;
            File fileToLock = new File(String.valueOf(lockDir) + File.separator + nzk.getIdNalog() + ".nzk");
            if (!fileToLock.exists()) {
                fileToLock.createNewFile();
            }
            if ((lock = (channel = new RandomAccessFile(fileToLock, "rw").getChannel()).tryLock()) != null) {
                locks.put("" + nzk.getIdNalog(), lock);
                ByteBuffer buffer = ByteBuffer.wrap(user.getPzusername().getBytes());
                channel.write(buffer);
            } else {
                throw new NzkLockException("Drugi korisnik trenutno upravlja tra\u017eenim nalogom. Ne mo\u017eete otvoriti nalog za izmene dokle god ga drugi korisnik ne zatvori.");
            }
        }
    }

    public static void unLock(Nzk nzk) throws Exception {
        String lockDir = LockUtility.getLockDir();
        if (lockDir == null) {
            return;
        }
        FileLock lock = locks.get("" + nzk.getIdNalog());
        if (lock != null) {
            lock.channel().write(ByteBuffer.wrap("".getBytes()), 0L);
            lock.release();
            lock.channel().close();
            locks.remove("" + nzk.getIdNalog());
            new File(String.valueOf(lockDir) + File.separator + nzk.getIdNalog() + ".nzk").delete();
        }
    }

    private static String getLockDir() throws Exception {
        String deljeniDir = PzApplication.getApplication().getLocalMachineUserSettings().getString("DELJENI_DIR");
        if (deljeniDir == null) {
            deljeniDir = PzParameter.getParameterValue((String)"DELJENI_DIR");
        }
        if (deljeniDir != null) {
            File nzkDir = new File(String.valueOf(deljeniDir) + File.separator + "nzk");
            if (!nzkDir.exists()) {
                nzkDir.mkdir();
            }
            return String.valueOf(deljeniDir) + File.separator + "nzk";
        }
        return null;
    }

    public static class NzkLockException
    extends Exception {
        private static final long serialVersionUID = 2471136767665906000L;

        public NzkLockException(String message) {
            super(message);
        }
    }
}

