/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prostoKnjigovodstvo.gui.util;

import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.eclipse.persistence.queries.FetchGroup;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Izvodbanke;
import rs.pezar.db.entity.Konto;
import rs.pezar.db.entity.KontoPK;
import rs.pezar.db.entity.Nzk;
import rs.pezar.db.entity.Stavkanzk;
import rs.pezar.reports.PzReportViewer;
import rs.pezar.reports.engine.standard.PzBeanDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.swing.PzDialog;

public class Tools {
    private static XMLConfiguration reportConf;
    public static String ID_HEADER_SUBREPORT;
    public static String ID_HEADER_DATA;
    public static String ID_DOKUMENT_SUBREPORT;
    public static String ID_DOKUMENT_DATA;
    public static String ID_NZK_SUBREPORT;
    public static String ID_NZK_DATA;
    public static String ID_DOKUMENT_PARAMETERS;
    private static Map<String, String> props;

    static {
        ID_HEADER_SUBREPORT = "headerSubreport";
        ID_HEADER_DATA = "headerData";
        ID_DOKUMENT_SUBREPORT = "dokumentSubreport";
        ID_DOKUMENT_DATA = "dokumentData";
        ID_NZK_SUBREPORT = "nzkSubreport";
        ID_NZK_DATA = "nzkData";
        ID_DOKUMENT_PARAMETERS = "dokumentParameters";
    }

    public static void updateKonto(EntityManager em, Stavkanzk stavka) {
        Konto konto = (Konto)em.find(Konto.class, (Object)new KontoPK(stavka.getId().getOznKonto(), stavka.getId().getAnalitika()));
        konto.setDug(konto.getDug().add(stavka.getDuguje()));
        konto.setPot(konto.getPot().add(stavka.getPotrazuje()));
        konto.setZdug(stavka.getDuguje());
        konto.setZpot(stavka.getPotrazuje());
    }

    public static void printajNaloge(List<Nzk> nalozi) {
        for (Nzk n : nalozi) {
            System.out.println("NALOG");
            for (Stavkanzk stavka : n.getStavkanzks()) {
                System.out.println("-----------STAVKA-------------");
                System.out.println("  Konto: " + stavka.getId().getOznKonto() + "   " + stavka.getId().getAnalitika());
                System.out.println("  Duguje: " + stavka.getDuguje());
                System.out.println("  Potrazuje: " + stavka.getPotrazuje());
            }
            System.out.println();
        }
    }

    public static void prikaziIzvestaj(Nzk nalog, PzDialog parent, boolean detaljni) throws JRException, Exception {
        if (!detaljni) {
            Tools.sumirajStavke(nalog);
        }
        JasperPrint izvestaj = Tools.sastaviIzvestaj(Tools.sastaviHeaderSubreport(), Tools.sastaviNzkSubreport(nalog, detaljni), new HashMap<String, Object>(), Tools.napraviDatasource(nalog));
        PzReportViewer.viewReport((PzDialog)parent, (JasperPrint)izvestaj, (String)("Nalog_za_knjizenja_" + nalog.getIdNalog()));
    }

    private static PzDataSourceExtended napraviDatasource(Nzk nalog) {
        Vector<Nzk> staticContent = new Vector<Nzk>();
        staticContent.add(nalog);
        PzDataSourceExtended ds = new PzDataSourceExtended(staticContent, staticContent);
        ds.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
        return ds;
    }

    private static void sumirajStavke(Nzk nalog) {
        List stavke = nalog.getStavkanzks();
        nalog.setStavkanzks(new Vector());
        for (Stavkanzk stavka : stavke) {
            Tools.dodajStavku(nalog, stavka);
        }
    }

    private static void dodajStavku(Nzk nalog, Stavkanzk stavka) {
        Iterator i = nalog.getStavkanzks().iterator();
        Stavkanzk nStavka = null;
        boolean found = false;
        while (i.hasNext() && !found) {
            nStavka = (Stavkanzk)i.next();
            if (!nStavka.getId().getOznKonto().equals(stavka.getId().getOznKonto()) || !nStavka.getId().getAnalitika().equals(stavka.getId().getAnalitika())) continue;
            nStavka.setDuguje(nStavka.getDuguje().add(stavka.getDuguje()));
            nStavka.setPotrazuje(nStavka.getPotrazuje().add(stavka.getPotrazuje()));
            found = true;
        }
        if (!found) {
            nalog.getStavkanzks().add(stavka);
        }
    }

    private static JasperPrint spojiIzvestaje(List<JasperPrint> izvestaji) {
        JasperPrint jp = null;
        boolean first = true;
        for (JasperPrint izvestaj : izvestaji) {
            if (first) {
                jp = izvestaj;
                first = false;
                continue;
            }
            List pages = izvestaj.getPages();
            for (JRPrintPage page : pages) {
                jp.addPage(page);
            }
        }
        return jp;
    }

    private static JasperPrint sastaviIzvestaj(HashMap<String, Object> header, HashMap<String, Object> nzk, HashMap<String, Object> dokument, PzDataSourceExtended ds) throws JRException {
        JasperReport report = (JasperReport)JRLoader.loadObject((URL)Tools.class.getClassLoader().getResource("rs/pezar/finansije/resource/reports/compiled/nzk_container.jasper"));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.putAll(nzk);
        params.putAll(header);
        if (dokument != null) {
            params.putAll(dokument);
        }
        return JasperFillManager.fillReport((JasperReport)report, params, (JRDataSource)ds);
    }

    private static HashMap<String, Object> sastaviNzkSubreport(Nzk nalog, boolean detaljni) throws JRException {
        if (!detaljni) {
            Collections.sort(nalog.getStavkanzks(), new Comparator<Stavkanzk>(){

                @Override
                public int compare(Stavkanzk o1, Stavkanzk o2) {
                    if (o1.getId().getOznKonto().equals(o2.getId().getOznKonto())) {
                        return o1.getId().getAnalitika().compareTo(o2.getId().getAnalitika());
                    }
                    return o1.getId().getOznKonto().compareTo(o2.getId().getOznKonto());
                }
            });
        } else {
            Collections.sort(nalog.getStavkanzks(), new Comparator<Stavkanzk>(){

                @Override
                public int compare(Stavkanzk o1, Stavkanzk o2) {
                    if (o1.getId().getrBroj() > o2.getId().getrBroj()) {
                        return 1;
                    }
                    if (o1.getId().getrBroj() < o2.getId().getrBroj()) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        String filename = detaljni ? "nzk_detaljno.jasper" : "nzk.jasper";
        JasperReport nzkReport = (JasperReport)JRLoader.loadObject((URL)Tools.class.getClassLoader().getResource("rs/pezar/finansije/resource/reports/compiled/" + filename));
        Vector<Nzk> staticContent = new Vector<Nzk>();
        staticContent.add(nalog);
        PzDataSourceExtended ds = new PzDataSourceExtended(staticContent, nalog.getStavkanzks());
        ds.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
        res.put(ID_NZK_SUBREPORT, nzkReport);
        res.put(ID_NZK_DATA, ds);
        return res;
    }

    private static HashMap<String, Object> sastaviHeaderSubreport() throws Exception {
        HashMap<String, Object> res = new HashMap<String, Object>();
        JasperReport headerSubreport = (JasperReport)JRLoader.loadObject((URL)Tools.class.getClassLoader().getResource("rs/pezar/finansije/resource/reports/compiled/header.standard.jasper"));
        Vector<Firma> staticContent = new Vector<Firma>();
        staticContent.add(PzFirma.getFirma());
        PzDataSourceExtended ds = new PzDataSourceExtended(staticContent, staticContent);
        ds.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
        res.put(ID_HEADER_SUBREPORT, headerSubreport);
        res.put(ID_HEADER_DATA, ds);
        return res;
    }

    private static String findReport(String tipDok, String tipRj, String tipCene) throws Exception {
        if (reportConf == null) {
            reportConf = new XMLConfiguration(Tools.class.getClassLoader().getResource("rs/pezar/finansije/resource/reports.conf.xml"));
        }
        reportConf.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        String cTipDok = tipDok != null ? "[@tipDok='" + tipDok + "']" : "";
        String cTipRj = tipRj != null ? "[@tipRj='" + tipRj + "']" : "";
        String cTipCene = tipCene != null ? "[@tipCene='" + tipCene + "']" : "";
        return (String)reportConf.getProperty("report" + cTipDok + cTipRj + cTipCene);
    }

    public static List<Nzk> getNalozi(EntityManager em) {
        Query q = em.createQuery("SELECT nzk FROM Nzk nzk join fetch nzk.pzuser WHERE nzk.idNalog > 0 ORDER BY nzk.arhiviran, nzk.idNalog");
        FetchGroup grp = new FetchGroup();
        grp.addAttribute("idNalog");
        grp.addAttribute("datum");
        grp.addAttribute("arhiviran");
        grp.addAttribute("pzuser.pzusername");
        q.setHint("eclipselink.fetch-group", (Object)grp);
        List res = q.getResultList();
        return res;
    }

    public static List<Izvodbanke> getIzvod(EntityManager em, String racun) {
        Query q = em.createQuery("SELECT izvod FROM Izvodbanke izvod join fetch izvod.userPoc WHERE izvod.brRacuna='" + racun + "' ORDER BY izvod.rBroj");
        FetchGroup grp = new FetchGroup();
        grp.addAttribute("oznDokumenta");
        grp.addAttribute("datum");
        grp.addAttribute("ulaz");
        grp.addAttribute("izlaz");
        grp.addAttribute("userPoc.pzusername");
        q.setHint("eclipselink.fetch-group", (Object)grp);
        List res = q.getResultList();
        return res;
    }
}

