/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import rs.pezar.core.PzApplication;
import rs.pezar.db.entity.Dozvola;
import rs.pezar.util.PzExpressionParser;

public class PzPermissionController {
    private PzApplication application;
    private final String flagPattern = "\\[([rwx]?[rwx]?[rwx]?){1,3}\\]";
    private final String fullPattern = "\\w{1,4}\\[([rwx]?[rwx]?[rwx]?){1,3}\\]";
    private List<Dozvola> dozvole;
    private List<Dozvola> dozvoleGrupe;
    private String groupFlags;

    public PzPermissionController(PzApplication application) {
        this.application = application;
    }

    public boolean operationAllowed(String flags) throws PzExpressionParser.PzExpressionParserException {
        String userFlags = "kasa/imprac";
        if (userFlags.equals("A") || flags == null || flags.equals("")) {
            return true;
        }
        String expression = new String(flags);
        Pattern p = Pattern.compile("\\w{1,4}\\[([rwx]?[rwx]?[rwx]?){1,3}\\]");
        Matcher m = p.matcher(flags);
        while (m.find()) {
            String part = m.group();
            expression = this.satisfies(part, userFlags) ? expression.replace(part, "(1 > 0)") : expression.replace(part, "(1 < 0)");
        }
        return PzExpressionParser.getBoolean(expression);
    }

    public boolean itemAvailable(String tip, String itemId) {
        String p;
        String c;
        String userFlags = this.application.getSession().getLoggedUser().getPrivilegije();
        this.groupFlags = this.application.getSession().getLoggedUser().getPzuser() != null ? this.application.getSession().getLoggedUser().getPzuser().getPrivilegije() : "";
        if (userFlags != null && (userFlags.contains("A") || userFlags.contains("a"))) {
            return true;
        }
        if (this.groupFlags != null && (this.groupFlags.contains("A") || this.groupFlags.contains("a"))) {
            return true;
        }
        if (tip == null || itemId == null) {
            return false;
        }
        if (this.dozvole == null) {
            this.dozvole = this.application.getSession().getLoggedUser().getDozvolas();
        }
        if (this.dozvoleGrupe == null && this.application.getSession().getLoggedUser().getPzuser() != null) {
            this.dozvoleGrupe = this.application.getSession().getLoggedUser().getPzuser().getDozvolas();
        }
        boolean available = false;
        Iterator<Dozvola> iterator = this.dozvole.iterator();
        while (iterator.hasNext() && !available) {
            Dozvola d = iterator.next();
            if (!d.getId().getTip().equals(tip)) continue;
            c = this.getClassFromId(d.getId().getOpcija());
            p = this.getParameterFromId(d.getId().getOpcija());
            if (!(String.valueOf(c) + "[" + p + "]").equals(itemId)) continue;
            available = true;
        }
        if (!available && this.dozvoleGrupe != null && this.dozvoleGrupe.size() != 0) {
            iterator = this.dozvoleGrupe.iterator();
            while (iterator.hasNext() && !available) {
                Dozvola dg = iterator.next();
                if (!dg.getId().getTip().equals(tip)) continue;
                c = this.getClassFromId(dg.getId().getOpcija());
                p = this.getParameterFromId(dg.getId().getOpcija());
                if (!(String.valueOf(c) + "[" + p + "]").equals(itemId)) continue;
                available = true;
            }
        }
        return available;
    }

    private boolean satisfies(String part, String userFlags) {
        String name = part.substring(0, part.indexOf("["));
        Pattern p = Pattern.compile(String.valueOf(name) + "\\[([rwx]?[rwx]?[rwx]?){1,3}\\]");
        Matcher m = p.matcher(userFlags);
        String userFlag = null;
        if (!m.find()) {
            return false;
        }
        userFlag = m.group();
        String pFlags = part.substring(part.indexOf("[") + 1, part.indexOf("]"));
        String uFlags = userFlag.substring(userFlag.indexOf("[") + 1, userFlag.indexOf("]"));
        boolean contains = true;
        int i = 0;
        while (i < pFlags.length()) {
            if (uFlags.indexOf(pFlags.charAt(i)) == -1) {
                contains = false;
                break;
            }
            ++i;
        }
        return contains;
    }

    public static void main(String[] args) throws PzExpressionParser.PzExpressionParserException {
        PzPermissionController pc = new PzPermissionController(null);
        System.out.print(pc.operationAllowed("kasa/imprac"));
    }

    private String getClassFromId(String id) {
        return id.substring(0, id.indexOf(91));
    }

    private String getParameterFromId(String id) {
        String pattern = "\\[.+?\\]";
        Matcher m = Pattern.compile(pattern).matcher(id);
        String rez = null;
        if (m.find()) {
            rez = m.group().replace("[", "").replace("]", "");
        }
        return rez;
    }
}

