/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.defaultWidgets.mainView;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import rs.pezar.core.gui.defaultWidgets.mainView.TreeElement;

public class PzTreeCellRenderer
implements TreeCellRenderer {
    private Font font = new Font("Sans", 1, 14);
    private Color treeSelectionForeground = Color.WHITE;
    private Color treeNoSelectionForeground = UIManager.getColor("Tree.textForeground");
    private Color treeSelectionBackground = Color.BLUE;
    private Color treeNoSelectionBackground = UIManager.getColor("Tree.textBackground");

    public PzTreeCellRenderer() {
        UIDefaults metalDefaults = new MetalLookAndFeel().getDefaults();
        metalDefaults.getIcon("FileView.directoryIcon");
        metalDefaults.getIcon("FileView.hardDriveIcon");
        metalDefaults.getIcon("FileView.fileIcon");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
        DefaultTreeCellRenderer treeCellRenderer = new DefaultTreeCellRenderer();
        treeCellRenderer.setFont(this.font);
        if (sel) {
            treeCellRenderer.setOpaque(true);
            treeCellRenderer.setBackground(this.treeSelectionBackground);
            treeCellRenderer.setForeground(this.treeSelectionForeground);
        } else {
            treeCellRenderer.setOpaque(false);
            treeCellRenderer.setBackground(this.treeNoSelectionBackground);
            treeCellRenderer.setForeground(this.treeNoSelectionForeground);
        }
        treeCellRenderer.setEnabled(tree.isEnabled());
        String label = null;
        if (value instanceof Vector) {
            label = "PEZAR";
        } else {
            TreeElement element = (TreeElement)value;
            label = element.getLabel();
            ImageIcon icon = element.getIcon();
            treeCellRenderer.setIcon(icon);
            if (element.getActionClass() == null && !element.hasChildren()) {
                treeCellRenderer.setEnabled(false);
            }
        }
        treeCellRenderer.setText(label);
        return treeCellRenderer;
    }
}

