/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.defaultWidgets.mainView;

import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import rs.pezar.core.PzApplication;
import rs.pezar.util.PzExpressionParser;

public class TreeElement
implements Comparable {
    private ImageIcon icon;
    private String label;
    private String actionClass;
    private String parameter;
    private Vector<TreeElement> children;
    private TreeElement parent;
    private String permission;
    private Double id;
    private ClassLoader loader;

    public TreeElement() {
    }

    public TreeElement(ImageIcon icon, String label, String actionClass, String parameter) {
        this.icon = icon;
        this.label = label;
        this.actionClass = actionClass;
        this.parameter = parameter;
    }

    public TreeElement(Node node, ClassLoader loader) throws DOMException, ClassNotFoundException, PzExpressionParser.PzExpressionParserException {
        this.loader = loader;
        ImageIcon icon = node.getAttributes().getNamedItem("icon") != null ? new ImageIcon(loader.getResource(node.getAttributes().getNamedItem("icon").getNodeValue())) : null;
        this.setIcon(icon);
        this.setLabel(node.getAttributes().getNamedItem("name").getNodeValue());
        if (node.getAttributes().getNamedItem("class") != null && !node.getAttributes().getNamedItem("class").getNodeValue().equals("")) {
            this.actionClass = node.getAttributes().getNamedItem("class").getNodeValue();
        }
        if (node.getAttributes().getNamedItem("parameter") != null) {
            this.setParameter(node.getAttributes().getNamedItem("parameter").getNodeValue());
        }
        if (node.getAttributes().getNamedItem("permission") != null) {
            this.setPermission(node.getAttributes().getNamedItem("permission").getNodeValue());
        }
        if (node.getAttributes().getNamedItem("id") != null) {
            this.setId(Double.parseDouble(node.getAttributes().getNamedItem("id").getNodeValue()));
        } else {
            this.setId(0.0);
        }
        this.setChildren(new Vector<TreeElement>());
        if (node.hasChildNodes()) {
            int i = 0;
            while (i < node.getChildNodes().getLength()) {
                TreeElement child = new TreeElement(node.getChildNodes().item(i), loader);
                child.setParent(this);
                this.getChildren().addElement(child);
                ++i;
            }
        }
        Collections.sort(this.getChildren());
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getActionClass() {
        return this.actionClass;
    }

    public void setActionClass(String actionClass) {
        this.actionClass = actionClass;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public Vector<TreeElement> getChildren() {
        return this.children;
    }

    public void setChildren(Vector<TreeElement> children) {
        this.children = children;
    }

    public TreeElement getParent() {
        return this.parent;
    }

    public void setParent(TreeElement parent) {
        this.parent = parent;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean hasChildren() {
        return this.getChildren() != null && this.getChildren().size() > 0;
    }

    public void setId(Double id) {
        this.id = id;
    }

    public Double getId() {
        return this.id;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public int compareTo(Object o) {
        if (!(o instanceof TreeElement)) {
            throw new IllegalArgumentException("Cant compare TreeElement to " + o.getClass());
        }
        return this.getId().compareTo(((TreeElement)o).getId());
    }

    public void removeUnallowed() throws PzExpressionParser.PzExpressionParserException {
        if (this.children == null) {
            return;
        }
        Iterator<TreeElement> i = this.children.iterator();
        while (i.hasNext()) {
            TreeElement el = i.next();
            if (el.getChildren() == null || el.getChildren().size() == 0) {
                if (PzApplication.getApplication().getPermissionController().itemAvailable("TREE", String.valueOf(el.getActionClass()) + "[" + el.getParameter() + "]")) continue;
                i.remove();
                continue;
            }
            el.removeUnallowed();
            if (el.getChildren() != null && el.getChildren().size() != 0) continue;
            i.remove();
        }
    }

    public String toString() {
        return this.label;
    }
}

