/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.defaultWidgets.mainView;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import rs.pezar.core.PzApplication;
import rs.pezar.core.PzExtensionManager;
import rs.pezar.core.gui.defaultWidgets.mainView.TreeElement;
import rs.pezar.swing.PzDialog;

public class TreeListener
implements MouseListener,
KeyListener {
    @Override
    public void mouseReleased(MouseEvent e) {
        TreePath selPath;
        if (e.getClickCount() == 2 && (selPath = ((JTree)e.getSource()).getPathForLocation(e.getX(), e.getY())) != null) {
            if (selPath.getLastPathComponent() instanceof Vector) {
                return;
            }
            TreeElement element = (TreeElement)selPath.getLastPathComponent();
            this.run(element);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            TreePath selPath = ((JTree)e.getSource()).getSelectionPath();
            TreeElement element = (TreeElement)selPath.getLastPathComponent();
            this.run(element);
        }
    }

    public void run(TreeElement element) {
        if (element == null || element.getActionClass() == null) {
            return;
        }
        Class<Object> type = null;
        try {
            type = Class.forName(element.getActionClass(), false, element.getLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            type = this.searchForClassInWholeProject(element.getActionClass());
        }
        if (type == null) {
            JOptionPane.showMessageDialog(null, "Klasa ne postoji ni u jednom modulu. Dijalog se ne mo\u017ee prikazati!", "Gre\u0161ka", 0);
            return;
        }
        final Class<Object> clss = type;
        final String parameter = element.getParameter();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzApplication.getApplication().getWorkbench().showDialog(clss, parameter);
            }
        });
    }

    private Class<PzDialog> searchForClassInWholeProject(String actionClass) {
        Integer size = PzExtensionManager.getInstance().getExtensions().size();
        Class<?> clss = null;
        int i = 0;
        while (i < size) {
            ClassLoader cl = null;
            cl = PzExtensionManager.getInstance().getExtensions().get(i).getClass().getClassLoader();
            try {
                clss = Class.forName(actionClass, false, cl);
            }
            catch (ClassNotFoundException classNotFoundException) {}
            if (clss != null) break;
            ++i;
        }
        return clss;
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }
}

