/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.defaultWidgets.workArea;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.apache.commons.configuration.ConfigurationException;
import rs.pezar.core.gui.defaultWidgets.workArea.PzDialogShortcutRename;
import rs.pezar.core.gui.defaultWidgets.workArea.PzDragAndDropTransferHandler;
import rs.pezar.core.gui.defaultWidgets.workArea.PzIconChooser;
import rs.pezar.core.gui.defaultWidgets.workArea.PzShortcutListCellRenderer;
import rs.pezar.core.gui.defaultWidgets.workArea.PzShortcutsConfig;
import rs.pezar.core.gui.defaultWidgets.workArea.ShortcutListener;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzWidget;

public class WorkArea
extends PzWidget
implements ActionListener {
    private static final long serialVersionUID = -839672141748594270L;
    public static final String ID = "WORKAREA";
    private JScrollPane scrlPanel;
    private JList list;
    private static JPopupMenu popup;

    public WorkArea() {
        block6: {
            this.createPopUp();
            this.initGUI();
            this.setID(ID);
            this.setTitle("Pre\u010dice");
            this.setDefaultLocation(new PzWidget.Location(1, 0, 1, 1));
            try {
                if (!PzShortcutsConfig.documentExist()) break block6;
                int i = 0;
                while (i < PzShortcutsConfig.getDocLenght()) {
                    if (PzShortcutsConfig.getNameByIndex(i) != null) {
                        String name = PzShortcutsConfig.getNameByIndex(i);
                        String toolTip = PzShortcutsConfig.getToolTipByIndex(i);
                        String iconPath = PzShortcutsConfig.getIconByIndex(i);
                        Object[] o = new Object[]{name, iconPath, toolTip};
                        try {
                            ((DefaultListModel)this.list.getModel()).add(i, o);
                        }
                        catch (Exception exception) {
                            ((DefaultListModel)this.list.getModel()).addElement(o);
                        }
                    }
                    ++i;
                }
                this.list.setCellRenderer(new PzShortcutListCellRenderer(true));
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
        }
    }

    private void initGUI() {
        this.setPaintGradient(true);
        this.setGradient(Color.LIGHT_GRAY, Color.WHITE, PzPanel.GRADIENT_SOUTH_NORTH);
        BorderLayout thisLayout = new BorderLayout();
        this.setLayout(thisLayout);
        this.setPreferredSize(new Dimension(364, 328));
        this.scrlPanel = new JScrollPane();
        this.add((Component)this.scrlPanel, "Center");
        DefaultListModel model = new DefaultListModel();
        this.list = new JList();
        this.scrlPanel.setViewportView(this.list);
        this.list.setModel(model);
        ShortcutListener listener = new ShortcutListener();
        this.list.addMouseListener(listener);
        this.list.setName("WorkArea");
        this.list.addKeyListener(listener);
        this.list.setDragEnabled(true);
        PzDragAndDropTransferHandler handler = new PzDragAndDropTransferHandler();
        this.list.setTransferHandler(handler);
        this.list.setDropMode(DropMode.ON_OR_INSERT);
        this.list.setLayoutOrientation(2);
        this.list.setVisibleRowCount(-1);
        this.list.setSelectionMode(1);
    }

    private void createPopUp() {
        popup = new JPopupMenu();
        JMenuItem renameItem = new JMenuItem("Preimenuj");
        renameItem.setActionCommand("rename");
        renameItem.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/edit16x16.png")));
        renameItem.addActionListener(this);
        JMenuItem deleteItem = new JMenuItem("Obri\u0161i");
        deleteItem.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/delete16x16.png")));
        deleteItem.setActionCommand("delete");
        deleteItem.addActionListener(this);
        JMenuItem changeIconItem = new JMenuItem("Promeni ikonicu");
        changeIconItem.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/refresh16x16.png")));
        changeIconItem.setActionCommand("changeIcon");
        changeIconItem.addActionListener(this);
        popup.add(renameItem);
        popup.add(deleteItem);
        popup.add(changeIconItem);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block6: {
            String ac;
            block7: {
                block5: {
                    ac = e.getActionCommand();
                    if (!ac.equals("rename")) break block5;
                    Object[] value = (Object[])this.list.getSelectedValue();
                    int index = this.list.getSelectedIndex();
                    String name = (String)value[0];
                    String newName = PzDialogShortcutRename.showDialog(name, index);
                    value[0] = newName;
                    break block6;
                }
                if (!ac.equals("delete")) break block7;
                Object[] o = this.list.getSelectedValues();
                if (o.length == 0) break block6;
                Object[] objectArray = o;
                int newName = o.length;
                int name = 0;
                while (name < newName) {
                    Object o1 = objectArray[name];
                    Object[] values = (Object[])o1;
                    String value = (String)values[0];
                    ((DefaultListModel)this.list.getModel()).removeElement(o1);
                    try {
                        PzShortcutsConfig.removeXML(value);
                    }
                    catch (ConfigurationException e1) {
                        e1.printStackTrace();
                    }
                    ++name;
                }
                break block6;
            }
            if (!ac.equals("changeIcon")) break block6;
            Object[] label = (Object[])this.list.getSelectedValue();
            String name = (String)label[0];
            Vector<Object> vector = PzIconChooser.getSelectedIcon("", true);
            try {
                PzShortcutsConfig.changeIcon(name, (String)vector.get(0));
                label[1] = vector.get(0);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public static JPopupMenu getPopUpMenu() {
        return popup;
    }
}

