/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.menu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.persistence.EntityManager;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.util.PzDateUtility;

public class PzDialogGranicniDatumPDV
extends PzDialog {
    private static final long serialVersionUID = -2399355707510454442L;
    private PzDateField datDatum;
    private JLabel lblDatum;

    public PzDialogGranicniDatumPDV(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        this.setTitle("Pode\u0161avanje grani\u010dnog datuma za PDV");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "Center");
        GridBagLayout fl_buttonPane = new GridBagLayout();
        fl_buttonPane.rowWeights = new double[]{0.1, 0.1};
        fl_buttonPane.rowHeights = new int[]{26, 30};
        fl_buttonPane.columnWeights = new double[]{0.0, 0.0};
        fl_buttonPane.columnWidths = new int[]{140, 140};
        panel.setLayout(fl_buttonPane);
        this.lblDatum = new JLabel("Grani\u010dni datum za PDV:");
        panel.add((Component)this.lblDatum, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 20, 0, 0), 0, 0));
        this.datDatum = new PzDateField();
        panel.add((Component)this.datDatum, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 0, 20), 0, 0));
        String datumPDV = PzParameter.getParameterValue("PDV_OBRACUNSKI_PERIOD", PzDateUtility.getFirstDayOfCurrentYear().toString());
        this.datDatum.setVal(datumPDV);
        PzButton okButton = new PzButton("Potvrdi");
        panel.add((Component)okButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 3, 20), 0, 0));
        okButton.addActionListener(this);
        okButton.setIcon(new ImageIcon(PzDialogGranicniDatumPDV.class.getResource("/rs/pezar/core/resource/img/check.png")));
        okButton.setActionCommand("OK");
        this.pack();
        this.setResizable(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                if (actionCommand.equals("OK")) {
                    em.getTransaction().begin();
                    PzParameter.setParameter("PDV_OBRACUNSKI_PERIOD", this.datDatum.getVal().toString(), em);
                    em.getTransaction().commit();
                }
                this.dispose();
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle(this, e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }
}

