/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.menu.tekuciRacuni;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Tekuciracun;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzButtonPanel;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzTextField;

public class TekuciRacuniDodavanje
extends PzDialogInsert {
    private PzPanel panel;
    private PzButtonPanel pzButtonPanel1;
    private PzPanelHeader header;
    private PzButton btnPotvrdi;
    private JLabel lblBrojRacuna;
    private PzTextField txtBrojRacuna;
    private JLabel lblNazivBanke;
    private JCheckBox chckbxPodrazumevaniRaun;
    private PzTable table;
    private PzTextField txtNazivBanke;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                TekuciRacuniDodavanje inst = new TekuciRacuniDodavanje(frame);
                inst.setVisible(true);
            }
        });
    }

    public TekuciRacuniDodavanje() {
        this.initGUI();
    }

    public TekuciRacuniDodavanje(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public TekuciRacuniDodavanje(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    public TekuciRacuniDodavanje(PzDialog dialog, boolean izmena, Object data1, Object data2) {
        super(dialog, izmena, (PzTable)((Object)data1), data2);
    }

    @Override
    protected void initGUI() {
        try {
            this.panel = new PzPanel();
            this.panel.setBorder(new EmptyBorder(0, 0, 0, 10));
            GridBagLayout panelLayout = new GridBagLayout();
            this.pzButtonPanel1 = new PzButtonPanel();
            this.getContentPane().add((Component)this.pzButtonPanel1, "South");
            this.btnPotvrdi = new PzButton();
            this.pzButtonPanel1.add(this.btnPotvrdi);
            this.btnPotvrdi.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/check.png")));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.addActionListener(this);
            this.header = new PzPanelHeader();
            this.header.setIcon(this.getHeaderIcon());
            this.header.setTitle(this.getHeaderTitle());
            this.getContentPane().add((Component)this.header, "North");
            this.getContentPane().add((Component)this.panel, "Center");
            panelLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
            int[] nArray = new int[3];
            nArray[0] = 25;
            nArray[1] = 22;
            panelLayout.rowHeights = nArray;
            panelLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            panelLayout.columnWidths = new int[]{100, 207, 20};
            this.panel.setLayout(panelLayout);
            this.panel.setPreferredSize(new Dimension(421, 121));
            this.lblBrojRacuna = new JLabel();
            this.panel.add((Component)this.lblBrojRacuna, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.lblBrojRacuna.setText("Broj ra\u010duna:");
            this.txtBrojRacuna = new PzTextField();
            this.panel.add((Component)this.txtBrojRacuna, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
            this.lblNazivBanke = new JLabel();
            this.panel.add((Component)this.lblNazivBanke, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.lblNazivBanke.setText("Naziv banke:");
            this.txtNazivBanke = new PzTextField();
            GridBagConstraints gbc_txtNazivBanke = new GridBagConstraints();
            gbc_txtNazivBanke.gridwidth = 2;
            gbc_txtNazivBanke.insets = new Insets(0, 0, 5, 5);
            gbc_txtNazivBanke.fill = 2;
            gbc_txtNazivBanke.gridx = 1;
            gbc_txtNazivBanke.gridy = 1;
            this.panel.add((Component)this.txtNazivBanke, gbc_txtNazivBanke);
            this.chckbxPodrazumevaniRaun = new JCheckBox("Podrazumevani ra\u010dun");
            GridBagConstraints gbc_chckbxPodrazumevaniRaun = new GridBagConstraints();
            gbc_chckbxPodrazumevaniRaun.anchor = 17;
            gbc_chckbxPodrazumevaniRaun.insets = new Insets(0, 0, 0, 5);
            gbc_chckbxPodrazumevaniRaun.gridx = 1;
            gbc_chckbxPodrazumevaniRaun.gridy = 2;
            this.panel.add((Component)this.chckbxPodrazumevaniRaun, gbc_chckbxPodrazumevaniRaun);
            this.setSize(420, 300);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block11: {
            Tekuciracun racun = new Tekuciracun();
            String actionCommand = e.getActionCommand();
            try {
                Firma firma = PzFirma.getFirma();
                if (actionCommand.equalsIgnoreCase("Dodaj")) {
                    racun.setFirma(firma);
                    racun.setBrRacuna(this.txtBrojRacuna.getVal());
                    racun.setBanka(this.txtNazivBanke.getVal().toString());
                    this.getTable().insert((PzEntity)racun, true);
                    this.dispose();
                    break block11;
                }
                racun = (Tekuciracun)this.getTable().getSelectedEntity();
                racun.setBanka(this.txtNazivBanke.getVal().toString());
                racun.setPodrazumevani((short)(this.chckbxPodrazumevaniRaun.isSelected() ? 1 : 0));
                EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                try {
                    try {
                        em.getTransaction().begin();
                        List<Tekuciracun> racuni = racun.getFirma().getTekuciracuns();
                        for (Tekuciracun tr : racuni) {
                            if (racun.getPodrazumevani() == 1 && !tr.getBrRacuna().equals(racun.getBrRacuna())) {
                                tr.setPodrazumevani((short)0);
                            }
                            em.merge((Object)tr);
                        }
                        em.getTransaction().commit();
                        this.getTable().refreshData();
                        this.dispose();
                    }
                    catch (Exception ex) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        PzMysqlExceptionHandler.handle(ex);
                        em.close();
                    }
                }
                finally {
                    em.close();
                }
            }
            catch (Exception e1) {
                PzMysqlExceptionHandler.handle(this, e1);
            }
        }
    }

    @Override
    protected void onInsert() {
        this.setTitle("Dodavanje teku\u0107eg ra\u010duna");
        this.btnPotvrdi.setActionCommand("Dodaj");
        if (this.getTable().getRowCount() == 0) {
            this.chckbxPodrazumevaniRaun.setSelected(true);
            this.chckbxPodrazumevaniRaun.setEnabled(false);
        }
    }

    @Override
    protected void onUpdate() {
        this.setTitle("Izmena ra\u010duna");
        this.txtBrojRacuna.setEnabled(false);
        this.txtBrojRacuna.setEditable(false);
        this.btnPotvrdi.setActionCommand("Izmeni");
        try {
            Tekuciracun racun = (Tekuciracun)this.getTable().getSelectedEntity();
            this.txtBrojRacuna.setVal(racun.getBrRacuna());
            this.txtNazivBanke.setVal(racun.getBanka());
            this.chckbxPodrazumevaniRaun.setSelected(racun.getPodrazumevani() == 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setEntity(PzEntity entity, Component component) {
    }

    @Override
    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Dodavanje teku\u0107eg ra\u010duna");
        this.setHeaderIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/product_new.png")));
    }

    @Override
    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Izmena teku\u0107eg ra\u010duna");
        this.setHeaderIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/product_edit.png")));
    }

    public static Object getGUIBuilderInstance() {
        return new TekuciRacuniDodavanje(Boolean.FALSE);
    }

    public TekuciRacuniDodavanje(Boolean initGUI) {
    }
}

