/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.workbench.docking;

import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.intern.CDockable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import rs.pezar.core.gui.workbench.PzDockingWorkbench;
import rs.pezar.swing.PzMenu;
import rs.pezar.swing.PzWidget;
import rs.pezar.swing.WorkArea;
import rs.pezar.swing.event.PzWorkAreaListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class PzDockingWorkArea
implements WorkArea {
    private static final long serialVersionUID = 3374218881744445906L;
    private Vector<PzWidget> widgets;
    private Vector<PzWorkAreaListener> listeners;
    private CGrid grid;
    private PzDockingWorkbench workbench;

    public PzDockingWorkArea(CGrid grid, PzDockingWorkbench wb) {
        this.grid = grid;
        this.workbench = wb;
        this.widgets = new Vector();
        this.listeners = new Vector();
        this.listeners.add(this.createWidgetMenuListener());
    }

    @Override
    public List<PzWidget> getWidgets() {
        return this.widgets;
    }

    @Override
    public void addWorkAreaListener(PzWorkAreaListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public List<PzWorkAreaListener> getWorkAreaListeners() {
        return this.listeners;
    }

    @Override
    public void add(PzWidget widget) {
        PzWidget.Location l = widget.getDefaultLocation();
        DefaultSingleCDockable dockable = this.createDockable(widget);
        this.grid.add((double)l.getX(), (double)l.getY(), (double)l.getWidth(), (double)l.getHeight(), new CDockable[]{dockable});
        this.widgets.add(widget);
        this.fireWidgetAdded(widget);
    }

    @Override
    public void add(List<PzWidget> widgets) {
        for (PzWidget w : widgets) {
            this.add(w);
        }
    }

    @Override
    public void removeWidget(PzWidget widget) {
        this.widgets.remove(widget);
        this.fireWidgetRemoved(widget);
    }

    @Override
    public void removeWidget(String widgetID) {
        PzWidget w = null;
        for (PzWidget widget : this.widgets) {
            if (!widget.getID().equals(widgetID)) continue;
            w = widget;
            break;
        }
        if (w != null) {
            this.widgets.remove(w);
        }
    }

    private void fireWidgetAdded(PzWidget widget) {
        for (PzWorkAreaListener listener : this.listeners) {
            listener.widgetAdded(widget);
        }
    }

    private void fireWidgetRemoved(PzWidget widget) {
        for (PzWorkAreaListener listener : this.listeners) {
            listener.widgetRemoved(widget);
        }
    }

    @Override
    public PzWidget getWidgetById(String id) {
        PzWidget res = null;
        for (PzWidget widget : this.widgets) {
            if (!widget.getID().equals(id)) continue;
            res = widget;
            break;
        }
        return res;
    }

    private DefaultSingleCDockable createDockable(PzWidget widget) {
        DefaultSingleCDockable dockable = new DefaultSingleCDockable(widget.getID(), widget.getTitle(), (Component)widget, new CAction[0]);
        dockable.setCloseable(true);
        dockable.setExternalizable(false);
        widget.setDockable(dockable);
        return dockable;
    }

    private PzWorkAreaListener createWidgetMenuListener() {
        return new PzWorkAreaListener(){

            @Override
            public void widgetRemoved(PzWidget widget) {
            }

            @Override
            public void widgetAdded(PzWidget widget) {
                PzMenu prozori = PzDockingWorkArea.this.workbench.getWorkbenchMenuBar().getMenuById("PROZORI");
                if (prozori == null) {
                    prozori = new PzMenu();
                    prozori.setId("PROZORI");
                    prozori.setText("Komponente");
                    try {
                        PzDockingWorkArea.this.workbench.getWorkbenchMenuBar().addMenu(prozori);
                    }
                    catch (Exception e1) {
                        PzMysqlExceptionHandler.handle(e1);
                    }
                    prozori.addMenuListener(new MenuListener(){

                        @Override
                        public void menuSelected(MenuEvent e) {
                            PzMenu prozori = PzDockingWorkArea.this.workbench.getWorkbenchMenuBar().getMenuById("PROZORI");
                            if (prozori == null) {
                                return;
                            }
                            for (PzWidget w : PzDockingWorkArea.this.widgets) {
                                int i = 0;
                                while (i < prozori.getItemCount()) {
                                    JMenuItem item = prozori.getItem(i);
                                    if (item instanceof JCheckBoxMenuItem && item.getActionCommand().equals(w.getID())) {
                                        boolean visible = w.getDockable().isVisible();
                                        item.setSelected(visible);
                                    }
                                    ++i;
                                }
                            }
                        }

                        @Override
                        public void menuDeselected(MenuEvent e) {
                        }

                        @Override
                        public void menuCanceled(MenuEvent e) {
                        }
                    });
                }
                final String wid = widget.getID();
                DefaultSingleCDockable dockable = widget.getDockable();
                JCheckBoxMenuItem cbmi = null;
                cbmi = new JCheckBoxMenuItem(widget.getTitle());
                cbmi.setActionCommand(widget.getID());
                cbmi.setSelected(dockable.isVisible());
                cbmi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PzWidget w = PzDockingWorkArea.this.getWidgetById(wid);
                        DefaultSingleCDockable dockable = w.getDockable();
                        JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)e.getSource();
                        if (cbmi.isSelected()) {
                            w.initData();
                            dockable.setVisible(true);
                        } else {
                            dockable.setVisible(false);
                        }
                    }
                });
                prozori.insert(cbmi, prozori.getItemCount());
            }
        };
    }

    @Override
    public void initData() {
        for (PzWidget w : this.widgets) {
            if (!w.getDockable().isVisible()) continue;
            w.initData();
        }
    }

    @Override
    public void applyDefaultVisibility() {
        for (PzWidget w : this.widgets) {
            w.getDockable().setVisible(w.isVisibleByDefault());
        }
    }
}

