/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.log;

import org.osgi.service.log.LogService;
import rs.pezar.core.PzApplication;

public class PzLogger {
    private LogService log;
    private PzApplication application;
    private static PzLogger instance;

    public void startup() {
        instance = this;
        if (PzApplication.getApplication() != null) {
            this.application = PzApplication.getApplication();
        }
        this.application.setLog(this);
    }

    public void shutdown() {
        this.log = null;
    }

    public static PzLogger getInstance() {
        if (instance == null) {
            instance = new PzLogger();
        }
        return instance;
    }

    public synchronized void logInfo(String message) {
        LogService current = this.log;
        if (current != null) {
            current.log(3, message);
        } else {
            System.out.println("[ " + Thread.currentThread() + "] : " + message);
        }
    }

    public synchronized void logError(String message) {
        LogService current = this.log;
        if (current != null) {
            current.log(1, message);
        } else {
            System.out.println(message);
        }
    }

    public synchronized void logWarning(String message) {
        LogService current = this.log;
        if (current != null) {
            current.log(2, message);
        } else {
            System.out.println(message);
        }
    }

    public synchronized void logException(Throwable t) {
        LogService current = this.log;
        if (current != null) {
            if (t == null) {
                current.log(1, "Can't log null exception");
            } else {
                current.log(1, t.getMessage(), t);
            }
        } else {
            t.printStackTrace();
        }
    }

    public void setLog(LogService value) {
        if (this.log != null) {
            this.clearLog(this.log);
        }
        this.log = value;
    }

    public void clearLog(LogService value) {
        if (this.log != value) {
            return;
        }
        this.log = null;
    }

    public void setApplication(PzApplication pzApplication) {
        this.application = pzApplication;
        this.application.setLog(this);
    }
}

