/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db;

import java.util.List;
import javax.persistence.EntityManager;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentCustomizer;
import rs.pezar.db.PzDokumentFinalizer;
import rs.pezar.db.PzProizvodDokument;
import rs.pezar.db.PzUslugaDokument;
import rs.pezar.db.commons.PzBrojacRj;
import rs.pezar.db.commons.PzIdGen;
import rs.pezar.db.entity.Brojacrj;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Fiskalniracun;
import rs.pezar.db.entity.Id_gen;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Pzuser;

public class PzDefaultDokumentCustomizer
implements PzDokumentCustomizer {
    private String popuna;
    private Integer duzina;

    @Override
    public int getRbrDok(PzDokument dokument, EntityManager em) throws Exception {
        if (dokument.getRadnajedinica() == null) {
            return 0;
        }
        if (dokument.getRbrDok() != 0) {
            return dokument.getRbrDok();
        }
        Brojacrj brojac = PzBrojacRj.getRbrDok(dokument, em);
        brojac.setRBroj(brojac.getRBroj() + 1);
        return brojac.getRBroj();
    }

    @Override
    public int getRBroj(PzDokument dokument, EntityManager em) throws Exception {
        if (dokument.getRadnajedinica() == null) {
            return 0;
        }
        if (dokument.getrBroj() != 0) {
            return dokument.getrBroj();
        }
        Brojacrj brojac = PzBrojacRj.getRBroj(dokument, em);
        brojac.setRBroj(brojac.getRBroj() + 1);
        return brojac.getRBroj();
    }

    @Override
    public int getRbrKepu(PzDokument dokument, EntityManager em) throws Exception {
        if (dokument.getRadnajedinica() == null) {
            return 0;
        }
        if (dokument instanceof Interniracun) {
            Interniracun ir = (Interniracun)dokument;
            if (ir.getDokument1() != null && ir.getDokument1().getRbrKepu() != 0) {
                return ir.getDokument1().getRbrKepu();
            }
            Brojacrj brojac = PzBrojacRj.getRbrKepu(ir.getDokument1(), em);
            brojac.setRBroj(brojac.getRBroj() + 1);
            return brojac.getRBroj();
        }
        if (dokument.getDokument() != null && dokument.getDokument().getRbrKepu() != 0) {
            return dokument.getDokument().getRbrKepu();
        }
        Brojacrj brojac = PzBrojacRj.getRbrKepu(dokument, em);
        brojac.setRBroj(brojac.getRBroj() + 1);
        return brojac.getRBroj();
    }

    @Override
    public int getIdDok(PzDokument dokument, EntityManager em) throws Exception {
        return PzIdGen.getNextId("DOKUMENT_ID", 1, em).getIdVal();
    }

    @Override
    public void addTaksas(PzDokument dokument, EntityManager em) throws Exception {
        dokument.addTaksas();
    }

    @Override
    public void adjust(PzDokument dokument, EntityManager em) throws Exception {
        dokument.adjust();
    }

    @Override
    public void createDokumentInstance(PzDokument dokumentK, boolean azuriranjeStavki, EntityManager em) throws Exception {
        if (dokumentK instanceof Interniracun) {
            this.noviInterniRacun(dokumentK, em);
        } else {
            Dokument dok = new Dokument(dokumentK, azuriranjeStavki);
            dokumentK.setDokument(dok);
        }
        dokumentK.createLog(1, null, (Pzuser)em.find(Pzuser.class, (Object)PzApplication.getApplication().getSession().getLoggedUser().getPzusername()), em);
    }

    @Override
    public void updateDokumentInstance(PzDokument dokumentK, boolean azuriranjeStavki, EntityManager em) throws Exception {
        if (dokumentK instanceof Interniracun) {
            this.azuriranjeInternogRacuna(dokumentK, em);
        } else {
            dokumentK.updateDokument(azuriranjeStavki);
        }
    }

    @Override
    public void finalize(PzDokument dokumentK, EntityManager em) throws Exception {
        if (dokumentK instanceof Interniracun) {
            ((Interniracun)dokumentK).getDokument2().setOznDokumenta(dokumentK.getOznDokumenta());
            ((Interniracun)dokumentK).getDokument2().setRbrKepu(this.getRbrKepu(((Interniracun)dokumentK).getDokument2(), em));
        }
        if (dokumentK instanceof Fiskalniracun && dokumentK.getDokument() != null && dokumentK.getDokument().getRbrDok() == 0) {
            dokumentK.getDokument().setRbrDok(this.getRbrDok(dokumentK, em));
        }
        if (!(dokumentK instanceof Dokument)) {
            List<PzDokumentFinalizer> finalizers = PzApplication.getApplication().getDokumentFinalizerRegistry();
            for (PzDokumentFinalizer f : finalizers) {
                if (!f.appliesTo(dokumentK)) continue;
                f.finalize(dokumentK, em);
            }
        }
    }

    @Override
    public void sort(List<? extends PzProizvodDokument> list) {
        if (list != null && list.size() > 0) {
            for (PzProizvodDokument pzProizvodDokument : list) {
                if (pzProizvodDokument instanceof PzArtikalDokument) {
                    pzProizvodDokument.setSort(((PzArtikalDokument)pzProizvodDokument).getId().getrBroj());
                    continue;
                }
                if (!(pzProizvodDokument instanceof PzUslugaDokument)) continue;
                pzProizvodDokument.setSort(((PzUslugaDokument)pzProizvodDokument).getId().getrBroj());
            }
        }
    }

    private void noviInterniRacun(PzDokument dok, EntityManager em) throws Exception {
        Interniracun ir = (Interniracun)dok;
        ir.setVrsta("I");
        Dokument dokument1 = new Dokument(ir, true);
        ir.setVrsta("U");
        Id_gen dokId = (Id_gen)em.find(Id_gen.class, (Object)"DOKUMENT_ID");
        if (dokId == null) {
            dokId = new Id_gen();
            dokId.setIdName("DOKUMENT_ID");
            dokId.setIdVal(1);
        }
        dokId.setIdVal(dokId.getIdVal() + 1);
        em.merge((Object)dokId);
        ir.setIdDok(dokId.getIdVal());
        ir.adjust();
        Dokument dokument2 = new Dokument(ir, true);
        dokument2.setRbrDok(0);
        ir.setIdDok(dokument1.getIdDok());
        ir.setVrsta("N");
        ir.adjust();
        ir.setDokument1(dokument1);
        ir.setDokument2(dokument2);
        dokument1.setInterniracun(ir);
        dokument1.setInterniracun1(ir);
        dokument1.setPodTip("IZLAZ");
        dokument2.setInterniracun(ir);
        dokument2.setInterniracun1(ir);
    }

    private void azuriranjeInternogRacuna(PzDokument dok, EntityManager em) throws Exception {
        Interniracun ir = (Interniracun)dok;
        ir.setVrsta("I");
        ir.getDokument1().update(dok, true);
        ir.getDokument1().setPodTip("IZLAZ");
        ir.setVrsta("U");
        ir.getDokument2().update(dok, true);
        ir.getDokument2().setRbrDok(0);
        ir.setVrsta("N");
        em.merge((Object)ir.getDokument1());
        em.merge((Object)ir.getDokument2());
    }
}

