/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.entity.Airtaksa;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.ArtikalinterniracunPK;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.Usluga;
import rs.pezar.globals.TipDokumentConfig;

@Entity
@Table(name="ArtikalInterniRacun")
public class Artikalinterniracun
extends PzArtikalDokument
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private ArtikalinterniracunPK id;
    @Column(length=255)
    private String bliziOpis;
    private double cvProdajnaIznos;
    @Column(nullable=false)
    private double izlCena;
    @Column(nullable=false, length=255)
    private String jm;
    @Column(nullable=false)
    private double kolicina;
    @Column(nullable=false, length=255)
    private String naziv;
    @Column(nullable=false)
    private double procMarze;
    @Column(nullable=false)
    private double procRabata;
    private int sort;
    private double temp;
    @Column(nullable=false)
    private double ulCena;
    private BigDecimal ulProdCena = new BigDecimal(0);
    private BigDecimal izlProdCena = new BigDecimal(0);
    private BigDecimal ulProsNabCena = new BigDecimal(0);
    private BigDecimal izlProsNabCena = new BigDecimal(0);
    @Transient
    private boolean ulaz;
    @OneToMany(mappedBy="artikalinterniracun", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<Airtaksa> airtaksas;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Interniracun interniracun;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="sfrProizvod", nullable=false, insertable=false, updatable=false)
    private Artikal artikal;

    @Override
    public ArtikalinterniracunPK getId() {
        return this.id;
    }

    public void setId(ArtikalinterniracunPK id) {
        this.id = id;
    }

    @Override
    public String getBliziOpis() {
        return this.bliziOpis;
    }

    @Override
    public void setBliziOpis(String bliziOpis) {
        this.bliziOpis = bliziOpis;
    }

    public double getCvProdajnaIznos() {
        return this.cvProdajnaIznos;
    }

    public void setCvProdajnaIznos(double cvProdajnaIznos) {
        this.cvProdajnaIznos = cvProdajnaIznos;
    }

    public double getIzlCena() {
        return this.izlCena;
    }

    public void setIzlCena(double izlCena) {
        this.izlCena = izlCena;
    }

    @Override
    public String getJm() {
        return this.jm;
    }

    @Override
    public void setJm(String jm) {
        this.jm = jm;
    }

    @Override
    public double getKolicina() {
        return this.kolicina;
    }

    @Override
    public void setKolicina(double kolicina) {
        this.kolicina = kolicina;
    }

    @Override
    public String getNaziv() {
        return this.naziv;
    }

    @Override
    public void setNaziv(String nazivArt) {
        this.naziv = nazivArt;
    }

    public double getProcMarze() {
        return this.procMarze;
    }

    public void setProcMarze(double procMarze) {
        this.procMarze = procMarze;
    }

    @Override
    public double getProcRabata() {
        return this.procRabata == 0.0 ? this.procMarze : this.procRabata;
    }

    @Override
    public void setProcRabata(double procRabata) {
        this.procRabata = procRabata;
    }

    @Override
    public int getSort() {
        return this.sort;
    }

    @Override
    public void setSort(int sort) {
        this.sort = sort;
    }

    public double getTemp() {
        return this.temp;
    }

    public void setTemp(double temp) {
        this.temp = temp;
    }

    public double getUlCena() {
        return this.ulCena;
    }

    public void setUlCena(double ulCena) {
        this.ulCena = ulCena;
    }

    public BigDecimal getUlProdCena() {
        return this.ulProdCena;
    }

    public void setUlProdCena(BigDecimal ulProdCena) {
        this.ulProdCena = ulProdCena;
    }

    public BigDecimal getIzlProdCena() {
        return this.izlProdCena;
    }

    public void setIzlProdCena(BigDecimal izlProdCena) {
        this.izlProdCena = izlProdCena;
    }

    public BigDecimal getUlProsNabCena() {
        return this.ulProsNabCena;
    }

    public void setUlProsNabCena(BigDecimal upProsNabCena) {
        this.ulProsNabCena = upProsNabCena;
    }

    public BigDecimal getIzlProsNabCena() {
        return this.izlProsNabCena;
    }

    public void setIzlProsNabCena(BigDecimal izlProsNabCena) {
        this.izlProsNabCena = izlProsNabCena;
    }

    public List<Airtaksa> getAirtaksas() {
        return this.airtaksas;
    }

    public void setAirtaksas(List<Airtaksa> airtaksas) {
        this.airtaksas = airtaksas;
    }

    public Interniracun getInterniracun() {
        return this.interniracun;
    }

    public void setInterniracun(Interniracun interniracun) {
        this.interniracun = interniracun;
    }

    @Override
    public Artikal getArtikal() {
        return this.artikal;
    }

    @Override
    public void setArtikal(Artikal artikal) {
        this.artikal = artikal;
    }

    @Override
    public String[] getColumnNames() {
        if (this.interniracun.getTip().equals(TipDokumentConfig.get().DOSTAVNICA)) {
            return new String[]{"\u0160ifra", "Naziv", "JM", "Koli\u010dina", "Izlazna cena", "Ulazna cena", "Izlazna vrednost", "Ulazna vrednost"};
        }
        return new String[]{"\u0160ifra", "Naziv", "JM", "Koli\u010dina", "Izlazna cena", "Ulazna cena"};
    }

    @Override
    public Object[] getValues() {
        if (this.interniracun.getTip().equals(TipDokumentConfig.get().DOSTAVNICA)) {
            return new Object[]{this.id.getSfrProizvod(), this.naziv, this.jm, this.kolicina, this.izlCena, this.ulCena, this.kolicina * this.izlCena, this.kolicina * this.ulCena};
        }
        return new Object[]{this.id.getSfrProizvod(), this.naziv, this.jm, this.kolicina, this.izlCena, this.ulCena};
    }

    @Override
    public Object[] getKValues() {
        String nazivDokumenta = "Greska u formiranju naloga";
        if (this.interniracun.getTip().equals("INTERNI_NALOG")) {
            nazivDokumenta = this.interniracun.getStorno() == 0 ? "Interni ra\u010dun" : "Storno internog ra\u010duna";
        }
        Object[] objectArray = new Object[16];
        objectArray[0] = this.interniracun.getDatum();
        objectArray[2] = this.interniracun.getrBroj();
        objectArray[3] = nazivDokumenta;
        objectArray[5] = this.isUlaz() ? this.getUlCena() : this.getIzlCena();
        objectArray[6] = this.isUlaz() ? this.getKolicina() : 0.0;
        objectArray[7] = !this.isUlaz() ? this.getKolicina() : 0.0;
        objectArray[9] = this.procRabata;
        objectArray[10] = this.isUlaz() ? this.getKolicina() * this.getUlCena() : 0.0;
        objectArray[11] = !this.isUlaz() ? this.getKolicina() * this.getIzlCena() : 0.0;
        objectArray[15] = "";
        return objectArray;
    }

    public void setUlaz(boolean ulaz) {
        this.ulaz = ulaz;
    }

    public boolean isUlaz() {
        return this.ulaz;
    }

    @Override
    public double getCena() {
        if (this.getVrsta().equals("U")) {
            return this.ulCena;
        }
        return this.izlCena;
    }

    @Override
    public String getSifra() {
        return this.id.getSfrProizvod();
    }

    @Override
    public PzDokument getDokument() {
        return this.interniracun;
    }

    @Override
    public void setDokument(PzDokument dokument) {
        this.interniracun = (Interniracun)dokument;
    }

    @Override
    public void addTaksa(Tarifnagrupa tgr) {
        if (this.airtaksas == null) {
            this.airtaksas = new IndirectList();
        }
        this.airtaksas.add(new Airtaksa(this, tgr));
    }

    @Override
    public void setCena(double cena) {
        this.ulCena = cena;
        this.ulProdCena = new BigDecimal(Double.toString(cena));
    }

    @Override
    public void setId(int dokId, String artId, int rBroj) {
        this.id = new ArtikalinterniracunPK(dokId, artId, rBroj);
    }

    @Override
    public Usluga getUsluga() {
        return null;
    }

    @Override
    public void setUsluga(Usluga usluga) {
    }

    @Override
    public List<? extends PzADTaksa> getTaksas() {
        return this.airtaksas;
    }

    @Override
    public BigDecimal getProdCena() {
        if (this.getVrsta().equals("U")) {
            return this.ulProdCena;
        }
        return this.izlProdCena;
    }

    @Override
    public void setProdCena(BigDecimal prodCena) {
    }

    @Override
    public BigDecimal getProsNabCena() {
        if (this.getVrsta().equals("U")) {
            return this.ulProsNabCena;
        }
        return this.izlProsNabCena;
    }

    @Override
    public void setProsNabCena(BigDecimal prosNabCena) {
    }

    @Override
    public double getCena(boolean izlaznaRJ) {
        if (izlaznaRJ) {
            return this.izlCena;
        }
        return this.ulCena;
    }
}

