/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Taksaopstidokument;
import rs.pezar.db.entity.Tarifnagrupa;

@Entity
@DiscriminatorValue(value="FISKALNI_IZVESTAJ")
public class FiskalniIzvestaj
extends Opstidokument
implements Serializable {
    @Column(name="dbl1")
    private double gotovina;
    @Column(name="dbl2")
    private double cekovi;
    @Column(name="dbl3")
    private double platneKartice;
    @Column(name="dbl4")
    private double fakture;
    @Column(name="dbl5")
    private double ukupno;
    @Column(name="dbl7")
    private double uslugeBezPdv;
    @Column(name="dbl8")
    private double uslugePdvIznos;
    @Column(name="int2")
    private Integer fizickoLice = new Integer(0);

    public double getGotovina() {
        return this.gotovina;
    }

    public void setGotovina(double gotovina) {
        this.gotovina = gotovina;
    }

    public double getCekovi() {
        return this.cekovi;
    }

    public void setCekovi(double cekovi) {
        this.cekovi = cekovi;
    }

    public double getPlatneKartice() {
        return this.platneKartice;
    }

    public void setPlatneKartice(double platneKartice) {
        this.platneKartice = platneKartice;
    }

    public double getFakture() {
        return this.fakture;
    }

    public void setFakture(double fakture) {
        this.fakture = fakture;
    }

    public double getUkupno() {
        return this.ukupno;
    }

    public void setUkupno(double ukupno) {
        this.ukupno = ukupno;
    }

    public double getUslugeBezPdv() {
        return this.uslugeBezPdv;
    }

    public void setUslugeBezPdv(double uslugeBezPdv) {
        this.uslugeBezPdv = uslugeBezPdv;
    }

    public double getUslugePdvIznos() {
        return this.uslugePdvIznos;
    }

    public void setUslugePdvIznos(double uslugePdvIznos) {
        this.uslugePdvIznos = uslugePdvIznos;
    }

    public Integer getFizickoLice() {
        return this.fizickoLice;
    }

    public void setFizickoLice(Integer fizickoLice) {
        this.fizickoLice = fizickoLice;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Br.fis.izvestaja", "Datum", "Proknji\u017een", "Gotovina", "\u010cekovi", "Pl.kartice", "Ostalo", "Ukupan pazar", "PDV", "Dokument arhivirao", "iddok"};
    }

    @Override
    public Object[] getValues() {
        BigDecimal pdv = new BigDecimal(0);
        for (Taksaopstidokument t : this.getTaksaopstidokuments()) {
            if (!t.getVrsta().equals("PDV")) continue;
            pdv = pdv.add(t.getIznos());
        }
        return new Object[]{this.getOznDokumenta(), this.getDatum(), this.getProknjizen() == 1 ? "DA" : "NE", this.gotovina, this.cekovi, this.platneKartice, this.fakture, this.gotovina + this.cekovi + this.platneKartice + this.fakture, pdv, this.getUserKraj().getPzusername(), this.getIdDok()};
    }

    private BigDecimal getUsluge() {
        return new BigDecimal(this.uslugeBezPdv + this.uslugePdvIznos);
    }

    @Override
    public Artikalopstidokument getArtikal(String sfrA, int idDok) {
        for (Artikalopstidokument af : this.getArtikalopstidokuments()) {
            if (!af.getId().getSfrProizvod().equals(sfrA) || af.getOpstidokument().getIdDok() != idDok) continue;
            return af;
        }
        return null;
    }

    @Override
    public String getVrsta() {
        return "I";
    }

    @Override
    public boolean obracunavaSePorez(Tarifnagrupa tg, String tip) {
        return false;
    }

    @Override
    public void izracunajVrednostRobe() {
        if (this.getArtikalDocuments() != null && this.getArtikalDocuments().size() > 0) {
            BigDecimal vrednostR = new BigDecimal(0);
            BigDecimal vrednostU = new BigDecimal(0);
            for (PzArtikalDokument pzArtikalDokument : this.getArtikalDocuments()) {
                BigDecimal kolicina;
                if (pzArtikalDokument.getTaksa("PDV") != null && !pzArtikalDokument.getTaksa("PDV").getOznTarGr().startsWith("U")) {
                    kolicina = BDConverter.getKolicina(pzArtikalDokument.getKolicina());
                    BigDecimal prodCena = pzArtikalDokument.getProdCena();
                    BigDecimal prnc = pzArtikalDokument.getProsNabCena();
                    if (this.getCvProdajna() == 1) {
                        vrednostR = vrednostR.add(BDConverter.getIznos(prodCena.multiply(kolicina)));
                        continue;
                    }
                    vrednostR = vrednostR.add(prnc.multiply(kolicina));
                    continue;
                }
                kolicina = BDConverter.getKolicina(pzArtikalDokument.getKolicina());
                BigDecimal cena = BDConverter.getDefaultBigDecimal(pzArtikalDokument.getCena());
                vrednostU = vrednostU.add(cena.multiply(kolicina));
            }
            vrednostR.add(this.getIznosSaPorezom().subtract(this.getUsluge()));
            vrednostU.add(this.getUsluge());
            this.setVrednostRobe(BDConverter.getIznos(vrednostR));
            this.setVrednostUsluga(BDConverter.getIznos(vrednostU));
        } else {
            this.setVrednostRobe(BDConverter.getIznos(this.getIznosSaPorezom().subtract(this.getUsluge())));
            this.setVrednostUsluga(BDConverter.getIznos(this.getUsluge()));
        }
    }
}

