/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Robnagrupa;

@Entity
@Table(name="RabatnaSkala")
public class Rabatnaskala
implements Serializable,
PzEntity {
    private static final long serialVersionUID = 1L;
    @Id
    private int oznRabatnaSkala;
    @Column(nullable=false)
    private double procenat;
    private boolean zakljucan;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="oznRobGr", nullable=false)
    private Robnagrupa robnagrupa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="sfrKomitent")
    private Komitent komitent;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="sfrProizvod", nullable=false)
    private Artikal artikal;

    public Rabatnaskala(Robnagrupa robnagrupa, Komitent komitent, Artikal artikal, double procenat) {
        this.procenat = procenat;
        this.robnagrupa = robnagrupa;
        this.komitent = komitent;
        this.artikal = artikal;
    }

    public Rabatnaskala() {
    }

    public int getOznRabatnaSkala() {
        return this.oznRabatnaSkala;
    }

    public void setOznRabatnaSkala(int oznRabatnaSkala) {
        this.oznRabatnaSkala = oznRabatnaSkala;
    }

    public double getProcenat() {
        return this.procenat;
    }

    public void setProcenat(double procenat) {
        this.procenat = procenat;
    }

    public boolean isZakljucan() {
        return this.zakljucan;
    }

    public void setZakljucan(boolean zakljucan) {
        this.zakljucan = zakljucan;
    }

    public Robnagrupa getRobnagrupa() {
        return this.robnagrupa;
    }

    public void setRobnagrupa(Robnagrupa robnagrupa) {
        this.robnagrupa = robnagrupa;
    }

    public Komitent getKomitent() {
        return this.komitent;
    }

    public void setKomitent(Komitent komitent) {
        this.komitent = komitent;
    }

    public Artikal getArtikal() {
        return this.artikal;
    }

    public void setArtikal(Artikal artikal) {
        this.artikal = artikal;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Robna grupa", "Naziv", "Sifra kupca", "Artikal", "% rabata", "Zaklju\u010dan\u043e"};
    }

    @Override
    public Object[] getValues() {
        String sfrKupac = this.komitent == null ? "" : this.komitent.getSfrKomitent();
        String sifArtikal = this.artikal == null ? "" : this.artikal.getSfrProizvod();
        String oznRg = this.robnagrupa == null ? "" : this.robnagrupa.getOznRobGr();
        String nazivRg = this.robnagrupa == null ? "" : this.robnagrupa.getNaziv();
        return new Object[]{oznRg, nazivRg, sfrKupac, sifArtikal, this.procenat, this.zakljucan ? "DA" : "NE"};
    }
}

