/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.util.List;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Brojacrj;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturausluga;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Konsignacija;
import rs.pezar.db.entity.Lokacija;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Nzk;
import rs.pezar.db.entity.Ogranak;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.RadnajedinicaPK;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.db.entity.Stavkakarticeartikla;

@Entity
@Table(name="RadnaJedinica")
public class Radnajedinica
implements Serializable,
PzEntity {
    private static final long serialVersionUID = 1L;
    public static final String CENE_PRODAJNE = "PRODAJNA";
    public static final String CENE_PROSECNE_NABAVNE = "PRNC";
    public static final String CENE_PLANSKE = "PLANSKA";
    public static final String MINUS_DOZVOLJEN = "DOZVOLJEN";
    public static final String MINUS_ZABRANJEN = "ZABRANJEN";
    public static final String MINUS_KONSIGNACIJA = "KONSIGNACIJA";
    @EmbeddedId
    private RadnajedinicaPK id;
    private String adresa;
    private String grupaMagacina;
    private String gTip;
    private String mesto;
    private String nacinVodjenja;
    private String naziv;
    private String minusKolicine;
    private short preuzimanjeSaKons;
    private String ppTip;
    private String pTip;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="refOgranak", referencedColumnName="OZNOGRANAK"), @JoinColumn(name="refRj", referencedColumnName="OZNRJ")})
    private Radnajedinica refRadnajedinica;
    @OneToMany(mappedBy="konsignacija")
    private List<Artikal> artikals;
    @OneToMany(mappedBy="radnajedinica")
    private List<Dokument> dokuments;
    @OneToMany(mappedBy="radnajedinica")
    private List<Faktura> fakturas;
    @OneToMany(mappedBy="radnajedinica")
    private List<Fakturausluga> fakturauslugas;
    @OneToMany(mappedBy="ulaznaRJ")
    private List<Interniracun> interniracuns1;
    @OneToMany(mappedBy="izlaznaRJ")
    private List<Interniracun> interniracuns2;
    @OneToMany(mappedBy="radnajedinica")
    private List<Kalkulacija> kalkulacijas;
    @OneToMany(mappedBy="radnajedinica")
    private List<Konsignacija> konsignacijas;
    @OneToMany(mappedBy="radnajedinica")
    private List<Nivelacija> nivelacijas;
    @OneToMany(mappedBy="radnajedinica")
    private List<Nzk> nzks;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="sfrKomitent")
    private Komitent komitent;
    @OneToMany(mappedBy="radnajedinica")
    private List<Brojacrj> brojacrjs;
    @OneToMany(mappedBy="radnajedinica")
    private List<Lokacija> lokacijas;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="oznOgranak", nullable=false, insertable=false, updatable=false)
    private Ogranak ogranak;
    @OneToMany(mappedBy="radnajedinica")
    private List<Opstidokument> opstidokuments;
    @OneToMany(mappedBy="radnajedinica")
    private List<Stanje> stanjes;
    @OneToMany(mappedBy="radnajedinica")
    private List<Stanjeartikal> stanjeartikals;
    @OneToMany(mappedBy="radnajedinica")
    private List<Stavkakarticeartikla> stavkakarticeartiklas;

    public Radnajedinica() {
    }

    public Radnajedinica(RadnajedinicaPK pk, String adresa, String mesto, String naziv, String tip, String grupaMagacina) {
        this.id = pk;
        this.adresa = adresa;
        this.mesto = mesto;
        this.naziv = naziv;
        this.setTip(tip);
        this.grupaMagacina = grupaMagacina;
    }

    public RadnajedinicaPK getId() {
        return this.id;
    }

    public void setId(RadnajedinicaPK id) {
        this.id = id;
    }

    public String getAdresa() {
        return this.adresa;
    }

    public void setAdresa(String adresa) {
        this.adresa = adresa;
    }

    public String getGrupaMagacina() {
        return this.grupaMagacina;
    }

    public void setGrupaMagacina(String grupaMagacina) {
        this.grupaMagacina = grupaMagacina;
    }

    public String getgTip() {
        return this.gTip;
    }

    public void setgTip(String gTip) {
        this.gTip = gTip;
    }

    public String getMesto() {
        return this.mesto;
    }

    public void setMesto(String mesto) {
        this.mesto = mesto;
    }

    public String getNaziv() {
        return this.naziv;
    }

    public void setNaziv(String naziv) {
        this.naziv = naziv;
    }

    public String getPpTip() {
        return this.ppTip;
    }

    public void setPpTip(String ppTip) {
        this.ppTip = ppTip;
    }

    public String getpTip() {
        return this.pTip;
    }

    public void setpTip(String pTip) {
        this.pTip = pTip;
    }

    public String getNacinVodjenja() {
        return this.nacinVodjenja;
    }

    public void setNacinVodjenja(String nacinVodjenja) {
        this.nacinVodjenja = nacinVodjenja;
    }

    public String getMinusKolicine() {
        return this.minusKolicine;
    }

    public void setMinusKolicine(String minus) {
        this.minusKolicine = minus;
    }

    public short getPreuzimanjeSaKons() {
        return this.preuzimanjeSaKons;
    }

    public void setPreuzimanjeSaKons(short preuzimanjeSaKons) {
        this.preuzimanjeSaKons = preuzimanjeSaKons;
    }

    public void setArtikals(List<Artikal> artikals) {
        this.artikals = artikals;
    }

    public List<Artikal> getArtikals() {
        return this.artikals;
    }

    public List<Dokument> getDokuments() {
        return this.dokuments;
    }

    public void setDokuments(List<Dokument> dokuments) {
        this.dokuments = dokuments;
    }

    public List<Faktura> getFakturas() {
        return this.fakturas;
    }

    public void setFakturas(List<Faktura> fakturas) {
        this.fakturas = fakturas;
    }

    public List<Fakturausluga> getFakturauslugas() {
        return this.fakturauslugas;
    }

    public void setFakturauslugas(List<Fakturausluga> fakturauslugas) {
        this.fakturauslugas = fakturauslugas;
    }

    public List<Interniracun> getInterniracuns1() {
        return this.interniracuns1;
    }

    public void setInterniracuns1(List<Interniracun> interniracuns1) {
        this.interniracuns1 = interniracuns1;
    }

    public List<Interniracun> getInterniracuns2() {
        return this.interniracuns2;
    }

    public void setInterniracuns2(List<Interniracun> interniracuns2) {
        this.interniracuns2 = interniracuns2;
    }

    public List<Kalkulacija> getKalkulacijas() {
        return this.kalkulacijas;
    }

    public void setKalkulacijas(List<Kalkulacija> kalkulacijas) {
        this.kalkulacijas = kalkulacijas;
    }

    public List<Konsignacija> getKonsignacijas() {
        return this.konsignacijas;
    }

    public void setKonsignacijas(List<Konsignacija> konsignacijas) {
        this.konsignacijas = konsignacijas;
    }

    public List<Nivelacija> getNivelacijas() {
        return this.nivelacijas;
    }

    public void setNivelacijas(List<Nivelacija> nivelacijas) {
        this.nivelacijas = nivelacijas;
    }

    public Komitent getKomitent() {
        return this.komitent;
    }

    public void setKomitent(Komitent komitent) {
        this.komitent = komitent;
    }

    public List<Nzk> getNzks() {
        return this.nzks;
    }

    public void setNzks(List<Nzk> nzks) {
        this.nzks = nzks;
    }

    public List<Brojacrj> getBrojacrjs() {
        return this.brojacrjs;
    }

    public void setBrojacrjs(List<Brojacrj> brojacrjs) {
        this.brojacrjs = brojacrjs;
    }

    public List<Lokacija> getLokacijas() {
        return this.lokacijas;
    }

    public void setLokacijas(List<Lokacija> lokacijas) {
        this.lokacijas = lokacijas;
    }

    public Ogranak getOgranak() {
        return this.ogranak;
    }

    public void setOgranak(Ogranak ogranak) {
        this.ogranak = ogranak;
    }

    public List<Opstidokument> getOpstidokuments() {
        return this.opstidokuments;
    }

    public void setOpstidokuments(List<Opstidokument> opstidokuments) {
        this.opstidokuments = opstidokuments;
    }

    public List<Stanje> getStanjes() {
        return this.stanjes;
    }

    public void setStanjes(List<Stanje> stanjes) {
        this.stanjes = stanjes;
    }

    public void setStanjeartikals(List<Stanjeartikal> stanjeartikals) {
        this.stanjeartikals = stanjeartikals;
    }

    public List<Stanjeartikal> getStanjeartikals() {
        return this.stanjeartikals;
    }

    public List<Stavkakarticeartikla> getStavkakarticeartiklas() {
        return this.stavkakarticeartiklas;
    }

    public void setStavkakarticeartiklas(List<Stavkakarticeartikla> stavkakarticeartiklas) {
        this.stavkakarticeartiklas = stavkakarticeartiklas;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Naziv", "Oznaka", "Mesto", "Adresa", "Tip"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.naziv, this.id.getOznRj(), this.mesto, this.adresa, String.valueOf(this.getgTip()) + this.getpTip() + this.getPpTip()};
    }

    public String getPunNaziv() {
        return "[ " + PzEntityUtil.strZero(this.id.getOznRj(), 3) + " ] " + this.naziv;
    }

    public String getSkracenNaziv() {
        return String.valueOf(PzEntityUtil.strZero(this.id.getOznRj(), 3)) + ", " + this.naziv;
    }

    public String getTip() {
        return String.valueOf(this.getgTip()) + this.getpTip() + this.getPpTip();
    }

    public void setTip(String tip) {
        this.setgTip("");
        this.setpTip("");
        this.setPpTip("");
        if (tip.length() > 0) {
            this.setgTip(String.valueOf(tip.charAt(0)));
            if (tip.length() > 1) {
                this.setpTip(String.valueOf(tip.charAt(1)));
                if (tip.length() > 2) {
                    this.setPpTip(String.valueOf(tip.charAt(2)));
                }
            }
        }
    }

    public Radnajedinica getRefRadnajedinica() {
        return this.refRadnajedinica;
    }

    public void setRefRadnajedinica(Radnajedinica refRadnajedinica) {
        this.refRadnajedinica = refRadnajedinica;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.adresa == null ? 0 : this.adresa.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.mesto == null ? 0 : this.mesto.hashCode());
        return result;
    }
}

