/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.entity.SfutaksaPK;
import rs.pezar.db.entity.Stavkafaktureusl;
import rs.pezar.db.entity.Tarifnagrupa;

@Entity
@Table(name="SFUTaksa")
public class Sfutaksa
extends PzADTaksa
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private SfutaksaPK id;
    @Column(nullable=false)
    private double stopa;
    @Column(nullable=false)
    private String oznVrstaTG;
    @Column(nullable=false)
    private String opis;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="idDok", referencedColumnName="IDDOK", nullable=false, insertable=false, updatable=false), @JoinColumn(name="rBroj", referencedColumnName="RBROJ", nullable=false, insertable=false, updatable=false)})
    private Stavkafaktureusl stavkafaktureusl;

    public Sfutaksa() {
    }

    public Sfutaksa(Stavkafaktureusl stavkafaktureusl, Tarifnagrupa tgr) {
        this.id = new SfutaksaPK(stavkafaktureusl.getId().getIdDok(), tgr.getOznTarGr(), stavkafaktureusl.getId().getrBroj());
        this.stavkafaktureusl = stavkafaktureusl;
        this.opis = tgr.getVrstatg().getOpis();
        this.stopa = tgr.getStopa();
        this.oznVrstaTG = tgr.getVrstatg().getOznVrstaTG();
    }

    public SfutaksaPK getId() {
        return this.id;
    }

    public void setId(SfutaksaPK id) {
        this.id = id;
    }

    @Override
    public double getStopa() {
        return this.stopa;
    }

    public void setStopa(double stopa) {
        this.stopa = stopa;
    }

    public Stavkafaktureusl getStavkafaktureusl() {
        return this.stavkafaktureusl;
    }

    public void setStavkafaktureusl(Stavkafaktureusl stavkafaktureusl) {
        this.stavkafaktureusl = stavkafaktureusl;
    }

    @Override
    public String getOznVrstaTG() {
        return this.oznVrstaTG;
    }

    public void setOznVrstaTG(String oznaka) {
        this.oznVrstaTG = oznaka;
    }

    @Override
    public String getOpis() {
        return this.opis;
    }

    public void setOpis(String opis) {
        this.opis = opis;
    }

    @Override
    public String getOznTarGr() {
        return this.id.getOznTarGr();
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Oznaka TG", "Vrsta TG", "Stopa", "Opis"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.id.getOznTarGr(), this.oznVrstaTG, this.stopa, this.opis};
    }
}

