/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.UftaksaPK;
import rs.pezar.db.entity.Uslugafaktura;

@Entity
@Table(name="UFTaksa")
public class Uftaksa
extends PzADTaksa
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private UftaksaPK id;
    private String opis;
    private String oznVrstaTG;
    private double stopa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="idDok", referencedColumnName="IDDOK", nullable=false, insertable=false, updatable=false), @JoinColumn(name="rBroj", referencedColumnName="RBROJ", nullable=false, insertable=false, updatable=false)})
    private Uslugafaktura uslugafaktura;

    public Uftaksa() {
    }

    public Uftaksa(Uslugafaktura uslugaFaktura2, Tarifnagrupa tgr) {
        this.id = new UftaksaPK(uslugaFaktura2.getId().getIdDok(), tgr.getOznTarGr(), uslugaFaktura2.getId().getrBroj());
        this.uslugafaktura = uslugaFaktura2;
        this.opis = tgr.getVrstatg().getOpis();
        this.stopa = tgr.getStopa();
        this.oznVrstaTG = tgr.getVrstatg().getOznVrstaTG();
    }

    public UftaksaPK getId() {
        return this.id;
    }

    public void setId(UftaksaPK id) {
        this.id = id;
    }

    @Override
    public String getOpis() {
        return this.opis;
    }

    public void setOpis(String opis) {
        this.opis = opis;
    }

    @Override
    public String getOznVrstaTG() {
        return this.oznVrstaTG;
    }

    public void setOznVrstaTG(String oznvrstatg) {
        this.oznVrstaTG = oznvrstatg;
    }

    @Override
    public double getStopa() {
        return this.stopa;
    }

    public void setStopa(double stopa) {
        this.stopa = stopa;
    }

    public Uslugafaktura getUslugafaktura() {
        return this.uslugafaktura;
    }

    public void setUslugafaktura(Uslugafaktura uslugafaktura) {
        this.uslugafaktura = uslugafaktura;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Oznaka TG", "Vrsta TG", "Stopa", "Opis"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.id.getOznTarGr(), this.oznVrstaTG, this.stopa, this.opis};
    }

    @Override
    public String getOznTarGr() {
        return this.id.getOznTarGr();
    }
}

