/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.ext.LockableUI;
import org.jdesktop.swingx.painter.BusyPainter;

public class PzBusyPainterUI
extends LockableUI
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private BusyPainter busyPainter = new BusyPainter();
    private Timer timer;
    private int frameNumber;

    public PzBusyPainterUI() {
        this.busyPainter.setPaintCentered(true);
        this.busyPainter.setPointShape((Shape)new Ellipse2D.Double(0.0, 0.0, 20.0, 20.0));
        this.busyPainter.setTrajectory((Shape)new Ellipse2D.Double(0.0, 0.0, 100.0, 100.0));
        this.timer = new Timer(100, this);
    }

    protected void paintLayer(Graphics2D g2, JXLayer<? extends JComponent> l) {
        super.paintLayer(g2, l);
        if (this.isLocked()) {
            this.busyPainter.paint(g2, l, l.getWidth(), l.getHeight());
        }
    }

    public void setLocked(boolean isLocked) {
        super.setLocked(isLocked);
        if (isLocked) {
            this.timer.start();
        } else {
            this.timer.stop();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.frameNumber = (this.frameNumber + 1) % 8;
        this.busyPainter.setFrame(this.frameNumber);
        this.setDirty(true);
    }
}

