/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzButtonPanel;
import rs.pezar.swing.PzImagePanel;
import rs.pezar.swing.PzPanel;

public class PzImageContainer
extends PzPanel
implements ActionListener {
    private static final long serialVersionUID = -1054123642486138197L;
    private PzImagePanel pnlSlika;
    private PzButtonPanel btnPanel;
    public PzButton btnNapred;
    private Vector<String> images;
    public PzButton btnNazad;
    public JLabel lblNemaSlike;
    private int p = 0;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new PzImageContainer());
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public PzImageContainer() {
        this.initGUI();
    }

    public void setImages(Vector<String> images) {
        if (images == null || images.size() == 0) {
            this.pnlSlika.paintImage(null);
            this.images = null;
            return;
        }
        this.p = 0;
        this.btnNazad.setEnabled(false);
        this.images = images;
        this.pnlSlika.paintImage(images.elementAt(0));
    }

    public Vector<String> getImages() {
        return this.images;
    }

    public void setIndex(int p) {
        this.p = p;
        if (p > 0) {
            this.btnNazad.setEnabled(true);
        }
        if (p == this.images.size() - 1) {
            this.btnNapred.setEnabled(false);
        }
        this.pnlSlika.paintImage(this.images.elementAt(p));
    }

    public int getIndex() {
        return this.p;
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            thisLayout.columnWeights = new double[]{0.1};
            thisLayout.columnWidths = new int[]{7};
            thisLayout.rowWeights = new double[]{0.0, 0.1};
            thisLayout.rowHeights = new int[]{164, 7};
            this.setLayout(thisLayout);
            this.setPreferredSize(new Dimension(300, 200));
            this.pnlSlika = new PzImagePanel();
            this.add((Component)this.pnlSlika, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlSlika.setContainer(this);
            this.btnPanel = new PzButtonPanel();
            this.add((Component)this.btnPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnNazad = new PzButton();
            this.btnPanel.add(this.btnNazad);
            this.btnNazad.setText("Prethodna");
            this.btnNazad.setActionCommand("Nazad");
            this.btnNazad.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/navigate_left.png")));
            this.btnNazad.setPreferredSize(new Dimension(115, 23));
            this.btnNazad.setSize(120, 23);
            this.btnNazad.setToolTipText("Prethodna slika");
            this.btnNazad.addActionListener(this);
            this.btnNapred = new PzButton();
            this.btnPanel.add(this.btnNapred);
            this.btnNapred.setText("Slede\u0107a     ");
            this.btnNapred.setHorizontalTextPosition(2);
            this.btnNapred.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/navigate_right.png")));
            this.btnNapred.setActionCommand("Napred");
            this.btnNapred.setHorizontalAlignment(10);
            this.btnNapred.setSize(120, 23);
            this.btnNapred.setPreferredSize(new Dimension(115, 23));
            this.btnNapred.setToolTipText("Sledeca slika");
            this.btnNapred.addActionListener(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String actionCommand = arg0.getActionCommand();
        if (actionCommand.equalsIgnoreCase("Napred")) {
            this.next();
        } else if (actionCommand.equalsIgnoreCase("Nazad")) {
            this.prev();
        }
    }

    private void next() {
        ++this.p;
        if (this.p == this.images.size() - 1) {
            this.btnNapred.setEnabled(false);
        }
        this.btnNazad.setEnabled(true);
        this.pnlSlika.paintImage(this.images.elementAt(this.p));
    }

    private void prev() {
        --this.p;
        if (this.p == 0) {
            this.btnNazad.setEnabled(false);
        }
        this.btnNapred.setEnabled(true);
        this.pnlSlika.paintImage(this.images.elementAt(this.p));
    }
}

