/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing;

import com.cloudgarden.layout.AnchorConstraint;
import java.awt.Component;
import java.util.List;
import java.util.Vector;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzWidget;
import rs.pezar.swing.WorkArea;
import rs.pezar.swing.event.PzWorkAreaListener;

public class PzWorkArea
extends PzPanel
implements WorkArea {
    private static final long serialVersionUID = 3374218881744445906L;
    private Vector<PzWidget> widgets = new Vector();
    private Vector<PzWorkAreaListener> listeners = new Vector();

    public void add(PzWidget newPzWidget, AnchorConstraint constraint) {
        this.widgets.add(newPzWidget);
        this.add((Component)newPzWidget, (Object)constraint);
        this.fireWidgetAdded(newPzWidget);
    }

    @Override
    public List<PzWidget> getWidgets() {
        return this.widgets;
    }

    @Override
    public void addWorkAreaListener(PzWorkAreaListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public List<PzWorkAreaListener> getWorkAreaListeners() {
        return this.listeners;
    }

    public void add(PzWidget widget, Integer x, Integer y) {
        this.add(widget, new AnchorConstraint(y, x + widget.getWidth(), y + widget.getHeight(), x, 0, 0, 0, 0));
    }

    @Override
    public void removeWidget(PzWidget widget) {
        this.remove(widget);
        this.widgets.remove(widget);
        this.fireWidgetRemoved(widget);
    }

    @Override
    public void removeWidget(String widgetID) {
        PzWidget w = null;
        for (PzWidget widget : this.widgets) {
            if (!widget.getID().equals(widgetID)) continue;
            w = widget;
            break;
        }
        if (w != null) {
            this.remove(w);
            this.widgets.remove(w);
        }
    }

    private void fireWidgetAdded(PzWidget widget) {
        for (PzWorkAreaListener listener : this.listeners) {
            listener.widgetAdded(widget);
        }
    }

    private void fireWidgetRemoved(PzWidget widget) {
        for (PzWorkAreaListener listener : this.listeners) {
            listener.widgetRemoved(widget);
        }
    }

    @Override
    public PzWidget getWidgetById(String id) {
        PzWidget res = null;
        for (PzWidget widget : this.widgets) {
            if (!widget.getID().equals(id)) continue;
            res = widget;
            break;
        }
        return res;
    }

    @Override
    public void add(PzWidget newPzWidget) {
        this.widgets.add(newPzWidget);
        this.add((Component)newPzWidget);
        this.fireWidgetAdded(newPzWidget);
    }

    @Override
    public void add(List<PzWidget> widgets) {
    }

    @Override
    public void initData() {
    }

    @Override
    public void applyDefaultVisibility() {
    }
}

