/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.custom;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTree;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Robnagrupa;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.data.models.PzTreeModelRG;
import rs.pezar.swing.util.PzSwingUtility;

public class PzTreeRobneGrupe
extends JXTree {
    private PzTreeModelRG model;

    public PzTreeRobneGrupe() {
        this.addKeyListener(new TrListenerRG());
        this.addMouseListener(new TrListenerRG());
        this.setRowHeight(0);
        BasicTreeUI basicTreeUI = (BasicTreeUI)this.getUI();
        basicTreeUI.setRightChildIndent(25);
        basicTreeUI.setLeftChildIndent(10);
    }

    public void loadDataFromDB() throws Exception {
        Vector<PzEntity> robneGrupe = PzEntityManager.select("SELECT r FROM Robnagrupa r WHERE r.nadGrupa IS NULL ORDER BY r.oznRobGr");
        this.setData(robneGrupe);
    }

    public void setData(Vector<Robnagrupa> data) {
        PzTreeModelRG model;
        this.model = model = new PzTreeModelRG();
        model.setData(data);
        this.setModel(model);
        model.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{data}));
    }

    public void insertChildNode(Robnagrupa rgr) throws Exception {
        Robnagrupa parent = this.getSelectionPath() != null ? (Robnagrupa)this.getSelectionPath().getLastPathComponent() : null;
        this.model.insertNode(parent, rgr);
        Vector<Object> array = new Vector<Object>();
        Robnagrupa tmp = rgr.getNadGrupa();
        while (tmp != null) {
            array.addElement(tmp);
            tmp = tmp.getNadGrupa();
        }
        array.addElement(this.model.getRoot());
        Collections.reverse(array);
        this.model.fireTreeStructureChanged(new TreeModelEvent((Object)this, array.toArray()));
    }

    public void removeSelectedNode() throws Exception {
        if (((Robnagrupa)this.getSelectionPath().getLastPathComponent()).getPodGrupe() != null && ((Robnagrupa)this.getSelectionPath().getLastPathComponent()).getPodGrupe().size() > 0) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), "Ne mo\u017eete obrisati robnu grupu koja ima podgrupe.");
            return;
        }
        Robnagrupa rgr = (Robnagrupa)this.getSelectionPath().getLastPathComponent();
        Robnagrupa parent = rgr.getNadGrupa();
        this.model.removeNode(parent, rgr);
        Vector<Object> array = new Vector<Object>();
        Robnagrupa tmp = parent;
        while (tmp != null) {
            array.addElement(tmp);
            tmp = tmp.getNadGrupa();
        }
        array.addElement(this.model.getRoot());
        Collections.reverse(array);
        this.model.fireTreeStructureChanged(new TreeModelEvent((Object)this, array.toArray()));
    }

    public void updateSelectedNode(Robnagrupa newRgr) throws Exception {
        if ((Robnagrupa)this.getSelectionPath().getLastPathComponent() != null) {
            this.model.updateNode((Robnagrupa)this.getSelectionPath().getLastPathComponent(), newRgr);
            Robnagrupa rgr = (Robnagrupa)this.getSelectionPath().getLastPathComponent();
            Vector<Object> array = new Vector<Object>();
            Robnagrupa tmp = rgr;
            while (tmp != null) {
                array.addElement(tmp);
                tmp = tmp.getNadGrupa();
            }
            array.addElement(this.model.getRoot());
            Collections.reverse(array);
            this.model.fireTreeNodesChanged(new TreeModelEvent((Object)this, array.toArray()));
        }
    }

    public class TrListenerRG
    extends MouseAdapter
    implements KeyListener {
        private Object source;

        @Override
        public void keyPressed(KeyEvent arg0) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.source = e.getSource();
            if (e.getKeyCode() == 10) {
                TreePath selPath = ((JTree)e.getSource()).getSelectionPath();
                this.dispose(selPath);
            }
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.source = e.getSource();
            if (e.getClickCount() == 2) {
                TreePath selPath = ((JTree)e.getSource()).getPathForLocation(e.getX(), e.getY());
                this.dispose(selPath);
            }
        }

        private void dispose(TreePath selPath) {
            if (selPath != null) {
                PzTable.selectedEntity = (Robnagrupa)selPath.getLastPathComponent();
                PzTreeRobneGrupe tree = (PzTreeRobneGrupe)((Object)this.source);
                ((PzDialog)SwingUtilities.getRoot((Component)((Object)tree))).dispose();
            }
        }
    }
}

