/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.data.models;

import java.util.List;
import java.util.Vector;
import rs.pezar.db.PzEntity;
import rs.pezar.swing.data.models.PzManageableTableModel;
import rs.pezar.swing.event.PzTablePropertyListener;

public class PzTableModel
extends PzManageableTableModel {
    protected List<PzEntity> entities;
    protected PzTablePropertyListener propertyListener;

    public void setPropertyListener(PzTablePropertyListener propertyListener) {
        this.propertyListener = propertyListener;
    }

    public PzTableModel() {
        this.entities = new Vector<PzEntity>();
    }

    public PzTableModel(List<? extends PzEntity> entities) {
        this.entities = entities;
        if (entities.size() > 0) {
            this.setEntityClass(entities.get(0).getClass());
            this.fireTableDataChanged();
        }
    }

    public PzTableModel(List<? extends PzEntity> data, Class c) {
        this.setEntityClass(c);
        this.entities = data;
        this.fireTableStructureChanged();
    }

    public List<PzEntity> getEntities() {
        return this.entities;
    }

    @Override
    public PzEntity getEntity(int index) {
        if (this.entities != null && index != -1) {
            return this.entities.get(index);
        }
        return null;
    }

    @Override
    public void remove(int row) {
        PzEntity rme = this.entities.get(row);
        this.entities.remove(row);
        this.removeCheckBoxRow(row);
        if (this.propertyListener != null) {
            this.propertyListener.entityRemoved(rme);
        }
    }

    @Override
    public void insert(PzEntity e) {
        int cc = this.getColumnCount();
        this.insertCheckBoxRowAt(this.entities.size());
        this.entities.add(this.entities.size(), e);
        if (this.entities.size() == 1 && cc == 0) {
            this.columnNames = this.entities.get(0).getColumnNames();
            this.fireTableStructureChanged();
        }
        if (this.entities.size() == 1) {
            this.setEntityClass(this.entities.get(0).getClass());
        }
        if (this.propertyListener != null) {
            this.propertyListener.entityAdded(e);
        }
    }

    @Override
    public void update(int row, PzEntity e) {
        if (this.propertyListener != null) {
            this.propertyListener.entityRemoved(this.entities.get(row));
        }
        this.entities.set(row, e);
        if (this.propertyListener != null) {
            this.propertyListener.entityAdded(e);
        }
    }

    @Override
    public int getRowCount() {
        return this.entities != null ? this.entities.size() : 0;
    }

    public void setData(Vector<PzEntity> data, Class type) {
        int ccb = this.entities == null ? 0 : this.getColumnCount();
        this.setEntities(data);
        if (this.getFilter() != null) {
            this.getFilter().setEntities(this.entities);
        }
        this.setEntityClass(type);
        if (ccb != this.getColumnCount()) {
            this.fireTableStructureChanged();
        }
        this.fireTableDataChanged();
    }

    public void setData(Vector<PzEntity> data) {
        int ccb = this.entities == null ? 0 : this.getColumnCount();
        this.setEntities(data);
        this.resetCheckboxes();
        if (this.getFilter() != null) {
            this.getFilter().setEntities(this.entities);
        }
        if (ccb != this.getColumnCount()) {
            this.fireTableStructureChanged();
        }
        this.fireTableDataChanged();
    }

    public void setData(List<?> data, Class type) {
        int ccb = this.entities == null ? 0 : this.getColumnCount();
        this.setEntities(data);
        this.resetCheckboxes();
        if (this.getFilter() != null) {
            this.getFilter().setEntities(this.entities);
        }
        this.setEntityClass(type);
        if (ccb != this.getColumnCount()) {
            this.fireTableStructureChanged();
        }
        this.fireTableDataChanged();
    }

    public List<PzEntity> getData() {
        return this.entities;
    }

    public int size() {
        return this.getRowCount();
    }

    private void setEntities(List<PzEntity> data) {
        if (data == null) {
            return;
        }
        this.entities = data;
        if (this.entities.size() > 0) {
            this.columnNames = this.entities.get(0).getColumnNames();
        }
    }
}

