/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.event;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzFieldImpl;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogStarter
extends AbstractAction {
    private Class dialogClass;
    private PzFieldImpl field;
    private Class entityClass;
    private boolean showDialog;
    private String errorMessage;
    private boolean optional;

    public PzDialogStarter(Class entityClass, Class dialogClass, boolean showDialog, String errMsg, PzFieldImpl field) {
        this.dialogClass = dialogClass;
        this.entityClass = entityClass;
        this.showDialog = showDialog;
        this.errorMessage = errMsg;
        this.field = field;
        this.optional = false;
    }

    public PzDialogStarter(Class dialogClass, PzFieldImpl field) {
        this.optional = true;
        this.dialogClass = dialogClass;
        this.field = field;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.optional) {
            if (this.dialogClass != null) {
                try {
                    PzSwingUtility.showDialog(this.dialogClass, SwingUtilities.getRoot(this.field), true);
                    PzEntity selEntity = PzTable.selectedEntity;
                    ((PzDialog)SwingUtilities.getRoot(this.field)).setEntity(selEntity, this.field);
                    PzTable.selectedEntity = null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            try {
                if (this.field.getText().equals("")) {
                    if (this.dialogClass != null && this.entityClass != null) {
                        if (this.showDialog) {
                            PzSwingUtility.showDialog(this.dialogClass, SwingUtilities.getRoot(this.field));
                        } else {
                            this.field.transferFocus();
                        }
                    } else {
                        this.field.transferFocus();
                    }
                } else if (this.entityClass != null) {
                    if (!this.entityExists(this.entityClass, this.field.getVal())) {
                        PzSwingUtility.showErrorMessage(this.field, this.errorMessage);
                    } else {
                        this.field.transferFocus();
                    }
                } else {
                    this.field.transferFocus();
                }
            }
            catch (Exception e1) {
                PzMysqlExceptionHandler.handle(SwingUtilities.getRoot(this.field), e1);
            }
        }
    }

    public boolean entityExists(Class entityClass, Object pk) throws Exception {
        PzEntity entity = PzEntityManager.find(this.entityClass, pk);
        return entity != null;
    }
}

