/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.exceptionhandlers;

import java.awt.Component;
import java.awt.Window;
import java.sql.BatchUpdateException;
import java.util.concurrent.ExecutionException;
import javax.swing.FocusManager;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import rs.pezar.core.log.PzLogger;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.swing.util.PzSwingUtility;

public class PzMysqlExceptionHandler {
    public static void handle(Component parent, Throwable ex1) {
        Throwable ex;
        Throwable throwable = ex = ex1 instanceof ExecutionException ? ex1.getCause() : ex1;
        if (ex instanceof DatabaseException) {
            PzMysqlExceptionHandler.logDatabaseException((DatabaseException)ex);
            PzMysqlExceptionHandler.displayMessage((DatabaseException)ex, parent);
        } else if (ex instanceof PzInfoException) {
            if (ex.getCause() != null) {
                PzLogger.getInstance().logException(ex.getCause());
            }
            PzSwingUtility.showErrorMessage(parent, ex.getMessage());
        } else {
            PzLogger.getInstance().logException(ex);
            JXErrorPane.showDialog((Component)parent, (ErrorInfo)new ErrorInfo("Gre\u0161ka!", ex.getClass().getName(), null, null, ex, null, null));
        }
    }

    public static void handle(Throwable t) {
        Window window = FocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        PzMysqlExceptionHandler.handle(window, t);
    }

    private static void logDatabaseException(DatabaseException ex) {
        DatabaseException dbex = ex;
        PzLogger.getInstance().logError("**** DATABASE EXCEPTION **** ");
        PzLogger.getInstance().logException((Throwable)dbex);
        if (dbex.getInternalException() != null) {
            PzLogger.getInstance().logError("**** INTERNAL EXCEPTION ****");
            PzLogger.getInstance().logException(dbex.getInternalException());
            if (dbex.getInternalException() instanceof BatchUpdateException) {
                BatchUpdateException intex = (BatchUpdateException)dbex.getInternalException();
                PzLogger.getInstance().logError("**** SQL LEVEL EXCEPTION ****");
                PzLogger.getInstance().logException(intex.getNextException());
            }
        }
    }

    private static void displayMessage(DatabaseException ex, Component parent) {
        DatabaseException dbex = ex;
        StringBuffer message = new StringBuffer();
        message.append("**** DATABASE EXCEPTION **** \n");
        message.append(String.valueOf(dbex.getMessage()) + "\n");
        if (dbex.getInternalException() != null) {
            message.append("**** INTERNAL EXCEPTION **** \n");
            message.append(String.valueOf(dbex.getInternalException().getMessage()) + "\n");
            if (dbex.getInternalException() instanceof BatchUpdateException) {
                BatchUpdateException intex = (BatchUpdateException)dbex.getInternalException();
                message.append("**** SQL LEVEL EXCEPTION **** \n");
                message.append(String.valueOf(intex.getNextException().getMessage()) + "\n");
            }
        }
        JXErrorPane.showDialog((Component)parent, (ErrorInfo)new ErrorInfo("Gre\u0161ka!", "Database error", message.toString(), null, (Throwable)ex, null, null));
    }
}

