/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.renderers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.renderer.JRendererLabel;
import rs.pezar.core.format.PzFormatFactory;

public class PzTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private TableCellRenderer cellRenderer;
    private HashMap<Integer, DecimalFormat> decimalFormat = new HashMap();

    public PzTableCellRenderer() {
        this.cellRenderer = new JXTable().getDefaultRenderer(Object.class);
    }

    public PzTableCellRenderer(TableCellRenderer c) {
        this.cellRenderer = c;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JRendererLabel label = (JRendererLabel)this.cellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Color fg = null;
        if (value instanceof BigDecimal || value instanceof Double) {
            label.setHorizontalAlignment(4);
            label.setText(this.decimalFormat.get(column) != null ? this.decimalFormat.get(column).format(value) : PzFormatFactory.getDefaultDecimalFormat().format(value));
            if (value instanceof BigDecimal && ((BigDecimal)value).doubleValue() < 0.0) {
                fg = Color.RED;
            }
            if (value instanceof Double && (Double)value < 0.0) {
                fg = Color.RED;
            }
        } else if (value instanceof Date) {
            label.setHorizontalAlignment(0);
            label.setText(PzFormatFactory.getDateFormat().format(value));
        } else {
            label.setHorizontalAlignment(2);
            if (value != null) {
                label.setText(value.toString());
            }
        }
        if (fg != null && !isSelected) {
            label.setForeground(fg);
        }
        label.setFont(new Font("", 1, 12));
        return label;
    }

    public void setDecimalFormat(int column, DecimalFormat decimalFormat) {
        this.decimalFormat.put(column, decimalFormat);
    }
}

