/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.renderers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.tree.TreeCellRenderer;
import rs.pezar.db.entity.Robnagrupa;

public class PzTreeCellRendererRG
implements TreeCellRenderer {
    private Font font = new Font("Tahoma", 0, 14);
    private Color treeSelectionForeground = Color.WHITE;
    private Color treeNoSelectionForeground = UIManager.getColor("Tree.textForeground");
    private Color treeSelectionBackground = Color.BLUE;
    private Color treeNoSelectionBackground = UIManager.getColor("Tree.textBackground");

    public PzTreeCellRendererRG() {
        UIDefaults metalDefaults = new MetalLookAndFeel().getDefaults();
        metalDefaults.getIcon("FileView.directoryIcon");
        metalDefaults.getIcon("FileView.hardDriveIcon");
        metalDefaults.getIcon("FileView.fileIcon");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
        String text;
        JLabel treeCellRenderer = new JLabel();
        ImageIcon icon = null;
        if (value instanceof Vector) {
            text = "Robne grupe";
        } else {
            text = "(" + ((Robnagrupa)value).getOznRobGr() + ") " + ((Robnagrupa)value).getNaziv();
            String fName = ((Robnagrupa)value).getPodGrupe() == null || ((Robnagrupa)value).getPodGrupe().size() == 0 ? "rg_tree.png" : "rgs_tree.png";
            icon = new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/" + fName));
        }
        if (sel) {
            treeCellRenderer.setOpaque(true);
            treeCellRenderer.setBackground(this.treeSelectionBackground);
            treeCellRenderer.setForeground(this.treeSelectionForeground);
        } else {
            treeCellRenderer.setOpaque(false);
            treeCellRenderer.setBackground(this.treeNoSelectionBackground);
            treeCellRenderer.setForeground(this.treeNoSelectionForeground);
        }
        treeCellRenderer.setEnabled(tree.isEnabled());
        treeCellRenderer.setText(text);
        treeCellRenderer.setFont(this.font);
        if (icon != null) {
            treeCellRenderer.setIcon(icon);
        }
        return treeCellRenderer;
    }
}

