/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.util;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import rs.pezar.core.PzApplication;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzFileExtensionFilter;

public class PzFileUtility {
    public static File selectFile(String[] extensions, String title, PzDialog parent, int dialogType) {
        JFileChooser fc = new JFileChooser();
        if (PzApplication.getApplication().getLocalMachineUserSettings().getProperty("FILECHOOSER_DIR") != null) {
            fc.setCurrentDirectory(new File(PzApplication.getApplication().getLocalMachineUserSettings().getString("FILECHOOSER_DIR")));
        }
        fc.setDialogTitle(title);
        fc.setDialogType(dialogType);
        PzFileExtensionFilter filter = null;
        int i = 0;
        while (i < extensions.length) {
            filter = new PzFileExtensionFilter();
            filter.setExtension("." + extensions[i]);
            fc.addChoosableFileFilter(filter);
            ++i;
        }
        int rez = dialogType == 0 ? fc.showOpenDialog(parent) : fc.showSaveDialog(parent);
        if (rez == 0) {
            File selectedFile = fc.getSelectedFile();
            if (dialogType == 1 && !selectedFile.getPath().endsWith(extensions[0])) {
                selectedFile = new File(String.valueOf(selectedFile.getPath()) + "." + extensions[0]);
            }
            if (selectedFile.exists() && dialogType == 1 && JOptionPane.showConfirmDialog(parent, "Fajl sa izabranim imenom postoji. Da li \u017eelite da ga prepi\u0161ete?", "Snimanje?", 0) != 0) {
                return null;
            }
            PzApplication.getApplication().getLocalMachineUserSettings().setProperty("FILECHOOSER_DIR", selectedFile.getParent());
            return selectedFile;
        }
        return null;
    }

    public static File[] selectFiles(String[] extensions, String title, PzDialog parent) {
        JFileChooser fc = new JFileChooser();
        if (PzApplication.getApplication().getLocalMachineUserSettings().getProperty("FILECHOOSER_DIR") != null) {
            fc.setCurrentDirectory(new File(PzApplication.getApplication().getLocalMachineUserSettings().getString("FILECHOOSER_DIR")));
        }
        fc.setDialogTitle(title);
        fc.setDialogType(0);
        fc.setMultiSelectionEnabled(true);
        PzFileExtensionFilter filter = null;
        int i = 0;
        while (i < extensions.length) {
            filter = new PzFileExtensionFilter();
            filter.setExtension("." + extensions[i]);
            fc.addChoosableFileFilter(filter);
            ++i;
        }
        int rez = fc.showOpenDialog(parent);
        if (rez == 0) {
            File[] selectedFiles = fc.getSelectedFiles();
            if (selectedFiles != null && selectedFiles.length > 0) {
                PzApplication.getApplication().getLocalMachineUserSettings().setProperty("FILECHOOSER_DIR", selectedFiles[0].getParent());
            }
            return selectedFiles;
        }
        return null;
    }

    public static File selectDirectory(String title, PzDialog parent) {
        JFileChooser fc = new JFileChooser();
        fc.setDialogType(0);
        fc.setDialogTitle(title);
        fc.setFileSelectionMode(1);
        if (fc.showOpenDialog(parent) == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }
}

