/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.util;

import java.math.BigDecimal;
import javax.persistence.EntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzParameter;

public class PzBarcodeParser {
    private String tBarkodPrefiks = "28";
    private Integer tBarkodDuzinaSifre = 5;
    private Integer tBarkodDuzinaKolicine = 5;
    private Integer tBarkodBrDecimala = 3;
    public static final int SIFRA = 1;
    public static final int KOLICINA = 2;

    public void loadSettingsFromDB() {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        em.getTransaction().begin();
        this.tBarkodPrefiks = PzParameter.getParameterValue("TBARKOD_PREFIKS", "28", em);
        this.tBarkodDuzinaSifre = PzParameter.getInteger("TBARKOD_DUZ_SIFRE", new Integer(5), em);
        this.tBarkodDuzinaKolicine = PzParameter.getInteger("TBARKOD_DUZ_KOLIC", new Integer(5), em);
        this.tBarkodBrDecimala = PzParameter.getInteger("TBARKOD_DECIMALE", new Integer(3), em);
        em.getTransaction().commit();
    }

    public boolean isTezinskiBarkod(String input) {
        return input.startsWith(this.tBarkodPrefiks) && input.matches("^[0-9]{13}");
    }

    public Object getValue(String input, int value) {
        int sifraEndPos;
        int prefixLenght;
        int sifraStartPos = prefixLenght = this.tBarkodPrefiks.length();
        int kolStartPos = sifraEndPos = sifraStartPos + this.tBarkodDuzinaSifre;
        int kolEndPos = kolStartPos + this.tBarkodDuzinaKolicine;
        String sifra = input.substring(sifraStartPos, sifraEndPos);
        String kolStr = input.substring(kolStartPos, kolEndPos);
        String kolInt = kolStr.substring(0, kolStr.length() - this.tBarkodBrDecimala);
        String kolDec = kolStr.substring(kolStr.length() - this.tBarkodBrDecimala);
        BigDecimal kolicina = new BigDecimal(String.valueOf(kolInt) + "." + kolDec);
        if (value == 1) {
            return sifra;
        }
        return kolicina;
    }

    public static void main(String[] args) throws Exception {
        PzBarcodeParser p = new PzBarcodeParser();
        String input = "2800137001509";
        System.out.println(p.isTezinskiBarkod(input));
        if (p.isTezinskiBarkod(input)) {
            System.out.println("Sifra: " + p.getValue(input, 1));
            System.out.println("Kolicina: " + p.getValue(input, 2));
        }
    }
}

