/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.util;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.core.PzApplication;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.commons.PzIdGen;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Artikalfakturaparameter;
import rs.pezar.db.entity.Artikalnalog;
import rs.pezar.db.entity.ArtikalnalogPK;
import rs.pezar.db.entity.Artikalnalogprijem;
import rs.pezar.db.entity.Brojac;
import rs.pezar.db.entity.Lokacija;
import rs.pezar.db.entity.LokacijaPK;
import rs.pezar.db.entity.Nalogmagacinu;
import rs.pezar.db.entity.Nalogprijem;
import rs.pezar.db.entity.Osobinaartikla;
import rs.pezar.db.entity.OsobinaartiklaPK;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.RokTrajanja;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.db.entity.StanjeartikalPK;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.util.PzDateUtility;

public class PzMagacinUtil {
    private static String NALOG_DATUM = "NALOG_DATUM";

    public static Nalogprijem createNalogPrijem(PzDokument dokument, String napomena, EntityManager em) {
        Radnajedinica rj = dokument.getRadnajedinica();
        if (dokument == null || dokument.getArtikalDocuments() == null || dokument.getArtikalDocuments().size() == 0) {
            return null;
        }
        Nalogprijem nalog = new Nalogprijem();
        nalog.setOznNalogPrijem(PzIdGen.getNextId("NALOG_PRIJEM_ID", 1, em).getIdVal());
        nalog.setNapomena(napomena);
        nalog.setStatus(0);
        nalog.setDatNaloga(PzDateUtility.getCurrentDate());
        nalog.setDokument(dokument.getDokument());
        nalog.setRadnajedinica(dokument.getRadnajedinica());
        nalog.setPzuser(dokument.getUserKraj());
        if (dokument.getDokument().getNalogprijems() == null) {
            dokument.getDokument().setNalogprijems(new ArrayList<Nalogprijem>());
        }
        dokument.getDokument().getNalogprijems().add(nalog);
        nalog.setArtikalnalogprijems(new ArrayList<Artikalnalogprijem>());
        em.persist((Object)nalog);
        IndirectList artikalNalogprijem = new IndirectList();
        int rBroj = 0;
        String magacin = "";
        for (PzArtikalDokument pzArtikalDokument : dokument.getArtikalDocuments()) {
            Stanjeartikal stanjeArtikal = (Stanjeartikal)em.find(Stanjeartikal.class, (Object)new StanjeartikalPK(pzArtikalDokument.getId().getSfrProizvod(), rj));
            Artikalnalogprijem anp = null;
            anp = new Artikalnalogprijem();
            anp.init(nalog, rBroj);
            anp.setJm(pzArtikalDokument.getJm());
            if (stanjeArtikal != null) {
                anp.setAdresa(String.valueOf(stanjeArtikal.getStalaza() == null ? "00" : StringUtils.leftPad((String)stanjeArtikal.getStalaza(), (int)2, (String)"0")) + (stanjeArtikal.getNivo() == null ? "00" : StringUtils.leftPad((String)stanjeArtikal.getNivo(), (int)2, (String)"0")) + (stanjeArtikal.getPaleta() == null ? "00" : StringUtils.leftPad((String)stanjeArtikal.getPaleta(), (int)2, (String)"0")));
                if (stanjeArtikal.getStalaza() != null && !stanjeArtikal.getStalaza().equals("")) {
                    if (magacin.equals("")) {
                        magacin = String.valueOf(magacin) + stanjeArtikal.getStalaza().charAt(0);
                    } else if (!PzMagacinUtil.postojiMagacin(magacin, Character.valueOf(stanjeArtikal.getStalaza().charAt(0))).booleanValue()) {
                        magacin = String.valueOf(magacin) + ", " + stanjeArtikal.getStalaza().charAt(0);
                    }
                }
                anp.setKatBroj(stanjeArtikal.getKatBroj());
                anp.setBarKod(stanjeArtikal.getBarKod());
            }
            anp.setKolicina(pzArtikalDokument.getKolicina());
            anp.setNaziv(pzArtikalDokument.getNaziv());
            anp.setKbr("");
            anp.setSfrProizvod(pzArtikalDokument.getId().getSfrProizvod());
            artikalNalogprijem.add((Object)anp);
            nalog.setMagacini(magacin);
            em.merge((Object)nalog);
            ++rBroj;
        }
        nalog.setArtikalnalogprijems((List<Artikalnalogprijem>)artikalNalogprijem);
        em.merge((Object)nalog);
        return nalog;
    }

    public static void azurirajRokTrajanja(Nalogprijem n, EntityManager em) {
        List stanja = em.createQuery("SELECT s FROM Stanje s WHERE s.radnajedinica=:rj AND s.id.sfrProizvod IN (SELECT a.sfrProizvod FROM Artikalnalogprijem a WHERE a.nalogprijem=:nalog)").setParameter("rj", (Object)n.getRadnajedinica()).setParameter("nalog", (Object)n).getResultList();
        for (Artikalnalogprijem anp : n.getArtikalnalogprijems()) {
            if (anp.getKbr() == null || anp.getKbr().equals("")) continue;
            for (Stanje stanje : stanja) {
                if (!anp.getSfrProizvod().equals(stanje.getId().getSfrProizvod())) continue;
                boolean found = false;
                if (stanje.getOsobinaartiklas() != null && stanje.getOsobinaartiklas().size() > 0) {
                    Iterator<Osobinaartikla> i1 = stanje.getOsobinaartiklas().iterator();
                    while (i1.hasNext() && !found) {
                        Osobinaartikla o = i1.next();
                        if (!(o instanceof RokTrajanja)) continue;
                        RokTrajanja rok = (RokTrajanja)o;
                        if (!anp.getKbr().equals(rok.getId().getOznosobinaartikla())) continue;
                        rok.setKolicina(rok.getKolicina() + anp.getKolicina());
                        found = true;
                    }
                }
                if (found) continue;
                RokTrajanja rok = new RokTrajanja();
                rok.setId(new OsobinaartiklaPK(anp.getSfrProizvod(), n.getRadnajedinica()));
                rok.getId().setOznosobinaartikla(anp.getKbr());
                rok.setDatum(anp.getDat());
                rok.setStanje(stanje);
                rok.setKolicina(anp.getKolicina());
                em.persist((Object)rok);
            }
        }
    }

    public static Boolean postojiMagacin(String magacin, Character ch) {
        Boolean res = false;
        String[] magacini = magacin.split(",");
        int i = 0;
        while (i < magacini.length) {
            System.out.println(magacini[i]);
            if (magacini[i].equals(ch.toString())) {
                res = true;
            }
            ++i;
        }
        return res;
    }

    public static Nalogmagacinu createNalogDaIzda(PzDokument dokument, String napomena, boolean persist, EntityManager em) throws Exception {
        Nalogmagacinu n = new Nalogmagacinu();
        n.setDatum(PzDateUtility.getCurrentDate());
        n.setRadnajedinica(dokument.getRadnajedinica());
        n.setDokument(dokument.getDokument());
        n.setInfo(3);
        n.setKoVozi("");
        n.setNapomena(napomena);
        n.setOznNalogMagacinu(PzIdGen.getNextId("NALOG_MAGACINU_ID", 1, em).getIdVal());
        n.setArtikalnalogs(new ArrayList<Artikalnalog>());
        Date date = new Date(new java.util.Date().getTime());
        String today = new SimpleDateFormat("dd-MM-yyyy").format(date);
        String lastDate = PzParameter.getParameterValue(NALOG_DATUM);
        Brojac brojac = (Brojac)em.find(Brojac.class, (Object)NALOG_DATUM);
        if (!today.equals(lastDate)) {
            if (brojac == null) {
                brojac = new Brojac(NALOG_DATUM);
                brojac.setrBroj(1);
                em.persist((Object)brojac);
            } else {
                brojac.setrBroj(1);
            }
            PzParameter.setParameter(NALOG_DATUM, today, em);
        } else {
            brojac.setrBroj(brojac.getrBroj() + 1);
        }
        ArrayList<String> sifre = new ArrayList<String>();
        int i = 0;
        while (i < dokument.getArtikalDocuments().size()) {
            sifre.add(dokument.getArtikalDocuments().get(i).getId().getSfrProizvod());
            ++i;
        }
        List osobine = em.createQuery("SELECT o FROM Osobinaartikla o WHERE o.kolicina > 0 AND o.id.oznOgranak=:ogranak AND o.id.oznRj=:rj AND o.id.sfrProizvod IN :sifre ").setParameter("ogranak", (Object)dokument.getRadnajedinica().getId().getOznOgranak()).setParameter("rj", (Object)dokument.getRadnajedinica().getId().getOznRj()).setParameter("sifre", sifre).getResultList();
        ArrayList<Artikalnalog> dodatni = new ArrayList<Artikalnalog>();
        int max = 0;
        int i2 = 0;
        while (i2 < dokument.getArtikalDocuments().size()) {
            Lokacija l;
            Artikalfakturaparameter afp;
            Artikalnalog an = new Artikalnalog();
            PzArtikalDokument af = dokument.getArtikalDocuments().get(i2);
            an.setJm(af.getJm());
            an.setKolicina(af.getKolicina());
            an.setNalogmagacinu(n);
            an.setNaziv(af.getNaziv());
            an.setBliziOpis(af.getBliziOpis());
            if (af instanceof Artikalfaktura && (afp = ((Artikalfaktura)af).getArtikalfakturaparameter("NAPOMENA")) != null) {
                an.setNaziv(String.valueOf(af.getNaziv()) + ", " + afp.getValue());
            }
            if ((l = (Lokacija)em.find(Lokacija.class, (Object)new LokacijaPK(af.getArtikal(), dokument.getRadnajedinica()))) == null && PzParameter.getBoolean("ADRESE_NA_NALOGU_OBAVEZNE", false, em).booleanValue()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                throw new PzInfoException("Artikal " + af.getId().getSfrProizvod() + " nema unetu lokaciju! Nije mogu\u0107e izdati nalog magacinu!");
            }
            String st = "00";
            String nv = "00";
            String pl = "00";
            if (l != null) {
                if (l.getStalaza() != null) {
                    st = l.getStalaza();
                }
                if (l.getNivo() != null) {
                    nv = l.getNivo();
                }
                if (l.getPaleta() != null) {
                    pl = l.getPaleta();
                }
            }
            an.setStalaza(PzEntityUtil.strZero(st, 2));
            an.setNivo(PzEntityUtil.strZero(nv, 2));
            an.setPaleta(PzEntityUtil.strZero(pl, 2));
            ArtikalnalogPK anID = new ArtikalnalogPK();
            anID.setSfrProizvod(af.getId().getSfrProizvod());
            anID.setOznNalogMagacinu(n.getOznNalogMagacinu());
            anID.setrBroj(af.getId().getrBroj());
            if (anID.getrBroj() > max) {
                max = anID.getrBroj();
            }
            an.setId(anID);
            PzMagacinUtil.azurirajRokTrajanja(an, n, osobine, dodatni, em);
            n.getArtikalnalogs().add(an);
            ++i2;
        }
        ++max;
        i2 = 0;
        while (i2 < dodatni.size()) {
            ((Artikalnalog)dodatni.get(i2)).getId().setrBroj(max + i2);
            ++i2;
        }
        n.getArtikalnalogs().addAll(dodatni);
        n.setRedniBroj(brojac.getrBroj());
        n.setPoslaoUser(PzApplication.getApplication().getSession().getLoggedUser().getFullName());
        if (persist) {
            em.persist((Object)n);
        }
        return n;
    }

    public static void azurirajRokTrajanja(Artikalnalog an, Nalogmagacinu n, List<Osobinaartikla> o, List<Artikalnalog> dodatni, EntityManager em) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        ArrayList<RokTrajanja> rokovi = new ArrayList<RokTrajanja>();
        for (Osobinaartikla o1 : o) {
            RokTrajanja r;
            if (!(o1 instanceof RokTrajanja) || !(r = (RokTrajanja)o1).getId().getSfrProizvod().equals(an.getId().getSfrProizvod())) continue;
            rokovi.add(r);
        }
        Collections.sort(rokovi, new Comparator<RokTrajanja>(){

            @Override
            public int compare(RokTrajanja arg0, RokTrajanja arg1) {
                return arg0.getDatum().compareTo(arg1.getDatum());
            }
        });
        Artikalnalog temp = an;
        for (RokTrajanja r : rokovi) {
            if (temp.getKbr() != null || BDConverter.getKolicina(r.getKolicina()).compareTo(new BigDecimal(0)) == 0) continue;
            if (BDConverter.getKolicina(r.getKolicina() - temp.getKolicina()).compareTo(new BigDecimal("0")) >= 0) {
                r.setKolicina(BDConverter.getKolicina(r.getKolicina() - temp.getKolicina()).doubleValue());
                temp.setKbr(r.getId().getOznosobinaartikla());
                temp.setDat(r.getDatum());
                break;
            }
            Artikalnalog an1 = (Artikalnalog)BeanUtils.cloneBean((Object)temp);
            ArtikalnalogPK id = new ArtikalnalogPK();
            id.setOznNalogMagacinu(temp.getId().getOznNalogMagacinu());
            id.setSfrProizvod(temp.getId().getSfrProizvod());
            an1.setId(id);
            an1.setKbr(null);
            an1.setDat(null);
            an1.setKolicina(BDConverter.getKolicina(temp.getKolicina() - r.getKolicina()).doubleValue());
            temp.setKolicina(r.getKolicina());
            temp.setDat(r.getDatum());
            temp.setKbr(r.getId().getOznosobinaartikla());
            r.setKolicina(0.0);
            dodatni.add(an1);
            temp = an1;
        }
    }

    public static int snimiNalogDaIzda(Nalogmagacinu n, EntityManager em) throws Exception {
        n.setOznNalogMagacinu(PzIdGen.getNextId("NALOG_MAGACINU_ID", 1, em).getIdVal());
        Date date = new Date(new java.util.Date().getTime());
        String today = new SimpleDateFormat("dd-MM-yyyy").format(date);
        String lastDate = PzParameter.getParameterValue(NALOG_DATUM);
        Brojac brojac = (Brojac)em.find(Brojac.class, (Object)NALOG_DATUM);
        if (!today.equals(lastDate)) {
            if (brojac == null) {
                brojac = new Brojac(NALOG_DATUM);
                brojac.setrBroj(1);
                em.persist((Object)brojac);
            } else {
                brojac.setrBroj(1);
            }
            PzParameter.setParameter(NALOG_DATUM, today, em);
        } else {
            brojac.setrBroj(brojac.getrBroj() + 1);
        }
        for (Artikalnalog an : n.getArtikalnalogs()) {
            an.getId().setOznNalogMagacinu(n.getOznNalogMagacinu());
        }
        n.setRedniBroj(brojac.getrBroj());
        n.setPoslaoUser(PzApplication.getApplication().getSession().getLoggedUser().getFullName());
        em.merge((Object)n);
        return brojac.getrBroj();
    }
}

