/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.webservice.client.nbs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;
import rs.nbs.communicationoffice.CompanyAccountXmlServiceSoapProxy;
import rs.nbs.communicationoffice.CoreXmlServiceSoapProxy;
import rs.nbs.communicationoffice.ExchangeRateXmlServiceSoapProxy;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Email;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Kurs;
import rs.pezar.db.entity.KursPK;
import rs.pezar.db.entity.Tekuciracun;
import rs.pezar.db.entity.Tipemaila;
import rs.pezar.db.entity.Valuta;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.util.CertUtil;
import rs.pezar.util.PzDateUtility;
import rs.pezar.webservice.client.nbs.NBSException;
import rs.pezar.webservice.client.nbs.jaxb.companyAccountDataSet.CompanyAccountDataSet;
import rs.pezar.webservice.client.nbs.jaxb.companyDataSet.CompanyDataSet;
import rs.pezar.webservice.client.nbs.jaxb.currencyDataSet.CurrencyDataSet;
import rs.pezar.webservice.client.nbs.jaxb.exchangeRateDataSet.ExchangeRateDataSet;

public class NBS {
    public static String TIP_MATICNI_BROJ = "MAT_BROJ";
    public static String TIP_PIB = "PIB";

    static {
        try {
            CertUtil.installCert((String)"webservices.nbs.rs", null);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }

    public static List<Kurs> getKurs(java.util.Date datOd, java.util.Date datDo, Valuta valuta) throws NBSException, RemoteException, JAXBException, ParseException {
        if (valuta.getKodValuta() == null) {
            throw new NBSException("Valuta " + valuta.getNaziv() + " nije automatski preuzeta iz sistema Naradne banke Srbije, \npa za nju nije mogu\u0107e automatski preuzeti kurs.");
        }
        ExchangeRateXmlServiceSoapProxy proxy = new ExchangeRateXmlServiceSoapProxy();
        String response = null;
        try {
            response = proxy.getExchangeRateByCurrency(valuta.getKodValuta(), NBS.formatDate(datOd), NBS.formatDate(datDo), 3);
        }
        catch (RemoteException remoteException) {
            response = proxy.getExchangeRateByCurrency(valuta.getKodValuta(), NBS.formatDate(datOd), NBS.formatDate(datDo), 3);
        }
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(response.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ExchangeRateDataSet.class});
        Unmarshaller u = jc.createUnmarshaller();
        ExchangeRateDataSet erds = (ExchangeRateDataSet)u.unmarshal((InputStream)is);
        ArrayList<Kurs> kurs = new ArrayList<Kurs>();
        if (erds.getExchangeRate().size() > 0) {
            for (ExchangeRateDataSet.ExchangeRate er : erds.getExchangeRate()) {
                Date date = NBS.parseDate(er.getDate());
                Date dateTo = NBS.parseDate(er.getDateTo());
                if (dateTo.compareTo(datDo) > 0) {
                    dateTo = new Date(datDo.getTime());
                }
                int n = PzDateUtility.subtract((Date)dateTo, (Date)date);
                int i = 0;
                while (i < n + 1) {
                    Kurs k = NBS.createKurs(valuta, er);
                    k.getId().setDatum(PzDateUtility.add((Date)date, (int)i));
                    kurs.add(k);
                    ++i;
                }
            }
        }
        return kurs;
    }

    public static List<ExchangeRateDataSet.ExchangeRate> getKursnaLista(java.util.Date datum) throws RemoteException, JAXBException, ParseException {
        ExchangeRateXmlServiceSoapProxy proxy = new ExchangeRateXmlServiceSoapProxy();
        String response = null;
        try {
            response = proxy.getExchangeRateByDate(NBS.formatDate(datum), 3);
        }
        catch (RemoteException remoteException) {
            response = proxy.getExchangeRateByDate(NBS.formatDate(datum), 3);
        }
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(response.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ExchangeRateDataSet.class});
        Unmarshaller u = jc.createUnmarshaller();
        ExchangeRateDataSet erds = (ExchangeRateDataSet)u.unmarshal((InputStream)is);
        return erds.getExchangeRate();
    }

    public static List<Valuta> getValute() throws JAXBException, ParserConfigurationException, RemoteException {
        CoreXmlServiceSoapProxy proxy = new CoreXmlServiceSoapProxy();
        String response = null;
        try {
            response = proxy.getCurrency(null, null, null, null);
        }
        catch (RemoteException remoteException) {
            response = proxy.getCurrency(null, null, null, null);
        }
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(response.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{CurrencyDataSet.class});
        Unmarshaller u = jc.createUnmarshaller();
        CurrencyDataSet cds = (CurrencyDataSet)u.unmarshal((InputStream)is);
        ArrayList<Valuta> valute = new ArrayList<Valuta>();
        if (cds.getCurrency().size() > 0) {
            for (CurrencyDataSet.Currency c : cds.getCurrency()) {
                Valuta valuta = new Valuta();
                valuta.setAuto(1);
                valuta.setKodValuta(Integer.valueOf(c.getCurrencyCode()));
                valuta.setOznValuta(c.getCurrencyCodeAlfaChar());
                valuta.setZemlja(c.getCountryNameSerLat());
                valuta.setNaziv(c.getCurrencyNameSerLat());
                valute.add(valuta);
            }
        }
        return valute;
    }

    public static List<Komitent> getKomitentRacun(Integer mbr, String pib, String naziv, String grad) throws RemoteException, JAXBException {
        CompanyAccountXmlServiceSoapProxy proxy = new CompanyAccountXmlServiceSoapProxy();
        String response = null;
        try {
            response = proxy.getCompanyAccount(mbr.intValue(), pib, 0L, 0L, 0, naziv, grad, 0L, 0L);
        }
        catch (Exception exception) {
            response = proxy.getCompanyAccount(mbr.intValue(), pib, 0L, 0L, 0, naziv, grad, 0L, 0L);
        }
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(response.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{CompanyAccountDataSet.class});
        Unmarshaller u = jc.createUnmarshaller();
        CompanyAccountDataSet cads = (CompanyAccountDataSet)u.unmarshal((InputStream)is);
        Vector<Komitent> komitenti = new Vector<Komitent>();
        Komitent k = null;
        if (cads.getCompanyAccount() != null && cads.getCompanyAccount().size() > 0) {
            CompanyAccountDataSet.CompanyAccount ca = cads.getCompanyAccount().get(0);
            k = new Komitent();
            k.setNaziv(ca.getCompanyName());
            k.setAdresa(ca.getAddress());
            k.setDomaciKomitent((short)1);
            k.setSrbija((short)1);
            k.setGrad(ca.getCity());
            k.setMatBroj(PzEntityUtil.strZero((String)("" + ca.getNationalIdentificationNumber()), (int)8));
            k.setPib(ca.getTaxIdentificationNumber() != null ? ca.getTaxIdentificationNumber().trim() : null);
            k.setPostBroj("");
            k.setOpis(ca.getActivityName());
            k.setObveznikPDV((short)1);
            k.setSfrKomitent("NBS");
            Vector<Tekuciracun> trlist = new Vector<Tekuciracun>();
            for (CompanyAccountDataSet.CompanyAccount ca1 : cads.getCompanyAccount()) {
                Tekuciracun tr = new Tekuciracun();
                tr.setKomitent(k);
                tr.setBrRacuna(ca1.getAccount());
                tr.setBanka(ca1.getBankName());
                tr.setPodrazumevani((short)0);
                trlist.add(tr);
            }
            k.setTekuciracuns(trlist);
            komitenti.add(k);
        }
        return komitenti;
    }

    public static List<Tekuciracun> getTekuciRacuni(Komitent k) throws RemoteException, JAXBException, PzInfoException {
        if (k == null) {
            throw new IllegalArgumentException("Prosle\u0111eni komitent ne mo\u017ee biti null");
        }
        List<Object> trlist = new Vector();
        if (k.getPib() != null && !k.getPib().equals("") && !k.getPib().equals("0")) {
            trlist = NBS.getTekuciRacuni(TIP_PIB, k.getPib());
        } else if (k.getMatBroj() != null && !k.getMatBroj().equals("") && !k.getMatBroj().equals("0")) {
            trlist = NBS.getTekuciRacuni(TIP_MATICNI_BROJ, Integer.valueOf(k.getMatBroj()));
        } else {
            throw new PzInfoException("Da bi preuzimanje bilo mogu\u0107e, komitent mora imati ili PIB ili mati\u010dni broj, ili oba.");
        }
        return trlist;
    }

    public static List<Tekuciracun> getTekuciRacuni(String tip, Object value) throws RemoteException, JAXBException {
        String pib = null;
        Integer matBroj = new Integer(0);
        if (tip.equals(TIP_MATICNI_BROJ)) {
            matBroj = (Integer)value;
        } else if (tip.equals(TIP_PIB)) {
            pib = (String)value;
        } else {
            throw new IllegalArgumentException("Nedozvoljena vrednost parametra tip!");
        }
        CompanyAccountXmlServiceSoapProxy proxy = new CompanyAccountXmlServiceSoapProxy();
        String response = null;
        try {
            response = proxy.getCompanyAccount(matBroj.intValue(), pib, 0L, 0L, 0, null, null, 0L, 0L);
        }
        catch (RemoteException remoteException) {
            response = proxy.getCompanyAccount(matBroj.intValue(), pib, 0L, 0L, 0, null, null, 0L, 0L);
        }
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(response.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{CompanyAccountDataSet.class});
        Unmarshaller u = jc.createUnmarshaller();
        CompanyAccountDataSet cads = (CompanyAccountDataSet)u.unmarshal((InputStream)is);
        Vector<Tekuciracun> trlist = new Vector<Tekuciracun>();
        for (CompanyAccountDataSet.CompanyAccount ca1 : cads.getCompanyAccount()) {
            Tekuciracun tr = new Tekuciracun();
            tr.setBrRacuna(ca1.getAccount());
            tr.setBanka(ca1.getBankName());
            tr.setPodrazumevani((short)0);
            trlist.add(tr);
        }
        return trlist;
    }

    public static List<Komitent> getKomitenti(Integer mbr, Integer pib, String naziv, String grad) throws RemoteException, JAXBException {
        CoreXmlServiceSoapProxy proxy = new CoreXmlServiceSoapProxy();
        String response = null;
        try {
            response = proxy.getCompany(null, 0, naziv, grad, mbr, pib, 0L, 0L);
        }
        catch (RemoteException remoteException) {
            response = proxy.getCompany(null, 0, naziv, grad, mbr, pib, 0L, 0L);
        }
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(response.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{CompanyDataSet.class});
        Unmarshaller u = jc.createUnmarshaller();
        CompanyDataSet cds = (CompanyDataSet)u.unmarshal((InputStream)is);
        Vector<Komitent> komitenti = new Vector<Komitent>();
        if (cds.getCompany() == null || cds.getCompany().size() == 0) {
            return komitenti;
        }
        Komitent k = null;
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            for (CompanyDataSet.Company c : cds.getCompany()) {
                k = new Komitent();
                k.setOpis(c.getName());
                k.setNaziv(!StringUtils.isEmpty((String)c.getShortName()) ? c.getShortName() : c.getName());
                k.setAdresa(c.getAddress());
                k.setDomaciKomitent((short)(c.getCountry() == null || c.getCountry() == 0 ? 1 : 0));
                k.setGrad(c.getCity() != null ? c.getCity().trim() : "");
                k.setMatBroj(PzEntityUtil.strZero((String)("" + c.getNationalIdentificationNumber()), (int)8));
                k.setPib("" + c.getTaxIdentificationNumber());
                k.setPostBroj(c.getPostalCode() != null ? "" + c.getPostalCode() : "");
                k.setSfrKomitent("NBS");
                k.setTelefoni(c.getPhone());
                k.setTip(0);
                k.setEmail(c.getEmail());
                k.setObveznikPDV((short)1);
                if (c.getEmail() != null && !c.getEmail().equals("") && em.find(Email.class, (Object)c.getEmail()) == null) {
                    k.setEmails(new Vector());
                    Email e = new Email();
                    Tipemaila tipEmaila = (Tipemaila)em.find(Tipemaila.class, (Object)1);
                    e.setTipEmaila(tipEmaila);
                    e.setAdresa(c.getEmail());
                    k.getEmails().add(e);
                }
                boolean kosovo = false;
                if (c.getRegion() != null && c.getRegion().toLowerCase().indexOf("kosov") != -1) {
                    kosovo = true;
                }
                k.setSrbija((short)(!kosovo ? 1 : 0));
                komitenti.add(k);
            }
        }
        finally {
            em.close();
        }
        return komitenti;
    }

    private static String formatDate(java.util.Date d) {
        return new SimpleDateFormat("yyyyMMdd").format(d);
    }

    private static Date parseDate(String date) throws ParseException {
        return new Date(new SimpleDateFormat("dd.MM.yyyy").parse(date).getTime());
    }

    private static Kurs createKurs(Valuta valuta, ExchangeRateDataSet.ExchangeRate er) throws ParseException {
        Kurs k = new Kurs();
        KursPK id = new KursPK();
        id.setOznValuta(valuta.getOznValuta());
        id.setDatum(NBS.parseDate(er.getDate()));
        k.setId(id);
        k.setValuta(valuta);
        k.setAuto(1);
        k.setJedinica(er.getUnit());
        k.setSrednji(er.getMiddleRate());
        return k;
    }

    public static void main(String[] args) throws JAXBException, SAXException, IOException, ParserConfigurationException, NBSException, ParseException, InterruptedException {
        NBS.getValute();
        NBS.getValute();
    }
}

