/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.efaktura;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DocumentReferenceType;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import rs.pezar.db.PzDokument;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.EDokument;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Komitentparameter;
import rs.pezar.db.entity.Uplata;
import rs.pezar.db.entity.ZaduzenjeOdobrenje;
import rs.pezar.efaktura.EAvansniRacunExporter;
import rs.pezar.efaktura.EDokumentAttachments;
import rs.pezar.efaktura.EFakturaExporter;
import rs.pezar.efaktura.EOdobrenjeExporter;
import rs.pezar.efaktura.EZaduzenjeExporter;
import rs.pezar.efaktura.EZaduzenjeOdobrenjeExporter;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.util.PzDateUtility;

public class EDokumentTransport {
    private final String baseUri;
    private CloseableHttpClient client;
    private String apiKey;
    private Gson gson;

    public static EDokumentTransport createTransport() throws PzInfoException {
        String baseUri = PzParameter.getParameterValue((String)"EFAKTURA_API_URL");
        String apiKey = PzParameter.getParameterValue((String)"EFAKTURA_API_KEY");
        if (baseUri == null) {
            throw new PzInfoException("Nedostaje API URL");
        }
        if (apiKey == null) {
            throw new PzInfoException("Nedostaje API KEY");
        }
        EDokumentTransport t = new EDokumentTransport(baseUri, apiKey);
        try {
            t.createHttpClient();
            return t;
        }
        catch (Exception e) {
            throw new PzInfoException("Neuspela inicijalizacija http klijenta", (Throwable)e);
        }
    }

    public EDokumentTransport(String baseUri, String apiKey) {
        this.baseUri = baseUri;
        this.apiKey = apiKey;
        this.gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE).create();
    }

    private void createHttpClient() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        TrustStrategy acceptingTrustStrategy = new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                return true;
            }
        };
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)new PlainConnectionSocketFactory()).build();
        int timeout = 30;
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).build();
        BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry);
        this.client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(config).build();
    }

    public <T> T get(String endpoint, Type type) throws ClientProtocolException, IOException, PzInfoException {
        HttpGet get = new HttpGet(endpoint);
        get.addHeader("Accept", "application/json");
        get.setHeader("ApiKey", this.apiKey);
        CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)get);
        String responseString = this.readInputStreamToString(httpResponse.getEntity().getContent());
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            throw new PzInfoException("Slanje E-Fakture nije uspelo: " + httpResponse.getStatusLine().toString() + "\r\n" + responseString);
        }
        Object response = this.gson.fromJson(responseString, type);
        return (T)response;
    }

    public <T> T post(String endpoint, String content, String mediaType, Class<T> responseClass) throws ClientProtocolException, IOException, PzInfoException {
        HttpPost post = new HttpPost(endpoint);
        post.addHeader("Content-Type", mediaType);
        post.setHeader("ApiKey", this.apiKey);
        post.setEntity((HttpEntity)new StringEntity(content, StandardCharsets.UTF_8));
        CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)post);
        InputStream is = httpResponse.getEntity().getContent();
        String responseString = this.readInputStreamToString(is);
        System.out.println(responseString);
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            throw new PzInfoException("Slanje E-Fakture nije uspelo: " + httpResponse.getStatusLine().toString() + "\r\n" + responseString);
        }
        return (T)this.gson.fromJson(responseString, responseClass);
    }

    public EDokument uploadInvoice(Faktura f, List<Uplata> uplataList2, EDokumentAttachments attachments) throws Exception {
        EFakturaExporter exporter = new EFakturaExporter(f, uplataList2);
        exporter.setAdditionalDocumentReferences(attachments != null ? attachments.getReferences() : new ArrayList<DocumentReferenceType>());
        exporter.init();
        String xml = exporter.toXML();
        String rq = UUID.randomUUID().toString();
        String requestId = "requestId=" + rq;
        String sendToCir = "";
        String cirParam = this.isSendToCir(f.getKomitent());
        if (cirParam != null) {
            sendToCir = "sendToCir=" + cirParam;
        }
        InvoiceResponse response = this.post(String.valueOf(this.baseUri) + "/api/publicApi/sales-invoice/ubl" + this.query(requestId, sendToCir), xml, "application/xml", InvoiceResponse.class);
        return this.eFaktura((PzDokument)f, response, rq);
    }

    public EDokument uploadInvoice(Faktura f, List<Uplata> uplataList2) throws Exception {
        return this.uploadInvoice(f, uplataList2, null);
    }

    public EDokument uploadAdvance(Faktura f) throws Exception {
        EAvansniRacunExporter exporter = new EAvansniRacunExporter(f);
        exporter.init();
        String xml = exporter.toXML();
        String rq = UUID.randomUUID().toString();
        String requestId = "requestId=" + rq;
        String sendToCir = "sendToCir=No";
        InvoiceResponse response = this.post(String.valueOf(this.baseUri) + "/api/publicApi/sales-invoice/ubl" + this.query(requestId, sendToCir), xml, "application/xml", InvoiceResponse.class);
        return this.eFaktura((PzDokument)f, response, rq);
    }

    public EDokument uploadCreditNote(ZaduzenjeOdobrenje z) throws Exception {
        EZaduzenjeOdobrenjeExporter exporter = null;
        exporter = z.getTip().equals(TipDokumentConfig.get().KNJIZNO_ODOBRENJE_KUPCA) ? new EOdobrenjeExporter(z) : new EZaduzenjeExporter(z);
        exporter.init();
        String xml = exporter.toXML();
        String rq = UUID.randomUUID().toString();
        String requestId = "requestId=" + rq;
        String sendToCir = "";
        String cirParam = this.isSendToCir(z.getKomitent());
        if (cirParam != null) {
            sendToCir = "sendToCir=" + cirParam;
        }
        InvoiceResponse response = this.post(String.valueOf(this.baseUri) + "/api/publicApi/sales-invoice/ubl" + this.query(requestId, sendToCir), xml, "application/xml", InvoiceResponse.class);
        return this.eFaktura((PzDokument)z, response, rq);
    }

    public String isSendToCir(Komitent k) throws ClientProtocolException, IOException, PzInfoException {
        Komitentparameter jbkjs = k.getKomitentparameter("JBKJS");
        if (jbkjs != null && !StringUtils.isEmpty((String)jbkjs.getValue())) {
            HttpGet get = new HttpGet("http://api.mydocuments.rs:8811/v1/company/jbbk/" + jbkjs.getValue());
            get.setHeader("token", "8510438e-7aec-11ed-b987-326b6c2d78f0");
            CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)get);
            System.out.println(httpResponse);
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new PzInfoException("JBKJS broj kupca (" + jbkjs.getValue() + ") nije ispravan ili nije pronadjen \r\nu bazi Uprave za trezor. Proverite podatke kupca u sifarniku.");
            }
            JBBK jbbk = (JBBK)this.gson.fromJson(this.readInputStreamToString(httpResponse.getEntity().getContent()), JBBK.class);
            if (jbbk.isCrf()) {
                return "Yes";
            }
            return "No";
        }
        return null;
    }

    public boolean isCompanyRegistered(Komitent k) throws ClientProtocolException, IOException, PzInfoException {
        String pib = k.getPib();
        String mb = k.getMatBroj();
        String jbkjs = null;
        Komitentparameter p = k.getKomitentparameter("JBKJS");
        if (p != null && !StringUtils.isEmpty((String)p.getValue())) {
            jbkjs = p.getValue();
        }
        return this.isCompanyRegistered(pib, mb, jbkjs);
    }

    public boolean isCompanyRegistered(String pib, String mb, String jbkjs) throws ClientProtocolException, IOException, PzInfoException {
        CompanyID id = new CompanyID(mb, jbkjs, pib);
        return this.post(String.valueOf(this.baseUri) + "/api/publicApi/Company/CheckIfCompanyRegisteredOnEfaktura", this.gson.toJson((Object)id), "application/json", CompanyRegisteredResponse.class).geteFakturaRegisteredCompany();
    }

    public List<TaxExemption> getTaxExemptions() throws ClientProtocolException, IOException, PzInfoException {
        List exemptions = (List)this.get(String.valueOf(this.baseUri) + "/api/publicApi/sales-invoice/getValueAddedTaxExemptionReasonList", new TypeToken<List<TaxExemption>>(){}.getType());
        return exemptions;
    }

    private EDokument eFaktura(PzDokument f, InvoiceResponse response, String requestId) {
        return new EDokument(f.getIdDok(), f.getKomitent().getSfrKomitent(), f.getKomitent().getNaziv(), f.getOznDokumenta(), f.getTip(), "izlaz", f.getDatum(), Boolean.valueOf(true), requestId, this.gson.toJson((Object)response));
    }

    private String requestId(Faktura f) throws PzInfoException, UnsupportedEncodingException {
        if (f.getIdDok() == 0) {
            throw new PzInfoException("Dokument nema ID");
        }
        String requestId = String.valueOf(PzDateUtility.getCurrentYear()) + "-" + f.getIdDok();
        return URLEncoder.encode(requestId, StandardCharsets.UTF_8.toString());
    }

    private String query(String ... params) {
        if (params == null || params.length == 0) {
            return "";
        }
        String query = "";
        int i = 0;
        while (i < params.length) {
            if (params[i] != null && params[i].length() != 0) {
                query = String.valueOf(query) + (query.length() == 0 ? "?" : "&");
                query = String.valueOf(query) + params[i];
            }
            ++i;
        }
        return query;
    }

    private String readInputStreamToString(InputStream is) throws IOException {
        StringBuilder textBuilder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.forName(StandardCharsets.UTF_8.name())));
        int c = 0;
        while ((c = ((Reader)reader).read()) != -1) {
            textBuilder.append((char)c);
        }
        is.close();
        return textBuilder.toString();
    }

    public static class CompanyID {
        private String registrationNumber;
        private String jbkjs;
        private String vatNumber;

        public CompanyID() {
        }

        public CompanyID(String registrationNumber, String jbkjs, String vatNumber) {
            this.registrationNumber = registrationNumber;
            this.jbkjs = jbkjs;
            this.vatNumber = vatNumber;
        }

        public String getRegistrationNumber() {
            return this.registrationNumber;
        }

        public String getJbkjs() {
            return this.jbkjs;
        }

        public String getVatNumber() {
            return this.vatNumber;
        }
    }

    public static class CompanyRegisteredResponse {
        private boolean eFakturaRegisteredCompany;

        public boolean geteFakturaRegisteredCompany() {
            return this.eFakturaRegisteredCompany;
        }
    }

    public static class EDokumentTransportException
    extends Exception {
        private static final long serialVersionUID = -8033353669122968483L;

        public EDokumentTransportException(String message, Exception e) {
            super(message, e);
        }
    }

    private static class Endpoints {
        private static final String SALES_INVOICE = "/api/publicApi/sales-invoice/ubl";
        private static final String KJS_QUERY = "https://kjs.trezor.gov.rs/servis/";
        private static final String CIR_QUERY = "http://api.mydocuments.rs:8811/v1/company/jbbk/";
        private static final String TAX_EXEMPTIONS = "/api/publicApi/sales-invoice/getValueAddedTaxExemptionReasonList";
        private static final String IS_COMPANY_REGISTERED = "/api/publicApi/Company/CheckIfCompanyRegisteredOnEfaktura";

        private Endpoints() {
        }
    }

    public static class HttpGetWithEntity
    extends HttpEntityEnclosingRequestBase {
        public static final String METHOD_NAME = "GET";

        public HttpGetWithEntity(String uri) {
            this.setURI(URI.create(uri));
        }

        public String getMethod() {
            return METHOD_NAME;
        }
    }

    public static class InvoiceResponse {
        private String invoiceId;
        private String purchaseInvoiceId;
        private String salesInvoiceId;

        public String getInvoiceId() {
            return this.invoiceId;
        }

        public String getPurchaseInvoiceId() {
            return this.purchaseInvoiceId;
        }

        public String getSalesInvoiceId() {
            return this.salesInvoiceId;
        }
    }

    public static class JBBK {
        private String jbbk;
        private String pib;
        private String maticni;
        private String tip;
        private boolean crf;

        public String getJbbk() {
            return this.jbbk;
        }

        public String getPib() {
            return this.pib;
        }

        public String getMaticni() {
            return this.maticni;
        }

        public String getTip() {
            return this.tip;
        }

        public boolean isCrf() {
            return this.crf;
        }
    }

    public static class TaxExemption {
        private String Key;
        private String Text;
        private String Category;

        public String getKey() {
            return this.Key;
        }

        public String getText() {
            return this.Text;
        }

        public String getCategory() {
            return this.Category;
        }
    }
}

