/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Kalkulacijazapisnik;
import rs.pezar.nabavka.PzExtensionLoader;
import rs.pezar.nabavka.gui.PzDialogUnosNaknadneFakture;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogDokumentiZapisnik
extends PzDialog {
    private static final long serialVersionUID = 1L;
    private JToolBar toolbar;
    private PzToolBarIcon icnBrisanjeKalkulacije;
    private PzToolBarIcon icnIzmenaKalk;
    private PzToolBarIcon icnDodKalk;
    private JScrollPane scrollPane;
    private PzTable table;
    private PzPanel mainPanel;
    private PzComponentGroup kIcnGroup;
    private PzComponentGroup fIcnGroup;

    public PzDialogDokumentiZapisnik(JFrame frame) {
        super(frame);
    }

    public PzDialogDokumentiZapisnik(JFrame frame, String parameter) {
        super(frame);
        this.initGUI();
        this.table = new PzTable();
        this.setTableFilter(this.table);
        this.table.setData(this.tableData(), Kalkulacija.class);
        this.table.setEnterAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean izmena = true;
                PzDialogDokumentiZapisnik.this.getSession().putParameter("tableZap", (Object)PzDialogDokumentiZapisnik.this.table);
                PzDialogDokumentiZapisnik.this.getSession().putParameter("update", (Object)izmena);
                PzDialogDokumentiZapisnik.this.showDialog(PzDialogUnosNaknadneFakture.class);
            }
        });
        this.setTitle("Zapisnici u pripremi za korisnika " + PzExtensionLoader.getLoggedUser().getFullName());
        this.scrollPane.setViewportView((Component)this.table);
    }

    private void initGUI() {
        try {
            this.toolbar = new JToolBar();
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.getContentPane().add((Component)this.toolbar, "North");
            this.kIcnGroup = new PzComponentGroup();
            this.fIcnGroup = new PzComponentGroup();
            this.icnDodKalk = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnDodKalk);
            this.toolbar.add((Component)this.icnDodKalk);
            this.icnDodKalk.setText("Novi|zapisnik|(Insert)");
            this.icnDodKalk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/document_add.png")));
            this.icnDodKalk.addActionListener((ActionListener)((Object)this));
            this.icnDodKalk.setActionCommand("insert_zapisnik");
            this.icnDodKalk.setShortcut("insert");
            this.icnIzmenaKalk = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnIzmenaKalk);
            this.toolbar.add((Component)this.icnIzmenaKalk);
            this.icnIzmenaKalk.setText("Izmena|zapisnika|(F3)");
            this.icnIzmenaKalk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/document_edit.png")));
            this.icnIzmenaKalk.setActionCommand("update_zapisnik");
            this.icnIzmenaKalk.addActionListener((ActionListener)((Object)this));
            this.icnIzmenaKalk.setShortcut("f3");
            this.icnBrisanjeKalkulacije = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnBrisanjeKalkulacije);
            this.toolbar.add((Component)this.icnBrisanjeKalkulacije);
            this.icnBrisanjeKalkulacije.setText("Brisanje|zapisnika|(Delete)");
            this.icnBrisanjeKalkulacije.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/document_delete.png")));
            this.icnBrisanjeKalkulacije.addActionListener((ActionListener)((Object)this));
            this.icnBrisanjeKalkulacije.setActionCommand("delete_zapisnik");
            this.icnBrisanjeKalkulacije.setShortcut("delete");
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{7, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.setSize(1024, 768);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String actionCommand = ((PzToolBarIcon)e.getSource()).getActionCommand();
            boolean izmena = false;
            if (actionCommand.equals("insert_zapisnik")) {
                this.getSession().putParameter("tableZap", (Object)this.table);
                this.getSession().putParameter("update", (Object)izmena);
                this.showDialog(PzDialogUnosNaknadneFakture.class);
                return;
            }
            if (actionCommand.equals("update_zapisnik")) {
                if (this.table.getSelectedRow() == -1) {
                    return;
                }
                izmena = true;
                this.getSession().putParameter("tableZap", (Object)this.table);
                this.getSession().putParameter("update", (Object)izmena);
                this.showDialog(PzDialogUnosNaknadneFakture.class);
                return;
            }
            if (actionCommand.equals("delete_zapisnik")) {
                if (this.table.getSelectedRow() == -1) {
                    return;
                }
                int rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot((Component)((Object)this)), (Object)"Da li ste sigurni?!", (String)"Brisanje", null, (boolean)false);
                if (rez == 0) {
                    this.removeZapisnik((Kalkulacija)this.table.getSelectedEntity());
                }
                return;
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    private void removeZapisnik(Kalkulacija zapisnik) {
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                em.getTransaction().begin();
                for (Kalkulacijazapisnik kz : zapisnik.getKalkulacijazapisniks2()) {
                    Kalkulacija kalk = (Kalkulacija)em.find(Kalkulacija.class, (Object)kz.getKalkulacija().getIdDok());
                    kalk.setUkupnoFakturisano(kalk.getUkupnoFakturisano().subtract(kz.getFakturisano()));
                    Kalkulacijazapisnik removeKz = (Kalkulacijazapisnik)em.find(Kalkulacijazapisnik.class, (Object)kz.getId());
                    em.remove((Object)removeKz);
                }
                this.table.removeSelectedEntity((Object)zapisnik.getId(), false, em);
                this.table.removeSelectedEntity(false, false);
                em.getTransaction().commit();
                em.clear();
            }
            catch (Exception exception) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogDokumentiZapisnik(Boolean.FALSE);
    }

    public PzDialogDokumentiZapisnik(Boolean initGUI) {
    }

    public Vector<PzEntity> tableData() {
        String query = "SELECT z FROM Kalkulacija z WHERE z.userKraj= :user AND z.arhiviran=0 AND z.storno = 0 AND z.tip= :tipDok";
        EntityManager em = PzEntityManager.getEm();
        Query q = em.createQuery(query);
        q.setParameter("user", (Object)PzExtensionLoader.getLoggedUser());
        q.setParameter("tipDok", (Object)"ZAPISNIK_OTPREMNICE");
        Vector v = (Vector)q.getResultList();
        em.close();
        return v;
    }

    private void setTableFilter(PzTable table) {
        table.setFilter(new PzEntityFilter(){
            private Kalkulacija z;
            private Object[] o;

            public Object[] getValues(PzEntity entity) {
                if (entity instanceof Kalkulacija) {
                    this.z = (Kalkulacija)entity;
                    this.o = new Object[]{this.z.getKomitent().getSfrKomitent(), this.z.getKomitent().getNaziv(), this.z.getOznDokumenta(), this.z.getDatum(), this.z.getIznos()};
                }
                return this.o;
            }

            public String[] getColumnNames() {
                return new String[]{"\u0160ifra dobavlja\u010da", "Naziv dobavlja\u010da", "Broj dokumenta", "Datum dokumenta", "Iznos"};
            }
        });
    }
}

