/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.gui;

import com.swtdesigner.FocusTraversalOnArray;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.core.PzApplication;
import rs.pezar.core.PzGenericService;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.nabavka.gui.storniranjeKalkulacije.StornoKalkulacije;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzTableDataSource;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzScrollableTable;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldImpl;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogKalkArhiva
extends PzDialog {
    private static final long serialVersionUID = -7745443644331406254L;
    protected static Kalkulacija selected;
    private JLabel jLabel3;
    private PzTextField oznDokument;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzPanel pnlPretraga;
    private JPanel jPanel2;
    private JPanel jPanel1;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private PzNumericOnlyTextField brKalk;
    private PzNumericOnlyTextField sfrKomitenta;
    private PzRadioGroup<PzChoice> pzButtonPanel1;
    private PzToolBarIcon icnPripremaZaStampu;
    private JLabel brDok;
    private PzDoubleField prodVrednost;
    private PzDoubleField ukalkPdv;
    private PzDoubleField razlikaUCeni;
    private PzDoubleField interniTroskovi;
    private PzDoubleField vrednostPDV;
    private PzDoubleField eksterniTroskovi;
    private PzDoubleField vrednostOtpremnica;
    private JLabel jLabel14;
    private JLabel jLabel13;
    private JLabel jLabel12;
    private JLabel jLabel11;
    private JLabel jLabel10;
    private JLabel jLabel9;
    private JLabel jLabel8;
    private JLabel jLabel7;
    private JLabel jLabel6;
    private PzPanel pnlSumarneVrednosti;
    private PzToolBarIcon icnSlika;
    private JRadioButton rbtnStorno;
    private JRadioButton rbtnKalkulacija;
    private PzTextField nazKomitenta;
    private PzToolBarIcon icnStorniraj;
    private PzDateField datumDO;
    private PzDateField datumOD;
    private PzScrollableTable table;
    private JScrollPane scpKalkulacije;
    private JToolBar toolbar;
    private PzComponentGroup fieldGroup;
    private Radnajedinica rj;
    private String op;
    private ScrollableCursor cursor;
    Kalkulacija k = null;
    private EntityManager em;
    private PzDoubleField vrednostFaktura;
    private PzPanel pnlContent;
    private PzRadioGroup<String> rgrKomitent;
    private PzStatusBar statusBar;
    private final String sviKomitenti = "Svi komitenti";
    private final String konkretanKomitent = "Konkretan komitent";
    private final String kalkulacije = "Kalkulacije";
    private final String stornoKalkulacije = "Storno kalkulacije";
    private PzButton bntTrazi;
    private PzToolBarIcon icnUpit;

    public PzDialogKalkArhiva() {
        this.initGUI();
    }

    public PzDialogKalkArhiva(JFrame frame) {
        super(frame);
    }

    public PzDialogKalkArhiva(PzDialog dialog) {
        super(dialog);
    }

    private void initGUI() {
        try {
            this.setId("DIALOG_KALK_ARHIVA");
            this.setSize(933, 603);
            this.pnlContent = new PzPanel();
            this.pnlContent.setLayout((LayoutManager)new BorderLayout());
            this.getContentPane().add((Component)this.pnlContent, "Center");
            this.jPanel2 = new JPanel();
            this.jPanel2.setOpaque(false);
            BorderLayout jPanel2Layout = new BorderLayout();
            this.jPanel2.setLayout(jPanel2Layout);
            this.pnlContent.add((Component)this.jPanel2, (Object)"Center");
            this.fieldGroup = new PzComponentGroup();
            this.jPanel2.setPreferredSize(new Dimension(925, 475));
            this.pnlPretraga = new PzPanel();
            this.pnlPretraga.setOpaque(false);
            GridBagLayout panelPretragaLayout = new GridBagLayout();
            this.jPanel2.add((Component)this.pnlPretraga, "North");
            this.pnlPretraga.setPreferredSize(new Dimension(892, 172));
            this.pnlPretraga.setBorder((Border)BorderFactory.createTitledBorder(null, "Pretraga", 4, 0));
            panelPretragaLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0};
            panelPretragaLayout.rowHeights = new int[]{25, 26, 23, 33};
            panelPretragaLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0};
            int[] nArray = new int[8];
            nArray[0] = 90;
            nArray[1] = 110;
            nArray[2] = 130;
            nArray[3] = 113;
            nArray[4] = 44;
            nArray[5] = 75;
            nArray[6] = 119;
            panelPretragaLayout.columnWidths = nArray;
            this.pnlPretraga.setLayout((LayoutManager)panelPretragaLayout);
            this.pnlPretraga.setVerifyInputWhenFocusTarget(false);
            this.pnlPretraga.setTransferFocusOnEnter(true);
            this.rgrKomitent = new PzRadioGroup();
            this.rgrKomitent.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    PzDialogKalkArhiva.this.rgrKomitentselectionChanged(evt);
                }
            });
            this.rgrKomitent.setValues((Object[])new String[]{"Svi komitenti", "Konkretan komitent"});
            this.rgrKomitent.setSelectedIndex(0);
            this.rgrKomitent.setOpaque(false);
            this.pnlPretraga.add(this.rgrKomitent, (Object)new GridBagConstraints(6, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 5, 5), 0, 0));
            this.jLabel4 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel4, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.jLabel4.setText("Po\u010detni datum:");
            this.datumOD = new PzDateField();
            this.fieldGroup.add((Component)this.datumOD);
            this.pnlPretraga.add((Component)this.datumOD, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
            this.datumOD.setVal((Object)PzDateUtility.getFirstDayOfCurrentYear());
            this.datumOD.setEnabled(true);
            this.jLabel2 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel2, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.jLabel2.setText("Dokument:");
            this.oznDokument = new PzTextField();
            this.oznDokument.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent arg0) {
                    PzDialogKalkArhiva.this.keyReleasedAction(arg0);
                }
            });
            this.fieldGroup.add((Component)this.oznDokument);
            this.pnlPretraga.add((Component)this.oznDokument, (Object)new GridBagConstraints(3, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
            this.jLabel1 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel1, (Object)new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.jLabel1.setText("Komitent:");
            this.sfrKomitenta = new PzNumericOnlyTextField();
            this.sfrKomitenta.setEnabled(false);
            this.fieldGroup.add((Component)this.sfrKomitenta);
            this.pnlPretraga.add((Component)this.sfrKomitenta, (Object)new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
            this.sfrKomitenta.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.jLabel5 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel5, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.jLabel5.setText("Krajnji datum:");
            this.datumDO = new PzDateField();
            this.fieldGroup.add((Component)this.datumDO);
            this.pnlPretraga.add((Component)this.datumDO, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
            this.datumDO.setVal((Object)PzDateUtility.getCurrentDate());
            this.datumDO.setEnabled(true);
            this.jLabel3 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel3, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.jLabel3.setText("Kalkulacija:");
            this.brKalk = new PzNumericOnlyTextField();
            this.brKalk.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent arg0) {
                    PzDialogKalkArhiva.this.keyReleasedAction(arg0);
                }
            });
            this.fieldGroup.add((Component)this.brKalk);
            this.pnlPretraga.add((Component)this.brKalk, (Object)new GridBagConstraints(3, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
            this.nazKomitenta = new PzTextField();
            this.nazKomitenta.setOpaque(false);
            this.pnlPretraga.add((Component)this.nazKomitenta, (Object)new GridBagConstraints(6, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.nazKomitenta.setEditable(false);
            this.nazKomitenta.setFocusable(false);
            this.jPanel1 = new JPanel();
            this.jPanel1.setOpaque(false);
            this.jPanel2.add((Component)this.jPanel1, "Center");
            GridBagLayout jPanel1Layout = new GridBagLayout();
            this.jPanel1.setPreferredSize(new Dimension(925, 475));
            jPanel1Layout.rowWeights = new double[]{1.0, 0.0};
            jPanel1Layout.rowHeights = new int[]{348, 127};
            jPanel1Layout.columnWeights = new double[]{0.1};
            jPanel1Layout.columnWidths = new int[]{7};
            this.jPanel1.setLayout(jPanel1Layout);
            this.scpKalkulacije = new JScrollPane();
            this.jPanel1.add((Component)this.scpKalkulacije, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.scpKalkulacije.setBackground(new Color(211, 242, 210));
            this.table = new PzScrollableTable();
            this.scpKalkulacije.setViewportView((Component)this.table);
            this.pnlSumarneVrednosti = new PzPanel();
            this.pnlSumarneVrednosti.setOpaque(false);
            GridBagLayout pnlSumarneVrednostiLayout = new GridBagLayout();
            this.jPanel1.add((Component)this.pnlSumarneVrednosti, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlSumarneVrednostiLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            int[] nArray2 = new int[4];
            nArray2[0] = 7;
            nArray2[1] = 7;
            nArray2[2] = 7;
            pnlSumarneVrednostiLayout.rowHeights = nArray2;
            pnlSumarneVrednostiLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlSumarneVrednostiLayout.columnWidths = new int[]{149, 170, 149, 157, 115};
            this.pnlSumarneVrednosti.setLayout((LayoutManager)pnlSumarneVrednostiLayout);
            this.vrednostFaktura = this.table.createExpresionField("$6$");
            this.vrednostFaktura.setBackground(new Color(220, 220, 220));
            this.vrednostFaktura.setColumns(12);
            this.pnlSumarneVrednosti.add((Component)this.vrednostFaktura, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 5, 5), 0, 0));
            this.vrednostFaktura.setEditable(false);
            this.vrednostFaktura.setFocusable(false);
            this.vrednostFaktura.setForeground(new Color(0, 0, 160));
            this.interniTroskovi = this.table.createExpresionField("$13$");
            this.interniTroskovi.setBackground(new Color(220, 220, 220));
            this.interniTroskovi.setColumns(12);
            this.pnlSumarneVrednosti.add((Component)this.interniTroskovi, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 5, 5), 0, 0));
            this.interniTroskovi.setEditable(false);
            this.interniTroskovi.setFocusable(false);
            this.interniTroskovi.setForeground(new Color(0, 0, 160));
            this.vrednostOtpremnica = this.table.createExpresionField("$8$");
            this.vrednostOtpremnica.setBackground(new Color(220, 220, 220));
            this.vrednostOtpremnica.setColumns(12);
            this.pnlSumarneVrednosti.add((Component)this.vrednostOtpremnica, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 5, 5), 0, 0));
            this.vrednostOtpremnica.setEditable(false);
            this.vrednostOtpremnica.setFocusable(false);
            this.vrednostOtpremnica.setForeground(new Color(0, 0, 160));
            this.jLabel7 = new JLabel();
            this.pnlSumarneVrednosti.add((Component)this.jLabel7, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 10), 0, 0));
            this.jLabel7.setText("Vrednost faktura");
            this.razlikaUCeni = this.table.createExpresionField("$8$");
            this.razlikaUCeni.setBackground(new Color(220, 220, 220));
            this.razlikaUCeni.setColumns(12);
            this.pnlSumarneVrednosti.add((Component)this.razlikaUCeni, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 5, 5), 0, 0));
            this.razlikaUCeni.setEditable(false);
            this.razlikaUCeni.setFocusable(false);
            this.razlikaUCeni.setForeground(new Color(0, 0, 160));
            this.vrednostPDV = this.table.createExpresionField("$11$");
            this.vrednostPDV.setBackground(new Color(220, 220, 220));
            this.vrednostPDV.setColumns(12);
            this.pnlSumarneVrednosti.add((Component)this.vrednostPDV, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 5, 5), 0, 0));
            this.vrednostPDV.setEditable(false);
            this.vrednostPDV.setFocusable(false);
            this.vrednostPDV.setForeground(new Color(0, 0, 160));
            this.jLabel11 = new JLabel();
            this.pnlSumarneVrednosti.add((Component)this.jLabel11, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 10), 0, 0));
            this.jLabel11.setText("Interni tro\u0161kovi");
            this.jLabel8 = new JLabel();
            this.pnlSumarneVrednosti.add((Component)this.jLabel8, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 10), 0, 0));
            this.jLabel8.setText("Vrednost otpremnica");
            this.ukalkPdv = this.table.createExpresionField("$9$");
            this.ukalkPdv.setBackground(new Color(220, 220, 220));
            this.ukalkPdv.setColumns(12);
            this.pnlSumarneVrednosti.add((Component)this.ukalkPdv, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 5, 5), 0, 0));
            this.ukalkPdv.setEditable(false);
            this.ukalkPdv.setFocusable(false);
            this.ukalkPdv.setForeground(new Color(0, 0, 160));
            this.eksterniTroskovi = this.table.createExpresionField("$12$");
            this.eksterniTroskovi.setBackground(new Color(220, 220, 220));
            this.eksterniTroskovi.setColumns(12);
            this.pnlSumarneVrednosti.add((Component)this.eksterniTroskovi, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 5), 0, 0));
            this.eksterniTroskovi.setEditable(false);
            this.eksterniTroskovi.setFocusable(false);
            this.eksterniTroskovi.setForeground(new Color(0, 0, 160));
            this.jLabel12 = new JLabel();
            this.pnlSumarneVrednosti.add((Component)this.jLabel12, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 10), 0, 0));
            this.jLabel12.setText("Razlika u ceni");
            this.jLabel9 = new JLabel();
            this.pnlSumarneVrednosti.add((Component)this.jLabel9, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 10), 0, 0));
            this.jLabel9.setText("Vrednost PDV-a");
            this.prodVrednost = this.table.createExpresionField("$10$");
            this.prodVrednost.setBackground(new Color(220, 220, 220));
            this.prodVrednost.setColumns(12);
            this.pnlSumarneVrednosti.add((Component)this.prodVrednost, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel13 = new JLabel();
            this.pnlSumarneVrednosti.add((Component)this.jLabel13, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 10), 0, 0));
            this.jLabel13.setText("Ukalkulisani PDV");
            this.jLabel10 = new JLabel();
            this.pnlSumarneVrednosti.add((Component)this.jLabel10, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel10.setText("Eksterni tro\u0161kovi");
            this.jLabel14 = new JLabel();
            this.pnlSumarneVrednosti.add((Component)this.jLabel14, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel14.setText("Prodajna vrednost");
            this.prodVrednost.setEditable(false);
            this.prodVrednost.setFocusable(false);
            this.prodVrednost.setForeground(new Color(0, 0, 160));
            this.toolbar = new JToolBar();
            this.pnlContent.add((Component)this.toolbar, (Object)"North");
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setFloatable(false);
            this.toolbar.setOpaque(false);
            this.icnSlika = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSlika);
            this.icnSlika.setText("Slika|dokumenta|(F2)");
            this.icnSlika.setIcon((Icon)new ImageIcon(PzDialogKalkArhiva.class.getResource("/rs/pezar/nabavka/resource/img/presentation_chart.png")));
            this.icnSlika.setActionCommand("slika");
            this.icnSlika.addActionListener((ActionListener)((Object)this));
            this.icnSlika.setShortcut("F2");
            this.icnPripremaZaStampu = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnPripremaZaStampu);
            this.icnPripremaZaStampu.setText("Priprema|za \u0161tampu|(Alt+S)");
            this.icnPripremaZaStampu.addActionListener((ActionListener)((Object)this));
            this.icnPripremaZaStampu.setShortcut("alt+s");
            this.icnPripremaZaStampu.setActionCommand("priprema_za_stampu");
            this.icnPripremaZaStampu.setIcon((Icon)new ImageIcon(PzDialogKalkArhiva.class.getResource("/rs/pezar/nabavka/resource/img/printer_view.png")));
            this.icnUpit = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnUpit);
            this.icnUpit.setText("Upit u NZK|(F5)");
            this.icnUpit.setPreferredSize(new Dimension(82, 90));
            this.icnUpit.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/nzk.png")));
            this.icnUpit.setShortcut("f5");
            this.icnUpit.setActionCommand("nzk");
            this.icnUpit.addActionListener((ActionListener)((Object)this));
            JSeparator sep = new JSeparator();
            this.toolbar.add(sep);
            sep.setOrientation(1);
            sep.setPreferredSize(new Dimension(2, 75));
            this.icnStorniraj = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnStorniraj);
            this.icnStorniraj.setText("Storniranje|dokumenta|(F10)");
            this.icnStorniraj.setIcon((Icon)new ImageIcon(PzDialogKalkArhiva.class.getResource("/rs/pezar/nabavka/resource/img/document_edit.png")));
            this.icnStorniraj.setActionCommand("storniraj");
            this.icnStorniraj.addActionListener((ActionListener)((Object)this));
            this.icnStorniraj.setShortcut("f10");
            this.pzButtonPanel1 = new PzRadioGroup();
            this.pzButtonPanel1.setValues((Object[])new PzChoice[]{new PzChoice("Kalkulacije", (Object)"="), new PzChoice("Storno kalkulacije", (Object)"<>")});
            this.pzButtonPanel1.setSelectedIndex(0);
            this.pzButtonPanel1.setOpaque(false);
            this.pnlPretraga.add(this.pzButtonPanel1, (Object)new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 5, 5), 0, 0));
            this.bntTrazi = new PzButton();
            GridBagConstraints gbc_bntTrazi = new GridBagConstraints();
            gbc_bntTrazi.fill = 2;
            gbc_bntTrazi.insets = new Insets(0, 0, 0, 5);
            gbc_bntTrazi.gridx = 1;
            gbc_bntTrazi.gridy = 3;
            this.pnlPretraga.add((Component)this.bntTrazi, (Object)gbc_bntTrazi);
            this.bntTrazi.setText("Tra\u017ei");
            this.bntTrazi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/find.png")));
            this.bntTrazi.addActionListener((ActionListener)((Object)this));
            this.bntTrazi.setActionCommand("trazi");
            this.pnlPretraga.setFocusTraversalPolicyProvider(true);
            this.pnlPretraga.setFocusTraversalPolicy((FocusTraversalPolicy)new FocusTraversalOnArray(new Component[]{this.pzButtonPanel1, this.datumOD, this.datumDO, this.oznDokument, this.brKalk, this.rgrKomitent, this.sfrKomitenta, this.bntTrazi, this.jLabel4, this.jLabel2, this.jLabel1, this.jLabel5, this.jLabel3, this.nazKomitenta, this.rbtnStorno}));
            this.statusBar = new PzStatusBar();
            this.pnlContent.add((Component)this.statusBar, (Object)"South");
            this.jLabel6 = new JLabel();
            this.statusBar.add((Component)this.jLabel6);
            this.jLabel6.setText("Broj dokumenata");
            this.brDok = new JLabel();
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(1024, 768);
            this.setMinimumSize(new Dimension(1024, 768));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        this.op = (String)((PzChoice)this.pzButtonPanel1.getSelectedValue()).getValue();
        String upit = this.createQuery();
        if (arg0.getSource() == this.rbtnKalkulacija) {
            this.icnStorniraj.setEnabled(true);
            return;
        }
        if (arg0.getSource() == this.rbtnStorno) {
            this.icnStorniraj.setEnabled(false);
            return;
        }
        PzButton button = (PzButton)arg0.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equalsIgnoreCase("trazikomitenta")) {
            this.fieldGroup.enable((Component)this.sfrKomitenta);
            return;
        }
        if (actionCommand.equalsIgnoreCase("trazidokument")) {
            this.nazKomitenta.setText("");
            this.fieldGroup.enable((Component)this.oznDokument);
            return;
        }
        if (actionCommand.equalsIgnoreCase("trazikalkulaciju")) {
            this.nazKomitenta.setText("");
            this.fieldGroup.enable((Component)this.brKalk);
            return;
        }
        if (actionCommand.equalsIgnoreCase("trazidatum")) {
            this.nazKomitenta.setText("");
            Vector<PzDateField> dates = new Vector<PzDateField>();
            dates.add(this.datumOD);
            dates.add(this.datumDO);
            this.fieldGroup.enable(dates);
            this.datumOD.setVal((Object)PzDateUtility.getFirstDayOfCurrentYear());
            this.datumDO.setVal((Object)PzDateUtility.getCurrentDate());
            return;
        }
        if (actionCommand.equals("trazi")) {
            this.em = PzEntityManager.getEm();
            String otpremnica = this.getIznosOtpremnica();
            String faktura = this.getIznosFaktura();
            Query q = null;
            if (!this.brKalk.getText().equals("")) {
                upit = String.valueOf(upit) + " and k.rBroj=':rBroj'";
                upit = upit.replaceAll(":rBroj", this.brKalk.getVal());
                otpremnica = String.valueOf(otpremnica) + " and k.rBroj='" + this.brKalk.getVal() + "'";
                faktura = String.valueOf(faktura) + " and k.rBroj='" + this.brKalk.getVal() + "'";
            } else if (!this.oznDokument.getText().equals("")) {
                upit = String.valueOf(upit) + " and k.oznDokumenta=':oznDokumenta'";
                upit = upit.replaceAll(":oznDokumenta", this.oznDokument.getVal());
                otpremnica = String.valueOf(otpremnica) + " and k.oznDokumenta='" + this.oznDokument.getVal() + "'";
                faktura = String.valueOf(faktura) + " and k.oznDokumenta='" + this.oznDokument.getVal() + "'";
            }
            if (this.sfrKomitenta.isEnabled()) {
                upit = String.valueOf(upit) + " and k.sfrKomitent=':sfrKomitenta'";
                upit = upit.replaceAll(":sfrKomitenta", this.sfrKomitenta.getVal());
                otpremnica = String.valueOf(otpremnica) + " and k.rBroj='" + this.sfrKomitenta.getVal() + "'";
                faktura = String.valueOf(faktura) + " and k.rBroj='" + this.sfrKomitenta.getVal() + "'";
            }
            if (this.datumOD.isEnabled() && this.datumDO.isEnabled()) {
                upit = String.valueOf(upit) + " AND k.datum>=':datumOD' AND k.datum<=':datumDO'";
                upit = upit.replaceAll(":datumOD", this.datumOD.getVal().toString());
                upit = upit.replaceAll(":datumDO", this.datumDO.getVal().toString());
                otpremnica = String.valueOf(otpremnica) + " AND k.datum>='" + this.datumOD.getVal().toString() + "' AND k.datum<='" + this.datumDO.getVal().toString() + "'";
                faktura = String.valueOf(faktura) + " AND k.datum>='" + this.datumOD.getVal().toString() + "' AND k.datum<='" + this.datumDO.getVal().toString() + "'";
            }
            upit = String.valueOf(upit) + " ORDER BY k.rBroj";
            q = this.em.createNativeQuery(upit);
            q.setHint("eclipselink.cursor.scrollable", (Object)"True");
            if (this.cursor != null) {
                this.cursor.close();
            }
            this.cursor = (ScrollableCursor)q.getSingleResult();
            this.table.read(this.cursor, this.k.getKalkColumnNames());
            this.table.calculateFields();
            if (this.table.convertColumnIndexToView(0) != -1) {
                this.table.getColumnExt(0).setVisible(false);
            }
            this.scpKalkulacije.setViewportView((Component)this.table);
            if (this.cursor.size() > 0) {
                this.table.setRowSelectionInterval(0, 0);
                this.table.requestFocusInWindow();
            }
            if (this.table.getRowCount() > 0) {
                this.table.setRowSelectionInterval(0, 0);
            }
            this.brDok.setText(String.valueOf(this.table.getRowCount()));
            Query otp = this.em.createQuery(otpremnica);
            BigDecimal vredOtpremnica = (BigDecimal)otp.getSingleResult();
            Query fak = this.em.createQuery(faktura);
            BigDecimal vredFaktura = (BigDecimal)fak.getSingleResult();
            this.vrednostOtpremnica.setVal((Object)vredOtpremnica);
            this.vrednostFaktura.setVal((Object)vredFaktura);
            return;
        }
        if (actionCommand.equals("slika")) {
            if (this.table == null || this.table.getSelectedRow() == -1) {
                return;
            }
            PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)((Kalkulacija)this.getSelectedEntity()));
            return;
        }
        if (actionCommand.equalsIgnoreCase("priprema_za_stampu")) {
            int brojDok = 0;
            try {
                brojDok = Integer.parseInt(this.brDok.getText());
                if (brojDok >= 1) {
                    this.showReport();
                }
            }
            catch (NumberFormatException numberFormatException) {}
            return;
        }
        if (actionCommand.equals("nzk")) {
            try {
                if (this.table.getRowCount() == 0) {
                    return;
                }
                PzGenericService gs = PzApplication.getApplication().getGenericServiceRegistry().getService("NZK_SERVICE");
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("NZK_DOKUMENT", this.getSelectedEntity());
                params.put("NZK_PARENT_DIALOG", (Object)this);
                gs.run(params);
                return;
            }
            catch (Exception e1) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                return;
            }
        }
        if (actionCommand.equals("storniraj")) {
            if (this.table == null || this.table.getSelectedRow() == -1) {
                return;
            }
            Kalkulacija selectedEntity = (Kalkulacija)this.getSelectedEntity();
            if (selectedEntity.getStorno() == 1) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Storno dokument! Storniranje nije mogu\u0107e!", "Informacija", 1);
                return;
            }
            if (selectedEntity.getPodTip().equalsIgnoreCase(TipDokumentConfig.get().OTPREMNICA) && selectedEntity.getIznos().subtract(selectedEntity.getStornoIznos()).subtract(selectedEntity.getUkupnoFakturisano()).compareTo(new BigDecimal(0)) == 0) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Otpremnica je u potpunosti fakturisana. Nije mogu\u0107a izrada storno dokumenta.");
                return;
            }
            this.getSession().putParameter("kalkulacija", (Object)this.getSelectedEntity());
            this.showDialog(StornoKalkulacije.class);
            return;
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogKalkArhiva(Boolean.FALSE);
    }

    public boolean shouldBeShown() {
        boolean result = false;
        this.rj = PzDialogRJ.getRJ((PzDialog)this, (Character[])new Character[]{Character.valueOf("V".charAt(0)), Character.valueOf("E".charAt(0))});
        if (this.rj != null) {
            result = true;
            this.initGUI();
            try {
                this.k = new Kalkulacija();
                this.k.setArhiviran((short)1);
                this.setTitle("Kalkulacije iz arhive za radnu jedinicu " + this.rj.getPunNaziv());
                this.setPreferredSize(new Dimension(1024, 768));
                this.setPreferredSize(new Dimension(1024, 768));
                this.pnlContent.setPaintGradient(true);
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        }
        return result;
    }

    public PzDialogKalkArhiva(Boolean initGUI) {
    }

    public void focusTable() {
        this.table.requestFocusInWindow();
    }

    public void setEntity(PzEntity entity, Component component) {
        ((PzFieldImpl)component).setVal((Object)((Komitent)entity).getSfrKomitent());
        this.nazKomitenta.setText(((Komitent)entity).getNaziv());
    }

    private PzEntity getSelectedEntity() {
        Integer ozn = (Integer)this.table.getModel().getValueAt(this.table.convertRowIndexToModel(this.table.getSelectedRow()), 0);
        Kalkulacija kalk = (Kalkulacija)this.em.createQuery("SELECT k from Kalkulacija k where k.idDok=:ozn").setParameter("ozn", (Object)ozn).getSingleResult();
        return kalk;
    }

    private String getIznosOtpremnica() {
        String upit = "SELECT SUM(k.iznos) FROM Kalkulacija k WHERE k.tip='" + TipDokumentConfig.get().KALKULACIJA + "' AND (k.podTip='" + TipDokumentConfig.get().PODTIP_KALKULACIJA_OTPREMNICA + "' " + "OR k.podTip='" + TipDokumentConfig.get().PODTIP_KALKULACIJA_PRENOSNICA + "') " + "and k.arhiviran = 1 and k.storno" + this.op + "0 and k.radnajedinica.id.oznRj = '" + this.rj.getId().getOznRj() + "' and k.radnajedinica.id.oznOgranak='" + this.rj.getId().getOznOgranak() + "'";
        return upit;
    }

    private String getIznosFaktura() {
        String upit = "SELECT SUM(k.iznos) FROM Kalkulacija k WHERE k.tip='" + TipDokumentConfig.get().KALKULACIJA + "' AND k.podTip='" + TipDokumentConfig.get().PODTIP_KALKULACIJA_FAKTURA + "' " + "and k.arhiviran = 1 and k.storno" + this.op + "0 and k.radnajedinica.id.oznRj = '" + this.rj.getId().getOznRj() + "' and k.radnajedinica.id.oznOgranak='" + this.rj.getId().getOznOgranak() + "'";
        return upit;
    }

    private String createQuery() {
        String upitNative = null;
        if (this.rj.getgTip().equalsIgnoreCase("V")) {
            upitNative = "SELECT k.iddok, k.rBroj, k.datum, k.datFakture, k.sfrKomitent, k.oznDokumenta, k.iznos, k.podTip, k.razlUCeni, 0, k.prodVrednost, (SELECT SUM(tk.iznos) FROM TaksaKalkulacija tk WHERE tk.iddok = k.iddok), (SELECT SUM(tr.iznos) FROM Kalkulacija tr WHERE tr.tip = 'TROSAK' AND tr.podTip='EKSTERNI' AND tr.idkalkulacija=k.iddok), (SELECT SUM(tr.iznos) FROM Kalkulacija tr WHERE tr.podTip='INTERNI' AND tr.idkalkulacija=k.iddok), k.usernamekraj FROM Kalkulacija k WHERE k.storno" + this.op + "0 AND k.arhiviran=1 AND k.oznRJ='rj' AND k.oznOgranak='ogranak' " + "AND k.tip='" + TipDokumentConfig.get().KALKULACIJA + "'";
        } else if (this.rj.getgTip().equalsIgnoreCase("E")) {
            upitNative = "SELECT k.iddok, k.rBroj, k.datum, k.datFakture, k.sfrKomitent, k.oznDokumenta, k.iznos, k.podTip, k.razlUCeni, (SELECT SUM(akt.iznos) FROM Taksakalkulacija akt WHERE akt.vrsta='PDV' AND akt.iddok=k.iddok AND akt.tip='UK'),k.prodVrednost, (SELECT SUM(tk.iznos) FROM TaksaKalkulacija tk WHERE tk.iddok = k.iddok AND tk.vrsta='PDV' AND tk.tip='U'), (SELECT SUM(tr.iznos) FROM Kalkulacija tr WHERE tr.tip='EKSTERNI' AND tr.idkalkulacija=k.iddok), (SELECT SUM(tr.iznos) FROM Kalkulacija tr WHERE tr.tip='INTERNI' AND tr.idkalkulacija=k.iddok), k.usernamekraj FROM Kalkulacija k WHERE k.storno" + this.op + "0 AND k.arhiviran=1 AND k.oznRJ='rj' " + "AND k.tip='" + TipDokumentConfig.get().KALKULACIJA + "'";
        }
        upitNative = upitNative.replaceAll("rj", this.rj.getId().getOznRj()).replaceAll("ogranak", this.rj.getId().getOznOgranak());
        return upitNative;
    }

    protected void thisWindowClosing(WindowEvent evt) {
        if (this.cursor != null && this.em != null) {
            this.cursor.close();
            if (this.em.isOpen()) {
                this.em.close();
            }
        }
        super.thisWindowClosing(evt);
    }

    public void showReport() {
        try {
            Vector<Object> data = new Vector<Object>();
            data.add(PzFirma.getFirma());
            data.add(this.rj);
            PzTableDataSource ds = new PzTableDataSource((PzAbstractTable)this.table, data);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("datumOd", this.datumOD.getVal());
            params.put("datumDo", this.datumDO.getVal());
            params.put("datum", new Date(new java.util.Date().getTime()));
            String title = null;
            String fname = null;
            title = "PREGLED URA\u0110ENIH KALKULACIJA";
            params.put("title", title);
            if (this.rj.getTip().equals("V")) {
                if (this.rj.getNacinVodjenja().equals("PRODAJNA")) {
                    fname = "rs/pezar/reports/compiled/kalkulacija.v.stampa.jasper";
                } else if (this.rj.getNacinVodjenja().equals("PRNC")) {
                    fname = "rs/pezar/reports/compiled/kalkulacija.v.prnc.stampa.jasper";
                }
            } else {
                fname = "rs/pezar/reports/compiled/kalkulacija.m.stampa.jasper";
            }
            try {
                PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)fname, params, (String)title);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    protected void rgrKomitentselectionChanged(PzRadioGroupEvent evt) {
        if (evt.getStateChange() == 1) {
            if (evt.getValue().equals("Svi komitenti")) {
                if (this.sfrKomitenta != null) {
                    this.sfrKomitenta.setEnabled(false);
                }
            } else {
                this.sfrKomitenta.setEnabled(true);
            }
        }
    }

    protected void keyReleasedAction(KeyEvent arg0) {
        if (((JTextField)arg0.getSource()).getText().equals("")) {
            this.fieldGroup.enableAll();
            if (((String)this.rgrKomitent.getSelectedValue()).equals("Svi komitenti")) {
                this.sfrKomitenta.setEnabled(false);
            } else {
                this.sfrKomitenta.setEnabled(true);
            }
        } else {
            this.fieldGroup.enable((Component)arg0.getSource());
        }
    }

    public static Kalkulacija getKalkulacijaIzArhive(PzDialog parent) {
        PzDialogKalkArhiva dlg = new PzDialogKalkArhiva(parent);
        if (!dlg.shouldBeShown()) {
            return null;
        }
        dlg.table.setEnterAction(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                selected = (Kalkulacija)PzDialogKalkArhiva.this.getSelectedEntity();
                PzDialogKalkArhiva.this.dispose();
            }
        });
        dlg.restoreSize();
        dlg.setModal(true);
        dlg.setVisible(true);
        Kalkulacija res = selected;
        selected = null;
        return res;
    }
}

