/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.FetchGroup;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Komitent;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzTableDataSource;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzButtonPanel;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.event.PzButtonPanelSelectionListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;

public class PzDialogOtpremniceNepokriveneFakturom
extends PzDialogInsert {
    private JPanel mainPanel;
    private ButtonGroup R_dok_bezf;
    private JRadioButton sve_nepokrivene_otpremnice;
    private JRadioButton konkretan_dobavljac;
    private PzNumericOnlyTextField sdob;
    private PzDoubleField txtUkupnoNefakturisano;
    private PzFieldIndikator indKomitent;
    private PzTextField txtNazivDobavljaca;
    private PzButtonPanel pnlRadioButton;
    private PzPanel pnlPretraga;
    private JLabel jLabelukupnoNefakturisano;
    private PzButton B_dok_bezf_ok;
    private PzTable table;
    private JScrollPane browseScrollPane;
    private JToolBar toolbar;
    private PzToolBarIcon icnStampanje;
    private String query;
    private Vector kalkulacija;
    private JPanel pnlTable;
    private FetchGroup group;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogOtpremniceNepokriveneFakturom inst = new PzDialogOtpremniceNepokriveneFakturom(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogOtpremniceNepokriveneFakturom() {
        this.initGUI();
    }

    public PzDialogOtpremniceNepokriveneFakturom(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogOtpremniceNepokriveneFakturom(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    protected void initGUI() {
        this.setTitle("Otpremnice nepokrivene fakturom");
        this.mainPanel = new JPanel();
        this.getContentPane().add((Component)this.mainPanel, "Center");
        GridBagLayout gbl_mainPanel = new GridBagLayout();
        int[] nArray = new int[2];
        nArray[0] = 784;
        gbl_mainPanel.columnWidths = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 99;
        nArray2[1] = 36;
        nArray2[2] = 388;
        gbl_mainPanel.rowHeights = nArray2;
        gbl_mainPanel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_mainPanel.rowWeights = new double[]{0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.mainPanel.setLayout(gbl_mainPanel);
        this.toolbar = new JToolBar();
        FlowLayout toolbarLayout = new FlowLayout();
        this.toolbar.setLayout(toolbarLayout);
        toolbarLayout.setAlignment(0);
        toolbarLayout.setHgap(10);
        this.toolbar.setBounds(50, 530, 125, 27);
        GridBagConstraints gbc_toolbar = new GridBagConstraints();
        gbc_toolbar.anchor = 18;
        gbc_toolbar.insets = new Insets(0, 0, 5, 0);
        gbc_toolbar.gridx = 0;
        gbc_toolbar.gridy = 0;
        this.mainPanel.add((Component)this.toolbar, gbc_toolbar);
        this.icnStampanje = new PzToolBarIcon();
        this.toolbar.add((Component)this.icnStampanje);
        this.icnStampanje.setText("\u0160tampanje| (ALT+S)");
        this.icnStampanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/box_text.png")));
        this.icnStampanje.addActionListener((ActionListener)((Object)this));
        this.icnStampanje.setShortcut("alt+s");
        this.icnStampanje.setActionCommand("stampaj");
        this.pnlPretraga = new PzPanel();
        GridBagLayout pnlPretragaLayout = new GridBagLayout();
        GridBagConstraints gbc_pnlPretraga = new GridBagConstraints();
        gbc_pnlPretraga.fill = 1;
        gbc_pnlPretraga.insets = new Insets(0, 0, 5, 0);
        gbc_pnlPretraga.gridx = 0;
        gbc_pnlPretraga.gridy = 1;
        this.mainPanel.add((Component)this.pnlPretraga, gbc_pnlPretraga);
        this.pnlPretraga.setBounds(3, 0, 769, 108);
        pnlPretragaLayout.rowWeights = new double[]{0.1, 0.1, 0.0, 0.1};
        pnlPretragaLayout.rowHeights = new int[]{7, 7, 28, 7};
        pnlPretragaLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
        pnlPretragaLayout.columnWidths = new int[]{197, 105, 38, 311, 7};
        this.pnlPretraga.setLayout((LayoutManager)pnlPretragaLayout);
        this.jLabelukupnoNefakturisano = new JLabel();
        this.pnlPretraga.add((Component)this.jLabelukupnoNefakturisano, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jLabelukupnoNefakturisano.setText("Ukupno nefakturisano:");
        this.jLabelukupnoNefakturisano.setBounds(24, 89, 131, 16);
        this.jLabelukupnoNefakturisano.setForeground(new Color(0, 0, 255));
        this.sdob = new PzNumericOnlyTextField();
        this.sdob.setBounds(223, 29, 114, 27);
        this.pnlPretraga.add((Component)this.sdob, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.sdob.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
        this.B_dok_bezf_ok = new PzButton();
        this.pnlPretraga.add((Component)this.B_dok_bezf_ok, (Object)new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.B_dok_bezf_ok.setText("Tra\u017ei");
        this.B_dok_bezf_ok.addActionListener((ActionListener)((Object)this));
        this.B_dok_bezf_ok.setActionCommand("prikazi");
        this.B_dok_bezf_ok.setBounds(223, 62, 114, 27);
        this.B_dok_bezf_ok.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/find.png")));
        this.B_dok_bezf_ok.setPreferredSize(new Dimension(137, 31));
        this.pnlRadioButton = new PzButtonPanel();
        GridBagLayout pnlRadioButtonLayout = new GridBagLayout();
        this.pnlPretraga.add((Component)this.pnlRadioButton, (Object)new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        pnlRadioButtonLayout.rowWeights = new double[]{0.0, 0.1};
        pnlRadioButtonLayout.rowHeights = new int[]{35, 7};
        pnlRadioButtonLayout.columnWeights = new double[]{0.1};
        pnlRadioButtonLayout.columnWidths = new int[]{7};
        this.pnlRadioButton.setLayout((LayoutManager)pnlRadioButtonLayout);
        this.pnlRadioButton.setSelectionListener(this.getSelectionListener());
        this.R_dok_bezf = new ButtonGroup();
        this.konkretan_dobavljac = new JRadioButton();
        this.pnlRadioButton.add((Component)this.konkretan_dobavljac, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        this.konkretan_dobavljac.setText("Konkretan dobavlja\u010d");
        this.konkretan_dobavljac.setBounds(23, 30, 154, 25);
        this.konkretan_dobavljac.setActionCommand("konkretan_dobavljac");
        this.sve_nepokrivene_otpremnice = new JRadioButton();
        this.pnlRadioButton.add((Component)this.sve_nepokrivene_otpremnice, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        this.sve_nepokrivene_otpremnice.setText("Sve nepokrivene otpremnice");
        this.sve_nepokrivene_otpremnice.setBounds(23, 4, 200, 25);
        this.sve_nepokrivene_otpremnice.setActionCommand("sve_nepokrivene");
        this.sve_nepokrivene_otpremnice.setSelected(true);
        this.R_dok_bezf.add(this.sve_nepokrivene_otpremnice);
        this.R_dok_bezf.add(this.konkretan_dobavljac);
        this.txtNazivDobavljaca = new PzTextField();
        this.pnlPretraga.add((Component)this.txtNazivDobavljaca, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.txtNazivDobavljaca.setEditable(false);
        this.txtNazivDobavljaca.setFocusable(false);
        this.indKomitent = new PzFieldIndikator();
        this.pnlPretraga.add((Component)this.indKomitent, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.txtUkupnoNefakturisano = new PzDoubleField();
        this.pnlPretraga.add((Component)this.txtUkupnoNefakturisano, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.txtUkupnoNefakturisano.setEditable(false);
        this.txtUkupnoNefakturisano.setDragEnabled(true);
        this.txtUkupnoNefakturisano.setFocusable(false);
        this.sdob.setStateIndikator(this.indKomitent);
        this.pnlTable = new JPanel();
        this.pnlTable.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints gbc_pnlTable = new GridBagConstraints();
        gbc_pnlTable.fill = 1;
        gbc_pnlTable.gridx = 0;
        gbc_pnlTable.gridy = 2;
        this.mainPanel.add((Component)this.pnlTable, gbc_pnlTable);
        this.pnlTable.setLayout(new BorderLayout(0, 0));
        this.browseScrollPane = new JScrollPane();
        this.pnlTable.add(this.browseScrollPane);
        this.table = new PzTable();
        this.setTableFilter(this.table);
        this.browseScrollPane.setViewportView((Component)this.table);
        this.browseScrollPane.setBounds(12, 111, 760, 388);
        this.pack();
        this.setSize(864, 667);
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equalsIgnoreCase("prikazi")) {
            if (this.group == null) {
                this.group = new FetchGroup();
                this.group.addAttribute("idDok");
                this.group.addAttribute("oznDokumenta");
                this.group.addAttribute("datum");
                this.group.addAttribute("iznos");
                this.group.addAttribute("tip");
                this.group.addAttribute("podTip");
                this.group.addAttribute("rbrDok");
                this.group.addAttribute("stornoIznos");
                this.group.addAttribute("ukupnoFakturisano");
                this.group.addAttribute("storno");
                this.group.addAttribute("arhiviran");
                this.group.addAttribute("komitent.sfrKomitent");
                this.group.addAttribute("komitent.naziv");
            }
            EntityManager em = PzEntityManager.getEm();
            this.query = this.R_dok_bezf.getSelection().getActionCommand().equalsIgnoreCase("sve_nepokrivene") ? "SELECT k FROM Kalkulacija k join fetch k.komitent WHERE k.arhiviran = 1 AND k.storno = 0 AND (k.iznos-k.stornoIznos-k.ukupnoFakturisano <> 0) AND (k.podTip = '" + TipDokumentConfig.get().PODTIP_KALKULACIJA_OTPREMNICA + "' OR k.podTip='" + TipDokumentConfig.get().PODTIP_KALKULACIJA_PRENOSNICA + "') ORDER BY k.komitent.sfrKomitent, k.rbrDok" : "SELECT k FROM Kalkulacija k WHERE k.arhiviran = 1 AND k.storno = 0 AND (k.iznos-k.stornoIznos-k.ukupnoFakturisano <> 0) AND (k.podTip = '" + TipDokumentConfig.get().PODTIP_KALKULACIJA_OTPREMNICA + "' OR k.podTip='" + TipDokumentConfig.get().PODTIP_KALKULACIJA_PRENOSNICA + "') AND k.komitent.sfrKomitent = '" + this.sdob.getVal() + "' ORDER BY k.rbrDok";
            Query q = em.createQuery(this.query);
            q.setHint("eclipselink.fetch-group", (Object)this.group);
            this.kalkulacija = (Vector)q.getResultList();
            this.table.setData(this.kalkulacija, Kalkulacija.class);
            if (this.kalkulacija.size() > 0) {
                Iterator kalk = this.kalkulacija.iterator();
                BigDecimal ukupno = new BigDecimal(0.0);
                while (kalk.hasNext()) {
                    Kalkulacija k = (Kalkulacija)kalk.next();
                    ukupno = ukupno.add(k.getIznos().subtract(k.getStornoIznos()).subtract(k.getUkupnoFakturisano()));
                }
                this.txtUkupnoNefakturisano.setVal((Object)ukupno);
            }
        } else if (actionCommand.equalsIgnoreCase("stampaj") && this.table.getDataSize() > 0) {
            this.showReport();
            return;
        }
    }

    public PzButtonPanelSelectionListener getSelectionListener() {
        return new PzButtonPanelSelectionListener(){

            public void buttonSelected(AbstractButton b) {
                String actionCommand = b.getActionCommand();
                if (actionCommand.equalsIgnoreCase("sve_nepokrivene")) {
                    PzDialogOtpremniceNepokriveneFakturom.this.txtNazivDobavljaca.setEnabled(false);
                    PzDialogOtpremniceNepokriveneFakturom.this.sdob.setEnabled(false);
                    PzDialogOtpremniceNepokriveneFakturom.this.indKomitent.setEnabled(false);
                } else {
                    PzDialogOtpremniceNepokriveneFakturom.this.txtNazivDobavljaca.setEnabled(true);
                    PzDialogOtpremniceNepokriveneFakturom.this.sdob.setEnabled(true);
                    PzDialogOtpremniceNepokriveneFakturom.this.indKomitent.setEnabled(true);
                }
            }
        };
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            ((PzNumericOnlyTextField)component).setVal((Object)((Komitent)entity).getSfrKomitent());
            this.txtNazivDobavljaca.setVal((Object)((Komitent)entity).getNaziv());
        }
    }

    public void showReport() {
        Vector<Firma> data = new Vector<Firma>();
        try {
            data.add(PzFirma.getFirma());
            PzTableDataSource ds = new PzTableDataSource((PzAbstractTable)this.table, data);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("datum", new Date(new java.util.Date().getTime()));
            String title = null;
            String fname = null;
            title = "OTPREMNICE NEPOKRIVENE FAKTUROM";
            params.put("title", title);
            params.put("reklama", "");
            fname = "rs/pezar/reports/compiled/otpremnice.nepokrivene.stampa.jasper";
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)fname, params, (String)title);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void setTableFilter(PzTable table) {
        table.setFilter(new PzEntityFilter(){

            public Object[] getValues(PzEntity entity) {
                Kalkulacija k = (Kalkulacija)entity;
                return new Object[]{k.getIdDok(), k.getKomitent().getSfrKomitent(), k.getOznDokumenta(), k.getDatFakture(), k.getIznos(), k.getStornoIznos(), k.getUkupnoFakturisano(), k.getIznos().subtract(k.getStornoIznos()).subtract(k.getUkupnoFakturisano()), k.getKomitent().getNaziv()};
            }

            public String[] getColumnNames() {
                return new String[]{"idDok", "\u0160ifra", "Otpremnica", "Datum", "Iznos", "Storno", "Fakturisano", "Dug", "Naziv"};
            }
        });
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogOtpremniceNepokriveneFakturom(Boolean.FALSE);
    }

    public PzDialogOtpremniceNepokriveneFakturom(Boolean initGUI) {
    }

    protected void onInsert() {
    }

    protected void onUpdate() {
    }

    protected void setHeaderOnInsert() {
    }

    protected void setHeaderOnUpdate() {
    }
}

