/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.gui;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.commons.beanutils.BeanUtils;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentException;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Id_gen;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Kalkulacijazapisnik;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Taksakalkulacija;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.nabavka.gui.stornoNaknadneFakture.Selektiranje;
import rs.pezar.nabavka.gui.unosNaknadneFakture.PzDialogPDV;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.data.models.PzManageableTableModel;
import rs.pezar.swing.event.PzTableCheckboxListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldImpl;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzIntegerField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogStornoNaknadneFakture
extends PzDialogInsert {
    private static final long serialVersionUID = -7780203815353312924L;
    private PzPanelHeader header;
    private JPanel mainPanel;
    private PzPanel pnlZaglavlje;
    private PzPanel pnlRight;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel8;
    private PzTextField brDokumenta;
    private JLabel jLabel6;
    private PzDoubleField iznos;
    private PzNumericOnlyTextField sfrKomitent;
    private PzToolBarIcon icnArhiva;
    private JPanel pnlTable;
    private PzToolBarIcon icnAzurPdv;
    private PzToolBarIcon icnSelektiranje;
    private JPanel pnlIcons1;
    private JScrollPane scpIcons;
    private PzTable table;
    private JScrollPane scpArtikli;
    private PzDoubleField txtStornoPDv;
    private PzDoubleField txtNepokriveno;
    private PzDoubleField txtPDV;
    private PzDoubleField txtUkupneUplate;
    private PzFieldIndikator indStornoIznos;
    private PzDoubleField txtStorno;
    private PzIntegerField txtNZK;
    private PzDoubleField txtStornoIznos;
    private PzDoubleField txtDugPoFakturi;
    private PzDoubleField txtIznosDokumenta;
    private PzTextField txtNazivKomitenta;
    private JSplitPane splitPane;
    private JLabel jLabel12;
    private JLabel jLabel19;
    private JLabel jLabel10;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private Kalkulacijazapisnik kz;
    private PzDateField datIzrade;
    private JLabel jLabel1;
    private PzComponentGroup compGroupZaglavlje;
    private PzComponentGroup compGroupTable;
    private Kalkulacija zapisnik;
    private int arhivaIndikator;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogStornoNaknadneFakture inst = new PzDialogStornoNaknadneFakture(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogStornoNaknadneFakture(JFrame frame) {
        super(frame);
        this.zapisnik = new Kalkulacija();
        this.initGUI();
    }

    public PzDialogStornoNaknadneFakture(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    private void initFill() {
        this.sfrKomitent.setVal((Object)this.zapisnik.getKomitent().getSfrKomitent());
        this.brDokumenta.setVal((Object)this.zapisnik.getOznDokumenta());
        this.txtNazivKomitenta.setVal((Object)this.zapisnik.getKomitent().getNaziv());
        this.txtIznosDokumenta.setVal((Object)this.zapisnik.getIznos());
        this.txtPDV.setVal((Object)this.txtStornoPDv.getVal());
        this.txtStornoIznos.setVal((Object)this.zapisnik.getStornoIznos());
        this.txtUkupneUplate.setVal((Object)this.zapisnik.getUplata());
        this.table.setEnabled(false);
        this.icnSelektiranje.setEnabled(false);
        this.icnAzurPdv.setEnabled(false);
        this.icnArhiva.setEnabled(false);
        this.txtNZK.setVal((Object)this.findNzk());
        this.txtDugPoFakturi.setVal((Object)this.zapisnik.getIznos().subtract(this.zapisnik.getStornoIznos()).subtract(this.zapisnik.getUplata()));
        this.arhivaIndikator = 0;
    }

    public boolean shouldBeShown() {
        try {
            this.zapisnik = (Kalkulacija)PzEntityUtil.createStorno((PzDokument)((Kalkulacija)this.getSession().getParameter("zapisnik")));
            this.calculatePDV();
            this.instantiateTable();
            this.initFill();
            return true;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            return false;
        }
    }

    private int findNzk() {
        String query = "SELECT DISTINCT(n.nzk.idNalog) FROM Stavkanzk n WHERE n.dokument.idDok = " + this.zapisnik.getIdDok();
        int nzk = 0;
        EntityManager em1 = PzEntityManager.getEm();
        Query q = em1.createQuery(query);
        nzk = q.getResultList().size() == 0 ? 0 : (Integer)q.getSingleResult();
        return nzk;
    }

    private void instantiateTable() {
        this.table = new PzTable(this.zapisnik.getKalkulacijazapisniks2(), Kalkulacijazapisnik.class);
        KeyStroke f2 = KeyStroke.getKeyStroke("F2");
        this.table.setCheckboxColumn(0, f2);
        this.scpArtikli.setViewportView((Component)this.table);
        this.setTableData(this.table);
        this.table.addCheckboxListener(new PzTableCheckboxListener(){

            public void valueChanged(int rowIndex, PzEntity entity, boolean newValue) {
                if (PzDialogStornoNaknadneFakture.this.table.getSelectedEntity() == null) {
                    return;
                }
                Kalkulacijazapisnik cfr_ignored_0 = (Kalkulacijazapisnik)PzDialogStornoNaknadneFakture.this.table.getSelectedEntity();
                if (((Kalkulacijazapisnik)PzDialogStornoNaknadneFakture.this.table.getSelectedEntity()).getStornirano() == null || ((Kalkulacijazapisnik)PzDialogStornoNaknadneFakture.this.table.getSelectedEntity()).getStornirano().compareTo(new BigDecimal(0)) == 0) {
                    return;
                }
                PzDialogStornoNaknadneFakture.this.calculateVrednosti();
            }
        });
        this.table.setPreferredSize(new Dimension(721, 183));
    }

    protected void initGUI() {
        try {
            this.mainPanel = new JPanel();
            BorderLayout mainPanelLayout = new BorderLayout();
            this.mainPanel.setLayout(mainPanelLayout);
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.header = new PzPanelHeader();
            this.header.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/document_kalkulacija.png")));
            this.header.setTitle("Storno naknadne fakture");
            this.mainPanel.add((Component)this.header, "North");
            this.pnlRight = new PzPanel();
            GridBagLayout pnlTableLayout = new GridBagLayout();
            pnlTableLayout.columnWeights = new double[]{0.1};
            pnlTableLayout.columnWidths = new int[]{7};
            pnlTableLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
            pnlTableLayout.rowHeights = new int[]{141, 5, 291};
            this.pnlRight.setLayout((LayoutManager)pnlTableLayout);
            this.pnlRight.setPreferredSize(new Dimension(792, 330));
            this.pnlZaglavlje = new PzPanel();
            this.pnlRight.add((Component)this.pnlZaglavlje, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout pnlZaglavljeLayout = new GridBagLayout();
            this.pnlZaglavlje.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Zaglavlje", 4, 0));
            pnlZaglavljeLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            pnlZaglavljeLayout.rowHeights = new int[]{23, 23, 23, 12, 23, 22, 12, 23};
            pnlZaglavljeLayout.columnWeights = new double[]{0.1, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.1};
            pnlZaglavljeLayout.columnWidths = new int[]{20, 98, 86, 20, 95, 98, 99, 20};
            this.pnlZaglavlje.setLayout((LayoutManager)pnlZaglavljeLayout);
            this.pnlZaglavlje.setTransferFocusOnEnter(true);
            this.pnlZaglavlje.setFocusable(false);
            this.txtNazivKomitenta = new PzTextField();
            this.pnlZaglavlje.add((Component)this.txtNazivKomitenta, (Object)new GridBagConstraints(3, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
            this.txtNazivKomitenta.setEditable(false);
            this.txtNazivKomitenta.setFocusable(false);
            this.jLabel1 = new JLabel();
            this.pnlZaglavlje.add((Component)this.jLabel1, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel1.setText("Datum izrade");
            this.jLabel2 = new JLabel();
            this.pnlZaglavlje.add((Component)this.jLabel2, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel2.setText("\u0160ifra dobavlja\u010da");
            this.jLabel3 = new JLabel();
            this.pnlZaglavlje.add((Component)this.jLabel3, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel3.setText("Iznos dokumenta");
            this.jLabel4 = new JLabel();
            this.pnlZaglavlje.add((Component)this.jLabel4, (Object)new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel4.setText("Storno iznos");
            this.jLabel20 = new JLabel();
            this.pnlZaglavlje.add((Component)this.jLabel20, (Object)new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel20.setText("Ukupne uplate");
            this.jLabel21 = new JLabel();
            this.pnlZaglavlje.add((Component)this.jLabel21, (Object)new GridBagConstraints(5, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel21.setText("PDV");
            this.jLabel22 = new JLabel();
            this.pnlZaglavlje.add((Component)this.jLabel22, (Object)new GridBagConstraints(5, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel22.setText("NEPOKRIVENO");
            this.datIzrade = new PzDateField();
            this.pnlZaglavlje.add((Component)this.datIzrade, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.datIzrade.setFont(new Font("Tahoma", 0, 14));
            this.sfrKomitent = new PzNumericOnlyTextField();
            this.pnlZaglavlje.add((Component)this.sfrKomitent, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.sfrKomitent.setFont(new Font("Tahoma", 0, 14));
            this.sfrKomitent.setEditable(false);
            this.sfrKomitent.setFocusable(false);
            this.iznos = new PzDoubleField();
            this.pnlZaglavlje.add((Component)this.iznos, (Object)new GridBagConstraints(6, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.iznos.setFont(new Font("Tahoma", 0, 14));
            this.iznos.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent arg0) {
                    if (PzDialogStornoNaknadneFakture.this.iznos.getBigDecimal().compareTo(PzDialogStornoNaknadneFakture.this.zapisnik.getIznos().subtract(PzDialogStornoNaknadneFakture.this.zapisnik.getStornoIznos())) == 1) {
                        PzSwingUtility.showErrorMessage((Component)PzDialogStornoNaknadneFakture.this.iznos, (String)("Iznos za storniranje ne mo\u017ee biti ve\u0107i od preostalog iznosa na dokumentu(" + PzDialogStornoNaknadneFakture.this.zapisnik.getIznos().subtract(PzDialogStornoNaknadneFakture.this.zapisnik.getStornoIznos()) + ")"));
                        PzDialogStornoNaknadneFakture.this.setFirstComponentInFocus((Component)PzDialogStornoNaknadneFakture.this.iznos);
                        return;
                    }
                    PzDialogStornoNaknadneFakture.this.setFirstComponentInFocus((Component)PzDialogStornoNaknadneFakture.this.table);
                    PzDialogStornoNaknadneFakture.this.table.setEnabled(true);
                    if (PzDialogStornoNaknadneFakture.this.table.getRowCount() != 0) {
                        PzDialogStornoNaknadneFakture.this.table.setRowSelectionInterval(0, 0);
                    }
                    PzDialogStornoNaknadneFakture.this.icnSelektiranje.setEnabled(true);
                    PzDialogStornoNaknadneFakture.this.icnAzurPdv.setEnabled(true);
                    PzDialogStornoNaknadneFakture.this.icnArhiva.setEnabled(true);
                    PzDialogStornoNaknadneFakture.this.calculateVrednosti();
                }

                @Override
                public void focusGained(FocusEvent arg0) {
                    PzDialogStornoNaknadneFakture.this.iznos.setVal((Object)PzDialogStornoNaknadneFakture.this.zapisnik.getIznos().subtract(PzDialogStornoNaknadneFakture.this.zapisnik.getStornoIznos()));
                }
            });
            this.iznos.setVerifyInput(true);
            this.jLabel5 = new JLabel();
            this.pnlZaglavlje.add((Component)this.jLabel5, (Object)new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel5.setText("Storno iznos");
            this.jLabel6 = new JLabel();
            this.pnlZaglavlje.add((Component)this.jLabel6, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 6), 0, 0));
            this.jLabel6.setText("DUG po fakturi");
            this.brDokumenta = new PzTextField();
            this.pnlZaglavlje.add((Component)this.brDokumenta, (Object)new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.brDokumenta.setFont(new Font("Tahoma", 0, 14));
            this.brDokumenta.setEditable(false);
            this.brDokumenta.setFocusable(false);
            this.jLabel8 = new JLabel();
            this.pnlZaglavlje.add((Component)this.jLabel8, (Object)new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel8.setText("NZK");
            this.jLabel10 = new JLabel();
            this.pnlZaglavlje.add((Component)this.jLabel10, (Object)new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel10.setText("Storno");
            this.jLabel19 = new JLabel();
            this.pnlZaglavlje.add((Component)this.jLabel19, (Object)new GridBagConstraints(3, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel19.setText("Storno PDV-a");
            this.jLabel12 = new JLabel();
            this.pnlZaglavlje.add((Component)this.jLabel12, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel12.setText("Oznaka dokumenta");
            this.txtIznosDokumenta = new PzDoubleField();
            this.pnlZaglavlje.add((Component)this.txtIznosDokumenta, (Object)new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtIznosDokumenta.setEditable(false);
            this.txtIznosDokumenta.setFocusable(false);
            this.txtDugPoFakturi = new PzDoubleField();
            this.pnlZaglavlje.add((Component)this.txtDugPoFakturi, (Object)new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtDugPoFakturi.setEditable(false);
            this.txtDugPoFakturi.setFocusable(false);
            this.txtStornoIznos = new PzDoubleField();
            this.pnlZaglavlje.add((Component)this.txtStornoIznos, (Object)new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtStornoIznos.setEditable(false);
            this.txtStornoIznos.setFocusable(false);
            this.txtNZK = new PzIntegerField();
            this.pnlZaglavlje.add((Component)this.txtNZK, (Object)new GridBagConstraints(4, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtNZK.setEditable(false);
            this.txtNZK.setFocusable(false);
            this.txtUkupneUplate = new PzDoubleField();
            this.pnlZaglavlje.add((Component)this.txtUkupneUplate, (Object)new GridBagConstraints(6, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtUkupneUplate.setEditable(false);
            this.txtUkupneUplate.setFocusable(false);
            this.txtPDV = new PzDoubleField();
            this.pnlZaglavlje.add((Component)this.txtPDV, (Object)new GridBagConstraints(6, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtPDV.setEditable(false);
            this.txtPDV.setFocusable(false);
            this.txtNepokriveno = new PzDoubleField();
            this.pnlZaglavlje.add((Component)this.txtNepokriveno, (Object)new GridBagConstraints(6, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtNepokriveno.setEditable(false);
            this.txtNepokriveno.setFocusable(false);
            this.txtStornoPDv = new PzDoubleField();
            this.pnlZaglavlje.add((Component)this.txtStornoPDv, (Object)new GridBagConstraints(4, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtStornoPDv.setEditable(false);
            this.txtStornoPDv.setFocusable(false);
            this.txtStorno = new PzDoubleField();
            this.pnlZaglavlje.add((Component)this.txtStorno, (Object)new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtStorno.setEditable(false);
            this.txtStorno.setFocusable(false);
            this.indStornoIznos = new PzFieldIndikator();
            this.pnlZaglavlje.add((Component)this.indStornoIznos, (Object)new GridBagConstraints(7, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.pnlTable = new JPanel();
            GridBagLayout pnlTableLayout1 = new GridBagLayout();
            this.pnlRight.add((Component)this.pnlTable, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlTableLayout1.rowWeights = new double[]{0.0, 0.1};
            pnlTableLayout1.rowHeights = new int[]{218, 7};
            pnlTableLayout1.columnWeights = new double[]{0.1};
            pnlTableLayout1.columnWidths = new int[]{7};
            this.pnlTable.setLayout(pnlTableLayout1);
            this.pnlTable.setBackground(new Color(192, 192, 192));
            this.pnlTable.setBorder(BorderFactory.createEtchedBorder(1));
            this.scpArtikli = new JScrollPane();
            this.pnlTable.add((Component)this.scpArtikli, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
            this.scpIcons = new JScrollPane();
            this.splitPane = new JSplitPane();
            this.splitPane.getInputMap(1).put(KeyStroke.getKeyStroke(119, 0, false), "ENTER");
            this.splitPane.add((Component)this.pnlRight, "right");
            this.splitPane.add((Component)this.scpIcons, "left");
            this.scpIcons.setPreferredSize(new Dimension(70, 492));
            this.scpIcons.setSize(70, 492);
            this.pnlIcons1 = new JPanel();
            AnchorLayout pnlIcons1Layout = new AnchorLayout();
            this.pnlIcons1.setLayout(pnlIcons1Layout);
            this.scpIcons.setViewportView(this.pnlIcons1);
            this.pnlIcons1.setBackground(new Color(192, 192, 192));
            this.pnlIcons1.setPreferredSize(new Dimension(81, 486));
            this.icnSelektiranje = new PzToolBarIcon();
            this.pnlIcons1.add((Component)this.icnSelektiranje, new AnchorConstraint(5, 921, 245, 57, 1, 1, 1, 1));
            this.icnSelektiranje.setText("A\u017euriraj iznos|(F3)");
            this.icnSelektiranje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/document_header.png")));
            this.icnSelektiranje.setBackground(new Color(192, 192, 192));
            this.icnSelektiranje.setActionCommand("azurIznos");
            this.icnSelektiranje.addActionListener((ActionListener)((Object)this));
            this.icnSelektiranje.setShortcut("f3");
            this.icnSelektiranje.setPreferredSize(new Dimension(83, 117));
            this.icnAzurPdv = new PzToolBarIcon();
            this.pnlIcons1.add((Component)this.icnAzurPdv, new AnchorConstraint(257, 932, 491, 130, 1, 1, 1, 1));
            this.icnAzurPdv.setText("A\u017euriraj PDV|(F8)");
            this.icnAzurPdv.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/pdv_edit.png")));
            this.icnAzurPdv.setBackground(new Color(192, 192, 192));
            this.icnAzurPdv.setActionCommand("azurPDV");
            this.icnAzurPdv.addActionListener((ActionListener)((Object)this));
            this.icnAzurPdv.setShortcut("f8");
            this.icnAzurPdv.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/pdv_edit.png")));
            this.icnAzurPdv.setBackground(new Color(192, 192, 192));
            this.icnAzurPdv.setPreferredSize(new Dimension(77, 114));
            this.icnArhiva = new PzToolBarIcon();
            this.pnlIcons1.add((Component)this.icnArhiva, new AnchorConstraint(504, 1005, 768, 15, 1, 1, 1, 1));
            this.icnArhiva.setText("Arhiva i \u0161tampa|(CTRL+W)");
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/pdv_edit.png")));
            this.icnArhiva.setBackground(new Color(192, 192, 192));
            this.icnArhiva.setActionCommand("arhiva");
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setShortcut("CTRL+W");
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/money_envelope.png")));
            this.icnArhiva.setBackground(new Color(192, 192, 192));
            this.icnArhiva.setPreferredSize(new Dimension(95, 129));
            this.mainPanel.add((Component)this.splitPane, "Center");
            this.splitPane.setDividerLocation(100);
            this.compGroupZaglavlje = new PzComponentGroup();
            this.compGroupZaglavlje.add(this.pnlZaglavlje.getComponents());
            this.compGroupTable = new PzComponentGroup();
            this.compGroupTable.add(this.pnlTable.getComponents());
            this.compGroupTable.disableAll();
            this.iznos.setStateIndikator(this.indStornoIznos);
            this.setSize(800, 600);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogStornoNaknadneFakture(Boolean.FALSE);
    }

    public PzDialogStornoNaknadneFakture(Boolean initGUI) {
    }

    public void actionPerformed(ActionEvent e) {
        block7: {
            try {
                String actionCommand = ((PzButton)e.getSource()).getActionCommand();
                if (actionCommand.equals("azurIznos")) {
                    if (this.table.getSelectedEntity() == null) {
                        return;
                    }
                    this.getSession().putParameter("tableStorno", (Object)this.table);
                    this.showDialog(Selektiranje.class);
                    int i = this.table.getSelectedRow();
                    if (((PzManageableTableModel)this.table.getModel()).isRowChecked(i)) {
                        this.calculateVrednosti();
                    }
                    return;
                }
                if (actionCommand.equals("azurPDV")) {
                    this.getSession().putParameter("zapisnik", (Object)this.zapisnik);
                    this.showDialog(PzDialogPDV.class);
                    this.calculateVrednosti();
                    return;
                }
                if (!actionCommand.equalsIgnoreCase("arhiva")) break block7;
                this.arhiviraj();
                if (this.arhivaIndikator == 1) {
                    this.dispose();
                    break block7;
                }
                return;
            }
            catch (Exception e1) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
        }
    }

    protected void onInsert() {
    }

    protected void onUpdate() {
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            ((PzFieldImpl)component).setVal((Object)((Komitent)entity).getSfrKomitent());
        }
    }

    protected void setHeaderOnInsert() {
    }

    protected void setHeaderOnUpdate() {
    }

    private void setTableData(PzTable table) {
        this.setTableFilter(table);
    }

    private void setTableFilter(PzTable table) {
        table.setFilter(new PzEntityFilter(){

            public Object[] getValues(PzEntity entity) {
                PzDialogStornoNaknadneFakture.this.kz = (Kalkulacijazapisnik)entity;
                return new Object[]{PzDialogStornoNaknadneFakture.this.kz.getKalkulacija().getOznDokumenta(), PzDialogStornoNaknadneFakture.this.kz.getKalkulacija().getDatum(), PzDialogStornoNaknadneFakture.this.kz.getFakturisano(), PzDialogStornoNaknadneFakture.this.kz.getStornirano()};
            }

            public String[] getColumnNames() {
                return new String[]{"Otpremnica", "Datum dokumenta", "Iznos", "Storno za ?"};
            }
        });
    }

    private Kalkulacija createStornoZapisnik(Kalkulacija original) throws Exception {
        EntityManager em = PzEntityManager.getEm();
        Kalkulacija storno = null;
        storno = this.createStornoZapisnik(original, em);
        em.close();
        return storno;
    }

    private Kalkulacija createStornoZapisnik(Kalkulacija original, EntityManager em) throws Exception {
        Kalkulacija kopija = (Kalkulacija)em.find(Kalkulacija.class, (Object)original.getIdDok());
        Query q = em.createQuery("SELECT z FROM Kalkulacija z WHERE z.oznDokumenta = '" + (kopija = (Kalkulacija)BeanUtils.cloneBean((Object)kopija)).getOznDokumenta() + "' AND z.arhiviran = 1 AND " + "z.komitent.sfrKomitent = '" + kopija.getKomitent().getSfrKomitent() + "' AND z.storno = 1 AND " + "z.tip='" + TipDokumentConfig.get().ZAPISNIK_OTPREMNICE + "'");
        Vector stornoDokumenti = (Vector)q.getResultList();
        if (stornoDokumenti != null && stornoDokumenti.size() > 0) {
            for (Kalkulacija z : stornoDokumenti) {
                Iterator tod = z.getTaksakalkulacijas().iterator();
                while (tod.hasNext()) {
                    this.umanjiPorez(kopija, (Taksakalkulacija)tod.next());
                }
            }
            for (Kalkulacija z : stornoDokumenti) {
                Iterator kz = z.getKalkulacijazapisniks2().iterator();
                while (kz.hasNext()) {
                    this.umanjiKalkulacijaZapisnik(kopija, (Kalkulacijazapisnik)kz.next());
                }
            }
        }
        if (kopija.getStornoIznos().compareTo(kopija.getIznos()) != 0) {
            kopija.setStorno(1);
            return kopija;
        }
        throw new PzDokumentException(PzDokumentException.EXCEPTION_STORNIRAN, "Dokument je ve\u0107 u potpunosti storniran. Dalji rad nemogu\u0107.");
    }

    private void umanjiKalkulacijaZapisnik(Kalkulacija original, Kalkulacijazapisnik next) {
        for (Kalkulacijazapisnik kalkZap : original.getKalkulacijazapisniks2()) {
            if (!kalkZap.getId().getZapisnik().equals(next.getId().getZapisnik())) continue;
            if (kalkZap.getFakturisano().subtract(next.getStornirano()).doubleValue() == 0.0) {
                original.getKalkulacijazapisniks2().remove(kalkZap);
                break;
            }
            kalkZap.setFakturisano(kalkZap.getFakturisano().subtract(next.getStornirano()));
        }
    }

    private void umanjiPorez(Kalkulacija original, Taksakalkulacija next) {
        for (Taksakalkulacija takOpDok : original.getTaksakalkulacijas()) {
            if (!takOpDok.getTarifnagrupa().equals(next.getTarifnagrupa())) continue;
            if (takOpDok.getIznos().subtract(next.getIznos()).equals(new BigDecimal(0))) {
                original.getTaksakalkulacijas().remove(takOpDok);
                break;
            }
            takOpDok.setOsnovica(takOpDok.getOsnovica().subtract(next.getOsnovica()));
            takOpDok.setIznos(takOpDok.getIznos().subtract(next.getIznos()));
        }
    }

    public void calculatePDV() {
        BigDecimal pdvSum = new BigDecimal(0.0);
        if (this.zapisnik.getTaksakalkulacijas() != null) {
            for (Taksakalkulacija pdv : this.zapisnik.getTaksakalkulacijas()) {
                pdvSum = pdvSum.add(pdv.getIznos());
            }
        }
        this.txtStornoPDv.setVal((Object)pdvSum);
    }

    private void calculateVrednosti() {
        List kz = this.table.getCheckedEntities();
        BigDecimal ostatak = new BigDecimal(0.0);
        BigDecimal kalzapUpdate = new BigDecimal(0.0);
        if (kz != null) {
            for (PzEntity kalZap : kz) {
                kalzapUpdate = kalzapUpdate.add(((Kalkulacijazapisnik)kalZap).getStornirano());
            }
        }
        ostatak = this.iznos.getBigDecimal().subtract(this.txtStornoPDv.getBigDecimal()).subtract(kalzapUpdate);
        this.txtStorno.setVal((Object)kalzapUpdate);
        this.txtNepokriveno.setVal((Object)ostatak);
    }

    private void arhiviraj() throws Exception {
        if (this.txtNepokriveno.getVal() != 0.0) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)("Iznos storno fakture ne pokriva iznose otpremnica i PDV-a za " + this.txtNepokriveno.getVal() + "."));
            this.arhivaIndikator = 0;
            return;
        }
        this.table.getCheckedEntities();
        List tod = this.zapisnik.getTaksakalkulacijas();
        Kalkulacija zapisnikU = new Kalkulacija();
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                this.zapisnik.setKalkulacijazapisniks2(this.table.getCheckedEntities());
                this.zapisnik.setDatum(this.datIzrade.getVal());
                this.zapisnik.setIznos(this.iznos.getBigDecimal());
                this.zapisnik.setDatFakture(this.zapisnik.getDatFakture());
                this.zapisnik.setDatDPO(this.zapisnik.getDatDPO());
                this.zapisnik.setDatValute(this.zapisnik.getDatValute());
                this.zapisnik.setPoruka("");
                em.getTransaction().begin();
                Kalkulacija original = (Kalkulacija)em.find(Kalkulacija.class, (Object)this.zapisnik.getIdDok());
                if (original == null) {
                    throw new PzDokumentException(PzDokumentException.EXCEPTION_NEMA_ORIGINALA, "Storno dokument ne sadrzi referencu ka originalnom dokumentu koga stornira. Pri pozivu metoda arhivirajStorno() polje idDok mora sadrzati ID dokumenta koji se stornira!");
                }
                original.setStornoIznos(original.getStornoIznos().add(this.zapisnik.getIznos()));
                String className = zapisnikU.getClass().getSimpleName();
                Id_gen dokId = (Id_gen)em.find(Id_gen.class, (Object)"DOKUMENT_ID");
                if (dokId == null) {
                    dokId = new Id_gen();
                    dokId.setIdName(className);
                    dokId.setIdVal(0);
                }
                dokId.setIdVal(dokId.getIdVal() + 1);
                em.merge((Object)dokId);
                this.zapisnik.setStornoIznos(new BigDecimal(0.0));
                this.zapisnik.setIdDok(dokId.getIdVal());
                for (Kalkulacijazapisnik updatekz : this.zapisnik.getKalkulacijazapisniks2()) {
                    updatekz.getId().setZapisnik(Integer.valueOf(this.zapisnik.getIdDok()));
                    Kalkulacija kalk = (Kalkulacija)em.find(Kalkulacija.class, (Object)updatekz.getKalkulacija().getId());
                    kalk.setUkupnoFakturisano(kalk.getUkupnoFakturisano().subtract(updatekz.getStornirano()));
                }
                Iterator todIterator = tod.iterator();
                while (todIterator.hasNext()) {
                    ((Taksakalkulacija)todIterator.next()).getId().setIdDok(this.zapisnik.getIdDok());
                }
                this.zapisnik.setArhiviran((short)1);
                this.zapisnik.setStorno(1);
                this.zapisnik.setTaksakalkulacijas(tod);
                this.zapisnik.setOriginal(original);
                Dokument dok = new Dokument((PzDokument)this.zapisnik, true);
                this.zapisnik.setDokument(dok);
                em.persist((Object)this.zapisnik);
                em.getTransaction().commit();
                PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.zapisnik);
                this.arhivaIndikator = 1;
            }
            catch (PzDokumentException e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                throw e;
            }
        }
        finally {
            if (em != null) {
                em.clear();
            }
            em.close();
        }
    }
}

