/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.gui;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jdesktop.application.Application;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Kalkulacijazapisnik;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Taksakalkulacija;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.nabavka.gui.PzDialogKalkulacija;
import rs.pezar.nabavka.gui.unosNaknadneFakture.Dodavanje;
import rs.pezar.nabavka.gui.unosNaknadneFakture.PzDialogPDV;
import rs.pezar.reports.PzReportManager;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzButtonPanel;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.event.PzButtonPanelSelectionListener;
import rs.pezar.swing.event.PzTablePropertyListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldImpl;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;
import rs.pezar.util.PzUlazniRacunKategorijaUtil;

public class PzDialogUnosNaknadneFakture
extends PzDialogInsert {
    private static final long serialVersionUID = 1L;
    private PzPanelHeader header;
    private JPanel mainPanel;
    private PzPanel pnlZaglavlje;
    private JLabel lblInoKomitent;
    private JLabel lblNijeObveznikPDV;
    private PzPanel panel;
    private PzFieldIndikator indBrutoIznos;
    private PzDoubleField txtOstatak;
    private PzDoubleField txtIznosPdv;
    private PzPanel pnlSum;
    private PzTextField txtNazivDobavljaca;
    private PzPanel pnlRight;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel8;
    private PzTextField brDokumenta;
    private PzDateField datValute;
    private PzNumericOnlyTextField valuta;
    private JLabel jLabel6;
    private PzDateField datDPO;
    private PzDoubleField iznos;
    private PzRadioGroup<PzUlazniRacunKategorijaUtil.UlazniRacunKategorija> rgrKategorija;
    private PzNumericOnlyTextField sfrKomitent;
    private PzToolBarIcon icnBrisanje;
    private PzToolBarIcon icnIzmena;
    private PzToolBarIcon icnDodavanje;
    private PzFieldIndikator indSifraDobavljaca;
    private PzToolBarIcon icnArhiva;
    private JPanel pnlIcons2;
    private PzToolBarIcon icnAzurPdv;
    private PzToolBarIcon icnAzurZaglavlja;
    private PzFieldIndikator indBrojFakture;
    private JPanel pnlIcons1;
    private JScrollPane scpIcons;
    private PzTable tableUnosNakFakt;
    private JScrollPane scpArtikli;
    private PzButton btnZaglavlje;
    private JSplitPane splitPane;
    private PzPanel jPanel1;
    private JRadioButton pdvVrsta3;
    private JRadioButton pdvVrsta2;
    private JRadioButton pdvVrsta1;
    private PzButtonPanel pnlPDV;
    private JLabel jLabel12;
    private JLabel jLabel19;
    private JLabel jLabel10;
    private PzDateField datDokumenta;
    private PzDateField datIzrade;
    private JLabel jLabel1;
    private PzComponentGroup compGroupZaglavlje;
    private PzComponentGroup compGroupTable;
    private ButtonGroup pdv;
    private Komitent komitent;
    private PzComponentGroup compGroupPDV;
    private Kalkulacija zapisnik;
    private Radnajedinica rj;
    private PzTable tableZap;
    private Boolean izmena;
    private Kalkulacijazapisnik kz;

    public PzDialogUnosNaknadneFakture(JFrame frame) {
        super(frame);
        this.zapisnik = new Kalkulacija();
    }

    public PzDialogUnosNaknadneFakture(PzDialog dialog) {
        super(dialog);
        this.initGUI();
        if (this.izmena.booleanValue()) {
            this.fillDokument((PzEntity)this.zapisnik);
            this.komitent = this.zapisnik.getKomitent();
            if (this.komitent.getDomaciKomitent() == 0) {
                this.lblInoKomitent.setVisible(true);
                this.compGroupPDV.hideAll();
            } else if (this.komitent.getObveznikPDV() == 0) {
                this.lblNijeObveznikPDV.setVisible(true);
                this.compGroupPDV.hideAll();
            } else if (!this.zapisnik.getPdv().equalsIgnoreCase("SA_PRAVOM")) {
                this.compGroupPDV.hideAll();
                this.compGroupTable.enableAll();
            }
            this.compGroupZaglavlje.disableAll();
            this.txtNazivDobavljaca.setText(this.zapisnik.getKomitent().getNaziv());
            this.icnAzurPdv.setEnabled(true);
            this.icnAzurZaglavlja.setEnabled(true);
            this.icnArhiva.setEnabled(true);
            this.brDokumenta.setEditable(false);
            this.brDokumenta.setFocusable(false);
            this.calculateOstatak(this.zapisnik);
        } else {
            this.icnAzurPdv.setEnabled(false);
        }
        this.calculateOstatak(this.zapisnik);
        this.setFirstComponentInFocus((Component)this.datIzrade);
    }

    private void init() {
        this.tableZap = (PzTable)this.getSession().getParameter("tableZap");
        this.izmena = (Boolean)this.getSession().getParameter("update");
        this.zapisnik = this.izmena != false ? (Kalkulacija)this.tableZap.getSelectedEntity() : new Kalkulacija();
    }

    private void fillDokument(PzEntity entity) {
        Kalkulacija dokument = (Kalkulacija)entity;
        this.datIzrade.setVal((Object)dokument.getDatum());
        this.brDokumenta.setVal((Object)dokument.getOznDokumenta());
        this.datValute.setVal((Object)dokument.getDatValute());
        this.datDPO.setVal((Object)dokument.getDatDPO());
        this.iznos.setVal((Object)dokument.getIznos());
        this.sfrKomitent.setVal((Object)dokument.getKomitent().getSfrKomitent());
        this.datDokumenta.setVal((Object)dokument.getDatum());
        PzSwingUtility.setSelectedValue((String)dokument.getPdv(), (ButtonGroup)this.pdv);
        this.compGroupZaglavlje.disableAll();
        if (this.zapisnik.getTaksakalkulacijas() == null) {
            this.compGroupTable.disableAll();
        } else {
            this.compGroupTable.enableAll();
        }
        this.tableUnosNakFakt.setData(this.zapisnik.getKalkulacijazapisniks2(), Kalkulacijazapisnik.class);
        this.tableUnosNakFakt.getTableHeader().setFocusable(false);
        dokument.getKomitent().getSfrKomitent();
        this.pnlZaglavlje.updateAllFieldsState();
        this.rgrKategorija.setSelectedValue((Object)PzUlazniRacunKategorijaUtil.getKategorija((String)dokument.getKategorija()));
    }

    protected void initGUI() {
        try {
            this.init();
            this.setTitle("Registrovanje naknadne fakture");
            this.mainPanel = new JPanel();
            BorderLayout mainPanelLayout = new BorderLayout();
            this.mainPanel.setLayout(mainPanelLayout);
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.header = new PzPanelHeader();
            this.header.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/document_kalkulacija.png")));
            this.header.setTitle("Registrovanje naknadne fakture");
            this.mainPanel.add((Component)this.header, "North");
            this.compGroupPDV = new PzComponentGroup();
            this.pnlRight = new PzPanel();
            AnchorLayout an = new AnchorLayout();
            this.pnlRight.setLayout((LayoutManager)an);
            this.pnlZaglavlje = new PzPanel();
            this.pnlRight.add((Component)this.pnlZaglavlje, (Object)new AnchorConstraint(-2, 1000, 286, 0, 2, 1, 0, 2));
            GridBagLayout pnlZaglavljeLayout = new GridBagLayout();
            this.pnlZaglavlje.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Zaglavlje", 4, 0));
            pnlZaglavljeLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            pnlZaglavljeLayout.rowHeights = new int[]{23, 23, 23, 23, 22, 11};
            pnlZaglavljeLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0};
            pnlZaglavljeLayout.columnWidths = new int[]{98, 86, 20, 95, 80, 44, 161, 126};
            this.pnlZaglavlje.setLayout((LayoutManager)pnlZaglavljeLayout);
            this.pnlZaglavlje.setTransferFocusOnEnter(true);
            this.pnlZaglavlje.setPreferredSize(new Dimension(872, 175));
            this.jPanel1 = new PzPanel();
            this.pnlZaglavlje.add((Component)this.jPanel1, (Object)new GridBagConstraints(6, 0, 1, 6, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel1.setLayout(null);
            this.pnlPDV = new PzButtonPanel();
            this.pnlPDV.setSelectionListener(this.getSelectionListener());
            this.jPanel1.add((Component)this.pnlPDV);
            GridBagLayout pnlPDVLayout = new GridBagLayout();
            pnlPDVLayout.rowWeights = new double[]{0.1, 0.1, 0.1};
            pnlPDVLayout.rowHeights = new int[]{7, 7, 7};
            pnlPDVLayout.columnWeights = new double[]{0.1};
            pnlPDVLayout.columnWidths = new int[]{7};
            this.pnlPDV.setLayout((LayoutManager)pnlPDVLayout);
            this.pnlPDV.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "PDV", 4, 0));
            this.pnlPDV.setBounds(1, 0, 160, 84);
            this.pdv = new ButtonGroup();
            this.pdvVrsta1 = new JRadioButton();
            this.pnlPDV.add((Component)this.pdvVrsta1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.pdvVrsta1.setText("Sa pravom na odbitak");
            this.pdvVrsta1.setSelected(true);
            this.pdvVrsta1.setActionCommand("SA_PRAVOM");
            this.pdv.add(this.pdvVrsta1);
            this.pdvVrsta2 = new JRadioButton();
            this.pdvVrsta2.setText("Bez prava na odbitak");
            this.pdvVrsta2.setActionCommand("BEZ_PRAVA");
            this.pdv.add(this.pdvVrsta2);
            this.pdvVrsta3 = new JRadioButton();
            this.pnlPDV.add((Component)this.pdvVrsta3, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.pdvVrsta3.setText("Oslobo\u0111eno PDV-a");
            this.pdvVrsta3.setActionCommand("OSLOBODJENO");
            this.pdv.add(this.pdvVrsta3);
            this.btnZaglavlje = new PzButton();
            this.jPanel1.add((Component)this.btnZaglavlje);
            this.btnZaglavlje.setText("Snimi zaglavlje");
            this.btnZaglavlje.setBounds(6, 90, 149, 30);
            this.btnZaglavlje.setActionCommand("snimi_zaglavlje");
            this.btnZaglavlje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/check.png")));
            this.btnZaglavlje.addActionListener((ActionListener)((Object)this));
            this.lblNijeObveznikPDV = new JLabel();
            this.jPanel1.add((Component)this.lblNijeObveznikPDV);
            this.lblNijeObveznikPDV.setBounds(0, 27, 175, 22);
            this.lblNijeObveznikPDV.setName("lblNijeObveznikPDV");
            this.lblNijeObveznikPDV.setVisible(false);
            this.lblInoKomitent = new JLabel();
            this.jPanel1.add((Component)this.lblInoKomitent);
            this.lblInoKomitent.setBounds(0, 26, 161, 23);
            this.lblInoKomitent.setName("lblInoKomitent");
            this.lblInoKomitent.setVisible(false);
            this.panel = new PzPanel();
            GridBagLayout panelLayout = new GridBagLayout();
            panelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
            panelLayout.rowHeights = new int[]{7, 7, 7, 7, 7};
            panelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.1};
            panelLayout.columnWidths = new int[]{7, 7, 7, 7, 7, 7};
            this.panel.setLayout((LayoutManager)panelLayout);
            this.pnlZaglavlje.add((Component)this.panel, (Object)new GridBagConstraints(0, 0, 6, 6, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.datDokumenta = new PzDateField();
            this.panel.add((Component)this.datDokumenta, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.datDokumenta.setFont(new Font("Tahoma", 0, 14));
            this.datDPO = new PzDateField();
            this.panel.add((Component)this.datDPO, (Object)new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.datDPO.setFont(new Font("Tahoma", 0, 14));
            this.valuta = new PzNumericOnlyTextField();
            this.panel.add((Component)this.valuta, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.valuta.setFont(new Font("Tahoma", 0, 14));
            this.valuta.setText("0");
            this.valuta.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    PzDialogUnosNaknadneFakture.this.keyRel(evt);
                }
            });
            this.datValute = new PzDateField();
            this.panel.add((Component)this.datValute, (Object)new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.datValute.setFont(new Font("Tahoma", 0, 14));
            this.datValute.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    PzDialogUnosNaknadneFakture.this.keyRel(evt);
                }
            });
            this.indBrutoIznos = new PzFieldIndikator();
            this.panel.add((Component)this.indBrutoIznos, (Object)new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.txtNazivDobavljaca = new PzTextField();
            this.panel.add((Component)this.txtNazivDobavljaca, (Object)new GridBagConstraints(3, 1, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtNazivDobavljaca.setEditable(false);
            this.txtNazivDobavljaca.setFocusable(false);
            this.indBrojFakture = new PzFieldIndikator();
            this.panel.add((Component)this.indBrojFakture, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indSifraDobavljaca = new PzFieldIndikator();
            this.panel.add((Component)this.indSifraDobavljaca, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.jLabel5 = new JLabel();
            this.panel.add((Component)this.jLabel5, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel5.setText("Datum prometa");
            this.brDokumenta = new PzTextField(){

                public boolean entityExists() {
                    String query = "SELECT k FROM Kalkulacija k WHERE k.arhiviran<>-1 and k.oznDokumenta = :brdok AND k.komitent = :komitent AND ((k.tip=:tipKalk AND k.podTip IN ('" + TipDokumentConfig.get().PODTIP_KALKULACIJA_FAKTURA + "', 'POCETNO')) OR k.tip ='" + TipDokumentConfig.get().ZAPISNIK_OTPREMNICE + "'" + " OR k.tip = '" + TipDokumentConfig.get().TROSAK + "' OR k.tip = '" + TipDokumentConfig.get().RACUN_DOBAVLJACA + "')";
                    EntityManager em = PzEntityManager.getEm();
                    Query q = em.createQuery(query).setParameter("brdok", (Object)PzDialogUnosNaknadneFakture.this.brDokumenta.getVal()).setParameter("komitent", (Object)PzDialogUnosNaknadneFakture.this.komitent).setParameter("tipKalk", (Object)TipDokumentConfig.get().KALKULACIJA);
                    return q.getResultList().size() > 0;
                }
            };
            this.brDokumenta.setMsgEntityExists("Faktura sa izabranim brojem ve\u0107 postoji u bazi. Molim izaberite drugi broj fakture.");
            this.brDokumenta.setMsgEmptyField("Polje sa brojem fakture ne mo\u017ee ostati prazno.");
            this.panel.add((Component)this.brDokumenta, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.brDokumenta.setFont(new Font("Tahoma", 0, 14));
            this.brDokumenta.setPKField(Kalkulacija.class, null);
            this.jLabel8 = new JLabel();
            this.panel.add((Component)this.jLabel8, (Object)new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel8.setText("Datum valute");
            this.jLabel4 = new JLabel();
            this.panel.add((Component)this.jLabel4, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel4.setText("Bruto iznos");
            this.sfrKomitent = new PzNumericOnlyTextField();
            this.panel.add((Component)this.sfrKomitent, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.sfrKomitent.setFont(new Font("Tahoma", 0, 14));
            this.sfrKomitent.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.iznos = new PzDoubleField();
            this.panel.add((Component)this.iznos, (Object)new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.iznos.setFont(new Font("Tahoma", 0, 14));
            this.iznos.setVerifyInput(true);
            this.datIzrade = new PzDateField();
            this.panel.add((Component)this.datIzrade, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.datIzrade.setFont(new Font("Tahoma", 0, 14));
            this.jLabel6 = new JLabel();
            this.panel.add((Component)this.jLabel6, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel6.setText("Val");
            this.jLabel3 = new JLabel();
            this.panel.add((Component)this.jLabel3, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel3.setText("Datum fakture");
            this.jLabel12 = new JLabel();
            this.panel.add((Component)this.jLabel12, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel12.setText("Broj fakture");
            this.jLabel2 = new JLabel();
            this.panel.add((Component)this.jLabel2, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel2.setText("\u0160ifra dobavlja\u010da");
            this.jLabel1 = new JLabel();
            this.panel.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel1.setText("Datum izrade");
            this.rgrKategorija = PzUlazniRacunKategorijaUtil.getKategorijeKalkulacija();
            this.pnlZaglavlje.add(this.rgrKategorija, (Object)new GridBagConstraints(7, 0, 1, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.scpArtikli = new JScrollPane();
            this.pnlRight.add((Component)this.scpArtikli, (Object)new AnchorConstraint(243, 1000, 83, 0, 2, 1, 2, 2));
            this.scpArtikli.setPreferredSize(new Dimension(872, 319));
            this.tableUnosNakFakt = new PzTable(this.zapisnik.getKalkulacijazapisniks2(), Kalkulacijazapisnik.class);
            this.scpArtikli.setViewportView((Component)this.tableUnosNakFakt);
            this.tableUnosNakFakt.setPropertyListener(new PzTablePropertyListener(){

                public void entityRemoved(PzEntity entity) {
                    PzDialogUnosNaknadneFakture.this.calculateOstatak(PzDialogUnosNaknadneFakture.this.zapisnik);
                }

                public void entityAdded(PzEntity entity) {
                    PzDialogUnosNaknadneFakture.this.calculateOstatak(PzDialogUnosNaknadneFakture.this.zapisnik);
                }
            });
            this.pnlIcons2 = new JPanel();
            this.pnlRight.add((Component)this.pnlIcons2, (Object)new AnchorConstraint(847, 1000, 0, 0, 0, 1, 2, 2));
            FlowLayout pnlIcons2Layout = new FlowLayout();
            pnlIcons2Layout.setAlignment(0);
            pnlIcons2Layout.setHgap(10);
            this.pnlIcons2.setLayout(pnlIcons2Layout);
            this.pnlIcons2.setOpaque(false);
            this.pnlIcons2.setPreferredSize(new Dimension(676, 83));
            this.icnDodavanje = new PzToolBarIcon();
            this.pnlIcons2.add((Component)this.icnDodavanje);
            this.icnDodavanje.setText("Dodavanje|(Insert)");
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/product_add_small.png")));
            this.icnDodavanje.setBackground(new Color(192, 192, 192));
            this.icnDodavanje.setActionCommand("Dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("insert");
            this.icnIzmena = new PzToolBarIcon();
            this.pnlIcons2.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/product_edit_small.png")));
            this.icnIzmena.setBackground(new Color(192, 192, 192));
            this.icnIzmena.setActionCommand("Izmena");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("F3");
            this.icnBrisanje = new PzToolBarIcon();
            this.pnlIcons2.add((Component)this.icnBrisanje);
            this.icnBrisanje.setText("Brisanje|(Delete)");
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/product_delete_small.png")));
            this.icnBrisanje.setBackground(new Color(192, 192, 192));
            this.icnBrisanje.setActionCommand("brisanje");
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setShortcut("delete");
            this.pnlSum = new PzPanel();
            GridBagLayout pnlSumLayout = new GridBagLayout();
            this.pnlRight.add((Component)this.pnlSum, (Object)new AnchorConstraint(179, 1000, 404, 0, 2, 1, 0, 2));
            pnlSumLayout.rowWeights = new double[]{0.0};
            pnlSumLayout.rowHeights = new int[]{30};
            pnlSumLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            pnlSumLayout.columnWidths = new int[]{134, 142, 145, 143};
            this.pnlSum.setLayout((LayoutManager)pnlSumLayout);
            this.pnlSum.setPreferredSize(new Dimension(872, 61));
            this.pnlSum.setOpaque(false);
            this.pnlSum.setFocusable(false);
            this.pnlSum.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Sumarne vrednosti", 4, 0));
            this.jLabel10 = new JLabel();
            this.compGroupPDV.add((Component)this.jLabel10);
            this.pnlSum.add((Component)this.jLabel10, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel10.setText("Iznos PDV-a");
            this.jLabel10.setFocusable(false);
            this.jLabel19 = new JLabel();
            this.pnlSum.add((Component)this.jLabel19, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel19.setText("Ostatak");
            this.jLabel19.setFocusable(false);
            this.txtIznosPdv = new PzDoubleField();
            this.compGroupPDV.add((Component)this.txtIznosPdv);
            this.pnlSum.add((Component)this.txtIznosPdv, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtIznosPdv.setEditable(false);
            this.txtIznosPdv.setFocusable(false);
            this.txtOstatak = new PzDoubleField();
            this.pnlSum.add((Component)this.txtOstatak, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtOstatak.setEditable(false);
            this.txtOstatak.setFocusable(false);
            this.scpIcons = new JScrollPane();
            this.splitPane = new JSplitPane();
            this.splitPane.getInputMap(1).put(KeyStroke.getKeyStroke(119, 0, false), "ENTER");
            this.splitPane.add((Component)this.pnlRight, "right");
            this.splitPane.add((Component)this.scpIcons, "left");
            this.scpIcons.setPreferredSize(new Dimension(70, 492));
            this.scpIcons.setSize(70, 492);
            this.pnlIcons1 = new JPanel();
            this.scpIcons.setViewportView(this.pnlIcons1);
            this.pnlIcons1.setBackground(new Color(192, 192, 192));
            this.pnlIcons1.setPreferredSize(new Dimension(70, 780));
            this.icnAzurZaglavlja = new PzToolBarIcon();
            this.pnlIcons1.add((Component)this.icnAzurZaglavlja);
            this.icnAzurZaglavlja.setText("Izmena|zaglavlja|(F4)");
            this.icnAzurZaglavlja.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/document_header.png")));
            this.icnAzurZaglavlja.setBackground(new Color(192, 192, 192));
            this.icnAzurZaglavlja.setActionCommand("azuriraj_zaglavlje");
            this.icnAzurZaglavlja.addActionListener((ActionListener)((Object)this));
            this.icnAzurZaglavlja.setShortcut("f4");
            this.icnAzurZaglavlja.setEnabled(false);
            this.icnAzurPdv = new PzToolBarIcon();
            this.compGroupPDV.add((Component)this.icnAzurPdv);
            this.pnlIcons1.add((Component)this.icnAzurPdv);
            this.icnAzurPdv.setText("PDV|(F8)");
            this.icnAzurPdv.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/pdv_edit.png")));
            this.icnAzurPdv.setBackground(new Color(192, 192, 192));
            this.icnAzurPdv.setActionCommand("azurPDV");
            this.icnAzurPdv.addActionListener((ActionListener)((Object)this));
            this.icnAzurPdv.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/pdv_edit.png")));
            this.icnAzurPdv.setBackground(new Color(192, 192, 192));
            this.icnAzurPdv.setShortcut("F8");
            this.icnAzurPdv.setEnabled(false);
            this.icnArhiva = new PzToolBarIcon();
            this.pnlIcons1.add((Component)this.icnArhiva);
            this.icnArhiva.setText("Arhiva|(CTRL+W)");
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/printer_preferences.png")));
            this.icnArhiva.setBackground(new Color(192, 192, 192));
            this.icnArhiva.setActionCommand("arhiva");
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setShortcut("ctrl+w");
            this.icnArhiva.setName("icnArhiva");
            this.icnArhiva.setEnabled(false);
            this.mainPanel.add((Component)this.splitPane, "Center");
            this.splitPane.setDividerLocation(100);
            this.compGroupZaglavlje = new PzComponentGroup();
            this.compGroupZaglavlje.add(this.pnlZaglavlje.getComponents());
            this.compGroupTable = new PzComponentGroup();
            this.compGroupTable.add(this.scpArtikli.getComponents());
            this.compGroupTable.add(this.pnlIcons2.getComponents());
            this.compGroupTable.disableAll();
            this.sfrKomitent.setStateIndikator(this.indSifraDobavljaca);
            this.brDokumenta.setStateIndikator(this.indBrojFakture);
            this.iznos.setStateIndikator(this.indBrutoIznos);
            this.setSize(996, 739);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogKalkulacija(Boolean.FALSE);
    }

    public PzDialogUnosNaknadneFakture(Boolean initGUI) {
    }

    public String getPdvChoice() {
        return PzSwingUtility.getSelectedValue((ButtonGroup)this.pdv);
    }

    public void actionPerformed(ActionEvent e) {
        block21: {
            try {
                block23: {
                    boolean izmenaLocal = false;
                    String actionCommand = ((PzButton)e.getSource()).getActionCommand();
                    if (actionCommand.equals("brisanje")) {
                        if (this.tableUnosNakFakt.getSelectedEntity() == null) {
                            return;
                        }
                        Kalkulacijazapisnik kz = (Kalkulacijazapisnik)this.tableUnosNakFakt.getSelectedEntity();
                        boolean removed = this.tableUnosNakFakt.removeSelectedEntity(true, false);
                        if (removed) {
                            this.zapisnik.removeKalkulacija(kz);
                            this.calculateOstatak(this.zapisnik);
                        }
                        return;
                    }
                    if (actionCommand.equals("snimi_zaglavlje")) {
                        if (this.sfrKomitent.getVal().equals("") || this.brDokumenta.getVal().equals("") || this.iznos.getVal().equals(0.0)) {
                            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Ne mo\u017eete snimiti zaglavlje dok ne unesete obavezna polja.");
                            return;
                        }
                        this.saveDokument();
                        this.icnAzurZaglavlja.setEnabled(true);
                        this.icnArhiva.setEnabled(true);
                        this.compGroupZaglavlje.disableAll();
                        this.compGroupTable.enableAll();
                        if (this.komitent.getDomaciKomitent() == 1 && this.komitent.getObveznikPDV() == 1 && this.getPdvChoice().equals("SA_PRAVOM")) {
                            this.icnAzurPdv.setEnabled(true);
                            this.compGroupPDV.showAll();
                        } else {
                            this.icnAzurPdv.setEnabled(false);
                            this.compGroupPDV.hideAll();
                        }
                        return;
                    }
                    if (actionCommand.equals("azuriraj_zaglavlje")) {
                        this.compGroupZaglavlje.enableAll();
                        this.compGroupTable.disableAll();
                        this.compGroupPDV.disableAll();
                        this.datIzrade.requestFocus();
                        this.icnAzurZaglavlja.setEnabled(false);
                        this.icnArhiva.setEnabled(false);
                        this.sfrKomitent.setEnabled(false);
                        this.izmena = true;
                        return;
                    }
                    if (actionCommand.equals("Izmena")) {
                        if (this.tableUnosNakFakt.getSelectedEntity() == null) {
                            return;
                        }
                        izmenaLocal = true;
                        this.getSession().putParameter("update", (Object)izmenaLocal);
                        this.getSession().putParameter("zapisnik", (Object)this.zapisnik);
                        this.getSession().putParameter("komitent", this.sfrKomitent.getValue());
                        this.getSession().putParameter("table", (Object)this.tableUnosNakFakt);
                        this.showDialog(Dodavanje.class);
                        this.calculateOstatak(this.zapisnik);
                        return;
                    }
                    if (actionCommand.equals("azurPDV")) {
                        actionCommand = "PzDialogPDV";
                        this.getSession().putParameter("zapisnik", (Object)this.zapisnik);
                        this.showDialog(PzDialogPDV.class);
                        this.calculateOstatak(this.zapisnik);
                        return;
                    }
                    if (actionCommand.equalsIgnoreCase("Dodavanje")) {
                        this.getSession().putParameter("update", (Object)izmenaLocal);
                        this.getSession().putParameter("zapisnik", (Object)this.zapisnik);
                        this.getSession().putParameter("komitent", this.sfrKomitent.getValue());
                        this.getSession().putParameter("table", (Object)this.tableUnosNakFakt);
                        this.getSession().putParameter("dialogUnosNakFakt", (Object)this);
                        this.showDialog(Dodavanje.class);
                        this.calculateOstatak(this.zapisnik);
                        return;
                    }
                    if (!actionCommand.equalsIgnoreCase("arhiva")) break block21;
                    if (this.getOstatak().compareTo(new BigDecimal(0)) == -1 || this.getOstatak().compareTo(new BigDecimal(0)) == 1) {
                        PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Ostatak mora biti jednak nuli.");
                        return;
                    }
                    if (!(this.zapisnik.getTaksakalkulacijas() != null && this.zapisnik.getTaksakalkulacijas().size() != 0 || this.komitent.getDomaciKomitent() == 0 || this.komitent.getObveznikPDV() == 0 || this.pdvVrsta2.isSelected() || this.pdvVrsta3.isSelected())) {
                        PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Morate uneti PDV.");
                        return;
                    }
                    this.zapisnik.setIznos(this.iznos.getBigDecimal());
                    this.zapisnik.setArhiviran((short)1);
                    EntityManager em = PzEntityManager.getEm();
                    try {
                        try {
                            em.getTransaction().begin();
                            PzEntityManager.update((Object)this.zapisnik, (EntityManager)em);
                            PzDokumentManager.getInstance().arhivirajDokument((PzDokument)this.zapisnik, false, null, em);
                            em.getTransaction().commit();
                        }
                        catch (Exception e1) {
                            if (em.getTransaction().isActive()) {
                                em.getTransaction().rollback();
                            }
                            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                            em.close();
                            break block23;
                        }
                    }
                    catch (Throwable throwable) {
                        em.close();
                        throw throwable;
                    }
                    em.close();
                }
                PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.zapisnik);
                this.tableZap.removeSelectedEntity(false, false);
                this.dispose();
            }
            catch (Exception e1) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
        }
    }

    protected void onInsert() {
    }

    protected void onUpdate() {
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            ((PzFieldImpl)component).setVal((Object)((Komitent)entity).getSfrKomitent());
            this.txtNazivDobavljaca.setText(((Komitent)entity).getNaziv());
            this.komitent = (Komitent)entity;
            if (this.komitent.getDomaciKomitent() != 1 || this.komitent.getObveznikPDV() == 0) {
                this.pnlPDV.setVisible(false);
                this.compGroupPDV.hideAll();
                if (this.komitent.getDomaciKomitent() == 0) {
                    this.lblInoKomitent.setVisible(true);
                    this.lblNijeObveznikPDV.setVisible(false);
                } else if (this.komitent.getObveznikPDV() == 0) {
                    this.lblNijeObveznikPDV.setVisible(true);
                    this.lblInoKomitent.setVisible(false);
                }
            } else {
                this.lblInoKomitent.setVisible(false);
                this.lblNijeObveznikPDV.setVisible(false);
                this.pnlPDV.setVisible(true);
                this.compGroupPDV.showAll();
            }
        }
    }

    protected void setHeaderOnInsert() {
    }

    protected void setHeaderOnUpdate() {
    }

    public PzComponentGroup getTableGroup() {
        return this.compGroupTable;
    }

    public void calculatePDV() {
        BigDecimal pdvSum = new BigDecimal(0.0);
        if (this.zapisnik.getTaksakalkulacijas() != null) {
            for (Taksakalkulacija pdv : this.zapisnik.getTaksakalkulacijas()) {
                pdvSum = pdvSum.add(pdv.getIznos());
            }
        }
        this.txtIznosPdv.setVal((Object)pdvSum);
    }

    private void saveDokument() throws Exception {
        if (this.zapisnik == null) {
            this.zapisnik = new Kalkulacija();
        }
        this.calculateOstatak(this.zapisnik);
        this.zapisnik.setOznDokumenta(this.brDokumenta.getVal());
        this.zapisnik.setDatum(this.datIzrade.getVal());
        this.zapisnik.setDatFakture(this.datDokumenta.getVal());
        this.zapisnik.setDatDPO(this.datDPO.getVal());
        this.zapisnik.setDatValute(this.datValute.getVal());
        this.zapisnik.setIznos(this.iznos.getBigDecimal());
        this.zapisnik.setArhiviran((short)0);
        this.zapisnik.setKomitent(this.komitent);
        this.zapisnik.setTip(TipDokumentConfig.get().ZAPISNIK_OTPREMNICE);
        this.zapisnik.setPoruka("");
        this.zapisnik.setKategorija(((PzUlazniRacunKategorijaUtil.UlazniRacunKategorija)this.rgrKategorija.getSelectedValue()).getId());
        if (this.komitent.getDomaciKomitent() == 0) {
            this.zapisnik.setPdv("INO");
        } else if (this.komitent.getObveznikPDV() == 0 && this.komitent.getSrbija() == 1) {
            this.zapisnik.setPdv("NIJE_OBVEZNIK");
        } else if (this.komitent.getObveznikPDV() == 0 && this.komitent.getSrbija() == 0) {
            this.zapisnik.setPdv("KOSOVO");
        } else {
            this.zapisnik.setPdv(PzSwingUtility.getSelectedValue((ButtonGroup)this.pdv));
        }
        if (!this.izmena.booleanValue()) {
            if (this.tableZap.insert((PzEntity)this.zapisnik, true)) {
                this.compGroupZaglavlje.disableAll();
                this.compGroupPDV.enableAll();
                if (!this.getPdvChoice().equals("SA_PRAVOM")) {
                    this.compGroupTable.enableAll();
                }
            }
            this.tableUnosNakFakt.setData(this.zapisnik.getKalkulacijazapisniks2(), Kalkulacijazapisnik.class);
        } else {
            this.updateDokument(this.zapisnik);
            this.compGroupZaglavlje.disableAll();
            this.compGroupPDV.enableAll();
            if (!this.getPdvChoice().equals("sa_odbitkom")) {
                this.compGroupTable.enableAll();
            }
        }
    }

    private void keyRel(KeyEvent evt) {
        int val = this.valuta.getIntVal();
        Date date1 = this.datDPO.getVal();
        if (evt.getSource() == this.valuta) {
            this.datValute.setVal((Object)PzDateUtility.add((Date)date1, (int)val));
        } else {
            this.valuta.setVal((Object)PzDateUtility.subtract((Date)this.datValute.getVal(), (Date)this.datDPO.getVal()));
        }
    }

    private void updateDokument(Kalkulacija zapisnik) {
        EntityManager em = PzEntityManager.getEm();
        Kalkulacija z = (Kalkulacija)em.find(Kalkulacija.class, (Object)zapisnik.getIdDok());
        z.setDatFakture(this.datDokumenta.getVal());
        z.setDatDPO(this.datDPO.getVal());
        z.setDatValute(this.datValute.getVal());
        z.setIznos(this.iznos.getBigDecimal());
        z.setPdv(PzSwingUtility.getSelectedValue((ButtonGroup)this.pdv));
        z.setArhiviran((short)0);
        z.setKomitent(this.komitent);
        z.setKategorija(((PzUlazniRacunKategorijaUtil.UlazniRacunKategorija)this.rgrKategorija.getSelectedValue()).getId());
        this.tableZap.updateSelectedEntity((PzEntity)z, true);
        em.clear();
        em.close();
    }

    private PzButtonPanelSelectionListener getSelectionListener() {
        return new PzButtonPanelSelectionListener(){

            public void buttonSelected(AbstractButton b) {
                String actionCommand = b.getActionCommand();
                if (actionCommand.equalsIgnoreCase("SA_PRAVOM")) {
                    PzDialogUnosNaknadneFakture.this.compGroupPDV.showAll();
                    return;
                }
                if (actionCommand.equalsIgnoreCase("BEZ_PRAVA")) {
                    if (PzDialogUnosNaknadneFakture.this.zapisnik.getTaksakalkulacijas() != null && PzDialogUnosNaknadneFakture.this.zapisnik.getTaksakalkulacijas().size() > 0) {
                        PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot(b), (String)"Da biste izabrali ovu opciju morate prethodno ukloniti PDV sa kalkulacije.");
                        PzDialogUnosNaknadneFakture.this.pdvVrsta1.setSelected(true);
                    } else {
                        PzDialogUnosNaknadneFakture.this.compGroupPDV.hideAll();
                    }
                    return;
                }
                if (actionCommand.equalsIgnoreCase("OSLOBODJENO")) {
                    if (PzDialogUnosNaknadneFakture.this.zapisnik.getTaksakalkulacijas() != null && PzDialogUnosNaknadneFakture.this.zapisnik.getTaksakalkulacijas().size() > 0) {
                        PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot(b), (String)"Da biste izabrali ovu opciju morate prethodno ukloniti PDV sa kalkulacije.");
                        PzDialogUnosNaknadneFakture.this.pdvVrsta1.setSelected(true);
                    } else {
                        PzDialogUnosNaknadneFakture.this.compGroupPDV.hideAll();
                    }
                    return;
                }
            }
        };
    }

    public BigDecimal getOstatak() {
        return this.txtOstatak.getBigDecimal();
    }

    private void calculateOstatak(Kalkulacija zapisnik) {
        List kz = zapisnik.getKalkulacijazapisniks2();
        List tod = zapisnik.getTaksakalkulacijas();
        BigDecimal pdvUpdate = new BigDecimal(0.0);
        BigDecimal ostatak = new BigDecimal(0.0);
        BigDecimal kalzapUpdate = new BigDecimal(0.0);
        if (kz != null) {
            for (Kalkulacijazapisnik kalZap : kz) {
                kalzapUpdate = kalzapUpdate.add(kalZap.getFakturisano());
            }
        }
        if (tod != null) {
            for (Taksakalkulacija to : tod) {
                pdvUpdate = pdvUpdate.add(to.getIznos());
            }
        }
        this.txtIznosPdv.setVal((Object)pdvUpdate);
        ostatak = this.iznos.getBigDecimal().subtract(pdvUpdate).subtract(kalzapUpdate);
        this.txtOstatak.setVal((Object)ostatak);
    }

    private void setTableFilter(PzTable table) {
        table.setFilter(new PzEntityFilter(){

            public Object[] getValues(PzEntity entity) {
                if (PzDialogUnosNaknadneFakture.this.kz == null) {
                    PzDialogUnosNaknadneFakture.this.kz = new Kalkulacijazapisnik();
                }
                PzDialogUnosNaknadneFakture.this.kz = (Kalkulacijazapisnik)entity;
                return new Object[]{PzDialogUnosNaknadneFakture.this.kz.getZapisnik().getOznDokumenta(), PzDialogUnosNaknadneFakture.this.kz.getZapisnik().getIznos().subtract(PzDialogUnosNaknadneFakture.this.kz.getZapisnik().getStornoIznos()), PzDialogUnosNaknadneFakture.this.kz.getZapisnik().getUkupnoFakturisano(), PzDialogUnosNaknadneFakture.this.kz.getZapisnik().getIznos().subtract(PzDialogUnosNaknadneFakture.this.kz.getZapisnik().getStornoIznos()).subtract(PzDialogUnosNaknadneFakture.this.kz.getZapisnik().getUkupnoFakturisano()), PzDialogUnosNaknadneFakture.this.kz.getFakturisano()};
            }

            public String[] getColumnNames() {
                return new String[]{"Br. otpremnice", "Iznos otpremnice", "Fakturisano", "Ostatak", "SADA"};
            }
        });
    }
}

