/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.gui.unosNaknadneFakture.pdv;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Taksakalkulacija;
import rs.pezar.db.entity.TaksakalkulacijaPK;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.sifarnici.gui.PzDialogStopePoreza;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class Dodavanje
extends PzDialogInsert {
    private static final long serialVersionUID = -3362895422040638148L;
    private PzPanel panel;
    private PzDoubleField pdv;
    private PzButton btnOK;
    private JPanel pnlButtons;
    private PzDoubleField osnovica;
    private PzTextField tarifa;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzPanelHeader header;
    private PzFieldIndikator indPdv;
    private PzFieldIndikator indOsnovica;
    private PzFieldIndikator indTgr;
    private JTextField stopa;
    private Tarifnagrupa tgr;
    private Boolean izmena;
    private Kalkulacija zapisnik;
    private PzTable table;
    private Boolean storno;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                Dodavanje inst = new Dodavanje(frame);
                inst.setVisible(true);
            }
        });
    }

    public Dodavanje(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public Dodavanje(PzDialog dialog) {
        super(dialog);
        this.zapisnik = (Kalkulacija)this.getSession().getParameter("zapisnik");
        this.izmena = (Boolean)this.getSession().getParameter("update");
        this.table = (PzTable)this.getSession().getParameter("table");
        this.storno = (Boolean)this.getSession().getParameter("storno");
    }

    protected void initGUI() {
        try {
            this.setResizable(false);
            this.setPreferredSize(new Dimension(398, 311));
            this.header = new PzPanelHeader();
            this.header.setIcon(this.getHeaderIcon());
            this.header.setTitle(this.getHeaderTitle());
            this.getContentPane().add((Component)this.header, "North");
            this.header.setPreferredSize(new Dimension(501, 59));
            this.pnlButtons = new JPanel();
            this.getContentPane().add((Component)this.pnlButtons, "South");
            this.pnlButtons.setPreferredSize(new Dimension(501, 54));
            this.btnOK = new PzButton();
            this.pnlButtons.add((Component)this.btnOK);
            this.btnOK.setText("Potvrdi");
            this.btnOK.setBounds(195, 12, 133, 30);
            this.btnOK.setFont(new Font("Tahoma", 1, 12));
            this.btnOK.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/check.png")));
            this.btnOK.setPreferredSize(new Dimension(140, 31));
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.panel = new PzPanel();
            this.getContentPane().add((Component)this.panel, "Center");
            this.panel.setTransferFocusOnEnter(true);
            GridBagLayout panelLayout = new GridBagLayout();
            this.panel.setPreferredSize(new Dimension(394, 338));
            panelLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
            panelLayout.rowHeights = new int[]{28, 28, 28};
            panelLayout.columnWeights = new double[]{0.1, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            panelLayout.columnWidths = new int[]{20, 74, -6, 20, 70, 86, 29, 45, 124, 7};
            this.panel.setLayout((LayoutManager)panelLayout);
            this.jLabel1 = new JLabel();
            this.panel.add((Component)this.jLabel1, (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel1.setText("Tarifa");
            this.jLabel1.setFont(new Font("Tahoma", 1, 12));
            this.jLabel2 = new JLabel();
            this.panel.add((Component)this.jLabel2, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel2.setText("Osnovica");
            this.jLabel2.setFont(new Font("Tahoma", 1, 12));
            this.jLabel3 = new JLabel();
            this.panel.add((Component)this.jLabel3, (Object)new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel3.setText("PDV");
            this.jLabel3.setFont(new Font("Tahoma", 1, 12));
            this.tarifa = new PzTextField();
            this.panel.add((Component)this.tarifa, (Object)new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tarifa.setFont(new Font("Tahoma", 0, 14));
            this.tarifa.setToUpperCase(true);
            this.tarifa.setVerifyInput(true);
            this.tarifa.setFKField(Tarifnagrupa.class, PzDialogStopePoreza.class, true, null);
            this.tarifa.setMaxLength(5);
            this.osnovica = new PzDoubleField();
            this.panel.add((Component)this.osnovica, (Object)new GridBagConstraints(5, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.osnovica.setFont(new Font("Tahoma", 0, 14));
            this.osnovica.setVerifyInput(true);
            this.osnovica.setName("osnovica");
            this.osnovica.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    Dodavanje.this.osnovicaKeyReleased(evt);
                }
            });
            this.osnovica.setVerifyInput(true);
            this.pdv = new PzDoubleField();
            this.panel.add((Component)this.pdv, (Object)new GridBagConstraints(5, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pdv.setFont(new Font("Tahoma", 0, 14));
            this.pdv.setName("iznos");
            this.pdv.setVerifyInput(true);
            this.stopa = new JTextField();
            this.panel.add((Component)this.stopa, (Object)new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.stopa.setEditable(false);
            this.stopa.setFocusable(false);
            this.stopa.setForeground(new Color(0, 128, 0));
            this.indTgr = new PzFieldIndikator();
            this.panel.add((Component)this.indTgr, (Object)new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indOsnovica = new PzFieldIndikator();
            this.panel.add((Component)this.indOsnovica, (Object)new GridBagConstraints(8, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indPdv = new PzFieldIndikator();
            this.panel.add((Component)this.indPdv, (Object)new GridBagConstraints(8, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.tarifa.setStateIndikator(this.indTgr);
            this.osnovica.setStateIndikator(this.indOsnovica);
            this.pdv.setStateIndikator(this.indPdv);
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equalsIgnoreCase("odustajanje")) {
            this.dispose();
        } else if (actionCommand.equals("insert")) {
            TaksakalkulacijaPK id = new TaksakalkulacijaPK(this.zapisnik.getIdDok(), this.tgr.getOznTarGr());
            Taksakalkulacija pdvZapisnik = new Taksakalkulacija();
            pdvZapisnik.setId(id);
            pdvZapisnik.setTarifnagrupa(this.tgr);
            pdvZapisnik.setIznos(this.pdv.getBigDecimal());
            pdvZapisnik.setOsnovica(this.osnovica.getBigDecimal());
            pdvZapisnik.setVrsta(this.tgr.getVrstatg().getOznVrstaTG());
            int i = 0;
            while (i < this.table.getRowCount()) {
                Taksakalkulacija tod = (Taksakalkulacija)this.table.getEntity(i);
                if (tod.getTarifnagrupa().getOznTarGr().equals(pdvZapisnik.getTarifnagrupa().getOznTarGr())) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Ve\u0107 ste uneli PDV sa ovom tarifnom grupom.");
                    this.setFirstComponentInFocus((Component)this.tarifa);
                    return;
                }
                ++i;
            }
            this.table.insert((PzEntity)pdvZapisnik, true);
        } else if (actionCommand.equals("update")) {
            Taksakalkulacija pdvZapisnik = (Taksakalkulacija)this.table.getSelectedEntity();
            pdvZapisnik.setIznos(this.pdv.getBigDecimal());
            pdvZapisnik.setOsnovica(this.osnovica.getBigDecimal());
            if (this.storno.booleanValue()) {
                this.table.updateSelectedEntity((PzEntity)pdvZapisnik, false);
            } else {
                this.table.updateSelectedEntity((PzEntity)pdvZapisnik, true);
            }
        }
        this.dispose();
    }

    public static Object getGUIBuilderInstance() {
        return new Dodavanje(Boolean.FALSE);
    }

    public Dodavanje(Boolean initGUI) {
    }

    protected void onInsert() {
        this.btnOK.setActionCommand("insert");
    }

    protected void onUpdate() {
        this.btnOK.setActionCommand("update");
        this.tarifa.setVal((Object)((Taksakalkulacija)((PzTable)this.getSession().getParameter("table")).getSelectedEntity()).getId().getOznTarGr());
        this.osnovica.setVal((Object)((Taksakalkulacija)((PzTable)this.getSession().getParameter("table")).getSelectedEntity()).getOsnovica());
        this.pdv.setVal((Object)((Taksakalkulacija)((PzTable)this.getSession().getParameter("table")).getSelectedEntity()).getIznos());
        this.tgr = ((Taksakalkulacija)((PzTable)this.getSession().getParameter("table")).getSelectedEntity()).getTarifnagrupa();
        this.btnOK.setActionCommand("update");
        this.tarifa.setEnabled(false);
        this.panel.updateAllFieldsState();
    }

    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Unos PDV-a");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/businessman_new.png")));
    }

    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Ispravka PDV-a");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/businessman_edit.png")));
    }

    public void setEntity(PzEntity entity, Component component) {
        this.tgr = (Tarifnagrupa)entity;
        if (this.tgr != null) {
            String pom = this.tarifa.getVal().toUpperCase();
            this.tarifa.setVal((Object)pom);
            this.tarifa.setVal((Object)this.tgr.getOznTarGr());
            this.stopa.setText(this.tgr.getStopa() + "%");
        }
    }

    private void osnovicaKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.pdv.setVal((Object)(this.osnovica.getVal() * this.tgr.getStopa() / 100.0));
        }
    }
}

