/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.reports.rf;

import java.awt.Component;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Vector;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.beanutils.PropertyUtils;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Taksakalkulacija;
import rs.pezar.db.entity.Trosak;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzSingleListDataSource;
import rs.pezar.reports.engine.standard.PzBeanDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.reports.rf.PzDokumentRF;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.util.PzFileUtility;

public class KalkulacijaRF
extends PzDokumentRF {
    @Override
    public void showReport(PzDialog parent, PzDokument dokument) {
        Kalkulacija kalkulacija = (Kalkulacija)dokument;
        try {
            Vector<Taksakalkulacija> porezi = new Vector<Taksakalkulacija>();
            Vector<Taksakalkulacija> ukalkPorez = new Vector<Taksakalkulacija>();
            for (Taksakalkulacija tk : kalkulacija.getTaksakalkulacijas()) {
                if (!tk.getTip().equals(PzTaksaDokument.TIP_UKALKULISANI) && !tk.getTip().equals(PzTaksaDokument.TIP_IZRACUNATI)) {
                    porezi.add(tk);
                } else {
                    ukalkPorez.add(tk);
                }
                tk.setKalkulacija((Kalkulacija)dokument);
            }
            if (kalkulacija.getTrosaks() != null) {
                for (Trosak t : kalkulacija.getTrosaks()) {
                    if (!t.getPdv().equals("SA_PRAVOM")) continue;
                    porezi.addAll(t.getTaksakalkulacijas());
                }
            }
            PzSingleListDataSource upDS = new PzSingleListDataSource(ukalkPorez);
            PzDataSourceExtended ulPorez = new PzDataSourceExtended(new Vector<Object>(), porezi);
            ulPorez.setAdapter(new PzBeanDataSourceAdapter(){

                @Override
                public Object getDynamicValue(String fieldName, Object obj) throws JRException {
                    Object res = null;
                    try {
                        String field = fieldName.substring(fieldName.indexOf(".") + 1, fieldName.length());
                        res = PropertyUtils.getProperty((Object)obj, (String)field);
                    }
                    catch (Exception exception) {}
                    return res;
                }
            });
            String tipDoc = null;
            tipDoc = kalkulacija.getPodTip().equalsIgnoreCase("FAKTURA") ? "fakturi" : (kalkulacija.getPodTip().equalsIgnoreCase("OTPREMNICA") ? "otpremnici" : "prenosnici");
            Vector<Trosak> t = new Vector<Trosak>();
            t.addAll(kalkulacija.getTrosaks());
            if (kalkulacija.getTrosakBezPdv().compareTo(new BigDecimal("0.00")) > 0) {
                Trosak trosakSaDok = new Trosak();
                trosakSaDok.setOznDokumenta("Trosak sa dok.");
                trosakSaDok.setOsnovica(kalkulacija.getTrosakBezPdv());
                trosakSaDok.setKomitent(kalkulacija.getKomitent());
                trosakSaDok.setTip("");
                t.add(trosakSaDok);
            }
            PzDataSourceExtended troskovi = new PzDataSourceExtended(new Vector<Object>(), t);
            troskovi.setAdapter(new PzBeanDataSourceAdapter());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("ulPorez", ulPorez);
            params.put("ukalkPorez", upDS);
            params.put("kalkPorezSubreport", JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/subreport.porez.tbl.ulazni.jasper", (ClassLoader)new KalkulacijaRF().getClass().getClassLoader())));
            params.put("troskovi", troskovi);
            params.put("troskoviSubreport", JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/subreport.troskovi.jasper", (ClassLoader)new KalkulacijaRF().getClass().getClassLoader())));
            params.put("kalkulacijaSubreport", JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/subreport.kalkulacija.jasper", (ClassLoader)new KalkulacijaRF().getClass().getClassLoader())));
            params.put("tipDoc", tipDoc);
            String title = null;
            title = kalkulacija.getTip().equals(TipDokumentConfig.get().PRIJEMNICA_REPRO) ? (kalkulacija.getArhiviran() == 0 ? (kalkulacija.getStorno() == 0 ? "Prijemnica materijala u pripremi" : "Storno prijemnice br. " + kalkulacija.getrBroj() + " u pripremi") : (kalkulacija.getStorno() == 0 ? "Prijemnica materijala broj " + kalkulacija.getrBroj() : "Storno prijemnice br. " + kalkulacija.getrBroj())) : (kalkulacija.getArhiviran() == 0 ? (kalkulacija.getStorno() == 0 ? "Kalkulacija u pripremi" : "Storno kalkulacije br. " + kalkulacija.getrBroj() + " u pripremi") : (kalkulacija.getStorno() == 0 ? "Kalkulacija broj " + kalkulacija.getrBroj() : "Storno kalkulacije br. " + kalkulacija.getrBroj()));
            PzReportManager.createAndShowReport(parent, (PzDokument)kalkulacija, title, params);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)parent, (Throwable)e);
        }
    }
}

