/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.reports.rf;

import java.awt.Component;
import java.util.HashMap;
import rs.pezar.db.PzDokument;
import rs.pezar.db.commons.PzParameterOld;
import rs.pezar.db.entity.Garnitura;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.rf.PzDokumentRF;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.util.PzDateUtility;

public class OpstidokumentRF
extends PzDokumentRF {
    @Override
    public void showReport(PzDialog parent, PzDokument dokument) {
        Opstidokument opstidokument = (Opstidokument)dokument;
        HashMap<String, Object> params = new HashMap<String, Object>();
        String title = null;
        try {
            if (opstidokument.getTip().equals("OTPIS")) {
                title = "OTPIS broj " + opstidokument.getrBroj();
                params.put("KEPU", String.valueOf(PzParameterOld.getParameter().getRbruKepu()));
            } else if (opstidokument.getTip().equals("UVECANJE_LAGERA")) {
                title = "UVE\u010aANJE ZALIHA broj " + opstidokument.getrBroj();
                params.put("KEPU", String.valueOf(PzParameterOld.getParameter().getRbruKepu()));
            } else if (opstidokument.getTip().equals("UMANJENJE_LAGERA")) {
                title = "UMANJENJE ZALIHA broj " + opstidokument.getrBroj();
                params.put("KEPU", String.valueOf(PzParameterOld.getParameter().getRbruKepu()));
            } else if (opstidokument.getTip().equals("TRANSFER")) {
                title = "ZAPISNIK O TRANSFERU KOLI\u010cINA broj " + opstidokument.getrBroj();
                params.put("KEPU", String.valueOf(PzParameterOld.getParameter().getRbruKepu()));
            } else if (opstidokument.getTip().equals("POPIS")) {
                title = opstidokument.getArhiviran() == 0 ? "POPISNA LISTA broj: PROBNA LISTA" : "POPISNA LISTA broj " + opstidokument.getrBroj();
                params.put("KEPU", String.valueOf(PzParameterOld.getParameter().getRbruKepu()));
            } else if (opstidokument.getTip().equals("GARNITURA")) {
                title = opstidokument.getStorno() == 0 ? "ZAPISNIK O FORMIRANJU GARNITURE broj " + ((Garnitura)opstidokument).getBrojGarniture() : "ZAPISNIK O DEMONTA\u017dI GARNITURE broj " + ((Garnitura)opstidokument).getBrojGarniture();
            } else if (opstidokument.getTip().equals("OTPIS_POTRAZIVANJA")) {
                title = "OTPIS POTRA\u017dIVANJA broj " + opstidokument.getrBroj();
            } else if (opstidokument.getTip().equals(TipDokumentConfig.get().NEISPRAVNA_ISPORUKA)) {
                title = "ZAPISNIK O NEISPRAVNOJ ISPORUCI BROJ: " + opstidokument.getrBroj();
            } else if (opstidokument.getTip().equals(TipDokumentConfig.get().CARINA_PRIJEM)) {
                title = dokument.getStorno() == 0 ? "PRIJEMNICA BROJ: " + opstidokument.getrBroj() : "STORNO PRIJEMNICA BROJ: " + opstidokument.getrBroj();
            } else if (opstidokument.getTip().equals("TREBOVANJE")) {
                title = opstidokument.getStorno() == 0 ? (opstidokument.getRadnajedinica().getgTip().equals("S") ? "TREBOVANJE MATERIJALA broj: " + opstidokument.getrBroj() : "TREBOVANJE POLUPROIZVODA broj: " + opstidokument.getrBroj()) : "STORNO TREBOVANJA broj: " + opstidokument.getrBroj();
            } else if (opstidokument.getTip().equals(TipDokumentConfig.get().TREBOVANJE_U_GARANTNOM_ROKU)) {
                title = opstidokument.getStorno() == 0 ? "TREBOVANJE broj: " + opstidokument.getrBroj() : "STORNO TREBOVANJA broj: " + opstidokument.getrBroj();
            } else if (opstidokument.getTip().equals("PREDAJNICA")) {
                title = opstidokument.getStorno() == 0 ? "PREDAJNICA broj: " + opstidokument.getrBroj() : "STORNO PREDAJNICE broj: " + opstidokument.getrBroj();
            } else if (opstidokument.getTip().equals(TipDokumentConfig.get().PROMENA_STOPE)) {
                title = "ZAPISNIK O PROMENI TARIFNE STOPE broj: " + opstidokument.getrBroj();
            } else if (opstidokument.getTip().equals(TipDokumentConfig.get().PRIJEMNICA_RESTORAN)) {
                title = "INTERNA PRIJEMNICA HRANE broj: " + opstidokument.getrBroj();
                params.put("KEPU", String.valueOf(PzParameterOld.getParameter().getRbruKepu()));
                params.put("datum", PzDateUtility.getCurrentDate());
            }
            PzReportManager.createAndShowReport(parent, (PzDokument)opstidokument, title, params);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)parent, (Throwable)e);
        }
    }
}

