/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.agencija.util;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.jdbc.ScriptRunner;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Firma;

public class DbTools {
    private static final String user = "pezar";
    private static final String pass = "p324r";

    public static void createDB(Firma f) throws Exception {
        URL url = DbTools.class.getClassLoader().getResource("rs/pezar/agencija/resource/sql.list");
        InputStream fis = url.openStream();
        List sqls = IOUtils.readLines((InputStream)fis);
        Connection conn = DbTools.OpenConnection("jdbc:postgresql://" + f.getServer() + "/" + f.getBaza(), user, pass);
        conn.setAutoCommit(false);
        int i = 0;
        while (i < sqls.size()) {
            InputStreamReader reader = new InputStreamReader(DbTools.class.getClassLoader().getResource("rs/pezar/agencija/resource/sql/" + (String)sqls.get(i)).openStream());
            ScriptRunner runner = new ScriptRunner(conn);
            runner.runScript((Reader)reader);
            ++i;
        }
        String extSqlStr = String.valueOf(PzParameter.getParameterValue((String)"DELJENI_DIR")) + File.separator + "agencija" + File.separator + "sql";
        File extSqlDir = new File(extSqlStr);
        if (extSqlDir.exists()) {
            File[] extSqls = extSqlDir.listFiles();
            int i2 = 0;
            while (i2 < extSqls.length) {
                File extSql = extSqls[i2];
                ScriptRunner runner = new ScriptRunner(conn);
                runner.runScript((Reader)new FileReader(extSql));
                ++i2;
            }
        }
        DbTools.insertFirma(conn, f);
        conn.commit();
        DbTools.CloseConnection(conn);
    }

    private static void insertFirma(Connection conn, Firma f) throws SQLException {
        String q = "INSERT INTO Firma (oznFirma, naziv, adresa, postBroj, grad, telefoni, fax, email, matBroj, pib, regBroj, mestoReg, sifDelatnosti, pdvObveznik) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement ps = conn.prepareStatement(q);
        ps.setInt(1, f.getOznFirma());
        ps.setString(2, f.getNaziv());
        ps.setString(3, f.getAdresa());
        ps.setString(4, f.getPostBroj());
        ps.setString(5, f.getGrad());
        ps.setString(6, f.getTelefoni());
        ps.setString(7, f.getFax());
        ps.setString(8, f.getEmail());
        ps.setString(9, f.getMatBroj());
        ps.setString(10, f.getPib());
        ps.setString(11, f.getRegBroj());
        ps.setString(12, f.getMestoReg());
        ps.setString(13, f.getSifDelatnosti());
        ps.setShort(14, f.getPdvObveznik());
        ps.execute();
        ps = conn.prepareStatement("INSERT INTO Parameter (name, value) values (?, ?)");
        ps.setString(1, "TEKUCA_GODINA");
        ps.setString(2, String.valueOf(f.getGodina()));
        ps.execute();
        ps = conn.prepareStatement("INSERT INTO Parameter (name, value) values (?, ?)");
        ps.setString(1, "OBRACUNSKI_PERIOD");
        ps.setString(2, f.getPDVPeriod());
        ps.execute();
    }

    public static void createDatabase(String host, String dbName) throws Exception {
        String ret;
        block19: {
            ret = "";
            Connection con = null;
            String db = dbName;
            if (StringUtils.isNumeric((String)StringUtils.substring((String)dbName, (int)0, (int)1))) {
                db = "\"" + dbName + "\"";
            }
            try {
                try {
                    con = DbTools.OpenConnection("jdbc:postgresql://" + host + "/postgres", user, pass);
                    DbTools.ExecuteQuery(con, "CREATE DATABASE " + db);
                    DbTools.CloseConnection(con);
                }
                catch (SQLException e) {
                    ret = String.valueOf(e.getMessage()) + "\n";
                    try {
                        if (con != null) {
                            con.rollback();
                        }
                    }
                    catch (SQLException e1) {
                        ret = String.valueOf(ret) + e1.getMessage() + "\n";
                    }
                    try {
                        if (con != null) {
                            con.close();
                        }
                        break block19;
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                        ret = String.valueOf(e2.getMessage()) + "\n";
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    ret = String.valueOf(e.getMessage()) + "\n";
                }
                throw throwable;
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                ret = String.valueOf(e.getMessage()) + "\n";
            }
        }
        if (!ret.equals("")) {
            throw new Exception(ret);
        }
    }

    public static void dropDatabase(String host, String dbName) throws Exception {
        String ret;
        block19: {
            ret = "";
            Connection con = null;
            String db = dbName;
            if (StringUtils.isNumeric((String)StringUtils.substring((String)dbName, (int)0, (int)1))) {
                db = "\"" + dbName + "\"";
            }
            try {
                try {
                    con = DbTools.OpenConnection("jdbc:postgresql://" + host + "/postgres", user, pass);
                    DbTools.ExecuteQuery(con, "DROP DATABASE " + db);
                    DbTools.CloseConnection(con);
                }
                catch (SQLException e) {
                    ret = String.valueOf(e.getMessage()) + "\n";
                    try {
                        if (con != null) {
                            con.rollback();
                        }
                    }
                    catch (SQLException e1) {
                        ret = String.valueOf(ret) + e1.getMessage() + "\n";
                    }
                    try {
                        if (con != null) {
                            con.close();
                        }
                        break block19;
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                        ret = String.valueOf(e2.getMessage()) + "\n";
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    ret = String.valueOf(e.getMessage()) + "\n";
                }
                throw throwable;
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                ret = String.valueOf(e.getMessage()) + "\n";
            }
        }
        if (!ret.equals("")) {
            throw new Exception(ret);
        }
    }

    public static boolean databaseExists(String host, String dbName) {
        Connection con = null;
        try {
            con = DbTools.OpenConnection("jdbc:postgresql://" + host + "/" + dbName, user, pass);
            DbTools.CloseConnection(con);
        }
        catch (SQLException sQLException) {
            return false;
        }
        return true;
    }

    public static void ExecuteQuery(Connection conn, String sql) throws SQLException {
        Statement stmt = null;
        stmt = conn.createStatement();
        stmt.executeUpdate(sql);
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException sQLException) {}
    }

    private static Connection OpenConnection(String dbURL, String username, String password) throws SQLException {
        Connection conn = null;
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        conn = DriverManager.getConnection(dbURL, username, password);
        return conn;
    }

    public static void CloseConnection(Connection conn) throws SQLException {
        if (conn != null) {
            conn.close();
        }
    }
}

