/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.internal.autostart;

import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class Autostarter
implements BundleActivator,
BundleTrackerCustomizer {
    BundleTracker tracker;
    List<Bundle> bundles = new ArrayList<Bundle>();
    private static Autostarter instance;

    public void start(BundleContext context) throws Exception {
        instance = this;
        this.tracker = new BundleTracker(context, 12, (BundleTrackerCustomizer)this);
        this.tracker.open();
    }

    public static Autostarter getInstance() {
        return instance;
    }

    private void startBundle(Bundle bundle) {
        if (bundle.getHeaders().get("Fragment-Host") == null) {
            try {
                this.bundles.add(bundle);
                if (bundle.getSymbolicName().startsWith("rs.pezar")) {
                    System.out.println("Starting bundle " + bundle.getSymbolicName());
                    bundle.start();
                }
            }
            catch (BundleException bundleException) {}
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.tracker.close();
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        this.startBundle(bundle);
        return bundle;
    }

    public void startAll() throws BundleException {
        for (Bundle bundle : this.bundles) {
            if (!bundle.getSymbolicName().startsWith("rs.pezar")) continue;
            bundle.start();
        }
    }

    public void stopAll() throws BundleException {
        for (Bundle bundle : this.bundles) {
            bundle.stop();
        }
    }

    public List getBundles() {
        return this.bundles;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
    }
}

