/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.magacin.gui.stampanjeNalepnica;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.magacin.gui.stampanjeNalepnica.DopunaPremaKalkulaciji;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class UzmiDokument
extends PzDialog {
    private static final long serialVersionUID = 5284942039737355206L;
    private JToolBar toolbar;
    private PzToolBarIcon btnSlikaDokumenta;
    private PzPanel plGlavni;
    private PzTable tblTabela;
    private JScrollPane scTabela;
    private PzPanel plTabela;
    private JPanel jPanel1;
    private String tipDokumenta;
    private Radnajedinica radnaJedinica;
    private PzDokument selektovanDokument;
    private final String tableID = "";
    private String komitent;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public UzmiDokument(PzDialog dialog) {
        super(dialog);
        this.tipDokumenta = (String)this.getSession().getParameter("tip");
        this.komitent = (String)this.getSession().getParameter("komitent");
        this.radnaJedinica = (Radnajedinica)this.getSession().getParameter("radnajedinica");
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Izbor dokumenta");
            this.plGlavni = new PzPanel();
            this.plGlavni.setPaintGradient(true);
            GridBagLayout plGlavniLayout = new GridBagLayout();
            plGlavniLayout.rowWeights = new double[]{0.0, 0.1};
            plGlavniLayout.rowHeights = new int[]{84, 7};
            plGlavniLayout.columnWeights = new double[]{0.1};
            plGlavniLayout.columnWidths = new int[]{7};
            this.plGlavni.setLayout((LayoutManager)plGlavniLayout);
            this.getContentPane().add((Component)this.plGlavni, "Center");
            this.toolbar = new JToolBar();
            this.plGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.btnSlikaDokumenta = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnSlikaDokumenta);
            this.btnSlikaDokumenta.setText("Slika|dokumenta|(F2)");
            this.btnSlikaDokumenta.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/presentation.png")));
            this.btnSlikaDokumenta.setActionCommand("slika");
            this.btnSlikaDokumenta.addActionListener((ActionListener)((Object)this));
            this.btnSlikaDokumenta.setShortcut("F2");
            this.jPanel1 = new JPanel();
            this.plGlavni.add((Component)this.jPanel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            BorderLayout jPanel1Layout1 = new BorderLayout();
            this.jPanel1.setLayout(jPanel1Layout1);
            this.jPanel1.setOpaque(false);
            this.plTabela = new PzPanel();
            GridBagLayout jPanel1Layout = new GridBagLayout();
            jPanel1Layout.rowWeights = new double[]{0.1, 0.1, 0.1};
            jPanel1Layout.rowHeights = new int[]{7, 20, 7};
            jPanel1Layout.columnWeights = new double[]{0.1};
            jPanel1Layout.columnWidths = new int[]{7};
            this.jPanel1.add((Component)this.plTabela, "Center");
            this.plTabela.setLayout((LayoutManager)jPanel1Layout);
            this.plTabela.setOpaque(false);
            this.scTabela = new JScrollPane();
            this.plTabela.add((Component)this.scTabela, (Object)new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 10, 1, new Insets(15, 15, 15, 15), 0, 0));
            this.scTabela.setBackground(new Color(255, 255, 255));
            this.tblTabela = new PzTable();
            this.tblTabela.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Kalkulacija dok = null;
                    if (UzmiDokument.this.tipDokumenta.equals(TipDokumentConfig.get().KALKULACIJA)) {
                        dok = (Kalkulacija)entity;
                        return new Object[]{dok.getOznDokumenta(), dok.getIznos(), dok.getIznos(), dok.getDatum(), dok.getDatValute()};
                    }
                    if (UzmiDokument.this.tipDokumenta.equals(TipDokumentConfig.get().INTERNI_NALOG)) {
                        dok = (Interniracun)entity;
                        return new Object[]{dok.getOznDokumenta(), dok.getIznos(), dok.getIznos(), dok.getDatum(), dok.getDatValute()};
                    }
                    if (UzmiDokument.this.tipDokumenta.equals(TipDokumentConfig.get().NIVELACIJA)) {
                        dok = (Nivelacija)entity;
                        return new Object[]{dok.getOznDokumenta(), dok.getDatum()};
                    }
                    return null;
                }

                public String[] getColumnNames() {
                    if (UzmiDokument.this.tipDokumenta.equals(TipDokumentConfig.get().KALKULACIJA)) {
                        return new String[]{"Oznaka dokumenta", "Iznos dokumenta", "Dug po dokumentu", "Datum dokumenta", "Datum valute"};
                    }
                    if (UzmiDokument.this.tipDokumenta.equals(TipDokumentConfig.get().INTERNI_NALOG)) {
                        return new String[]{"Oznaka dokumenta", "Iznos dokumenta", "Dug po dokumentu", "Datum dokumenta", "Datum valute"};
                    }
                    if (UzmiDokument.this.tipDokumenta.equals(TipDokumentConfig.get().NIVELACIJA)) {
                        return new String[]{"Oznaka dokumenta", "Datum dokumenta"};
                    }
                    return null;
                }
            });
            EntityManager em = PzEntityManager.getEm();
            Query q = null;
            if (this.tipDokumenta.equals(TipDokumentConfig.get().KALKULACIJA)) {
                q = em.createQuery("SELECT k FROM Kalkulacija k where k.arhiviran=1 and k.radnajedinica=:rj and k.tip=:tip and k.komitent.sfrKomitent=:sifra and k.storno=0");
                q.setParameter("tip", (Object)this.tipDokumenta);
                q.setParameter("sifra", (Object)this.komitent);
            } else if (this.tipDokumenta.equals(TipDokumentConfig.get().NIVELACIJA)) {
                q = em.createQuery("SELECT n FROM Nivelacija n where n.arhiviran=1 and n.radnajedinica=:rj ");
            } else if (this.tipDokumenta.equals(TipDokumentConfig.get().INTERNI_NALOG)) {
                q = em.createQuery("SELECT r FROM Interniracun r where r.arhiviran=1 and r.izlaznaRJ=:rj and r.tip=:tip and r.storno = 0");
                q.setParameter("tip", (Object)this.tipDokumenta);
            }
            q.setParameter("rj", (Object)this.radnaJedinica);
            Vector data = (Vector)q.getResultList();
            if (this.tipDokumenta.equals(TipDokumentConfig.get().KALKULACIJA)) {
                this.tblTabela.setData(data, Kalkulacija.class);
            } else if (this.tipDokumenta.equals(TipDokumentConfig.get().NIVELACIJA)) {
                this.tblTabela.setData(data, Nivelacija.class);
            } else if (this.tipDokumenta.equals(TipDokumentConfig.get().INTERNI_NALOG)) {
                this.tblTabela.setData(data, Interniracun.class);
            }
            this.brDok.setText(String.valueOf(data.size()));
            em.close();
            this.tblTabela.setId("");
            this.scTabela.setViewportView((Component)this.tblTabela);
            this.tblTabela.getTableHeader().setFocusable(false);
            this.tblTabela.requestFocusInWindow();
            if (this.tblTabela.getDataSize() > 0) {
                this.tblTabela.setRowSelectionInterval(0, 0);
            }
            this.tblTabela.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (UzmiDokument.this.tblTabela.getDataSize() > 0) {
                        EntityManager em = PzEntityManager.getEm();
                        try {
                            try {
                                if (UzmiDokument.this.tipDokumenta.equals(TipDokumentConfig.get().KALKULACIJA)) {
                                    UzmiDokument.this.selektovanDokument = (PzDokument)((Kalkulacija)UzmiDokument.this.tblTabela.getSelectedEntity());
                                    ((DopunaPremaKalkulaciji)((Object)UzmiDokument.this.getParent())).setOznakaDokumenta(UzmiDokument.this.selektovanDokument.getOznDokumenta());
                                    ((DopunaPremaKalkulaciji)((Object)UzmiDokument.this.getParent())).napraviNalepnice((Kalkulacija)UzmiDokument.this.selektovanDokument);
                                } else if (UzmiDokument.this.tipDokumenta.equals(TipDokumentConfig.get().NIVELACIJA)) {
                                    UzmiDokument.this.selektovanDokument = (PzDokument)((Nivelacija)UzmiDokument.this.tblTabela.getSelectedEntity());
                                    UzmiDokument.this.getSession().putParameter("dokument", (Object)UzmiDokument.this.selektovanDokument);
                                } else if (UzmiDokument.this.tipDokumenta.equals(TipDokumentConfig.get().INTERNI_NALOG)) {
                                    UzmiDokument.this.selektovanDokument = (PzDokument)((Interniracun)UzmiDokument.this.tblTabela.getSelectedEntity());
                                    UzmiDokument.this.getSession().putParameter("dokument", (Object)UzmiDokument.this.selektovanDokument);
                                }
                                UzmiDokument.this.dispose();
                            }
                            catch (Exception ex) {
                                PzMysqlExceptionHandler.handle(null, (Throwable)ex);
                                if (em.getTransaction().isActive()) {
                                    em.getTransaction().rollback();
                                }
                                em.close();
                            }
                        }
                        finally {
                            em.close();
                        }
                    }
                }
            });
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("Broj stavki");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(697, 580);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(null, (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("slika")) {
            this.showReport();
        }
    }

    public void showReport() {
        try {
            if (this.tblTabela.getSelectedEntity() != null) {
                if (this.tipDokumenta.equals(TipDokumentConfig.get().KALKULACIJA)) {
                    Kalkulacija kalkulacija = (Kalkulacija)this.tblTabela.getSelectedEntity();
                    PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)kalkulacija);
                }
                if (this.tipDokumenta.equals(TipDokumentConfig.get().NIVELACIJA)) {
                    Nivelacija niv = (Nivelacija)this.tblTabela.getSelectedEntity();
                    PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)niv);
                }
                if (this.tipDokumenta.equals(TipDokumentConfig.get().INTERNI_NALOG)) {
                    Interniracun racun = (Interniracun)this.tblTabela.getSelectedEntity();
                    PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)racun);
                }
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new UzmiDokument(Boolean.FALSE);
    }

    public UzmiDokument(Boolean initGUI) {
    }
}

