/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.function.string;

import java.util.ArrayList;
import net.sourceforge.jeval.Evaluator;
import net.sourceforge.jeval.function.Function;
import net.sourceforge.jeval.function.FunctionException;
import net.sourceforge.jeval.function.FunctionHelper;
import net.sourceforge.jeval.function.FunctionResult;

public class EndsWith
implements Function {
    @Override
    public String getName() {
        return "endsWith";
    }

    @Override
    public FunctionResult execute(Evaluator evaluator, String arguments) throws FunctionException {
        String result = null;
        String exceptionMessage = "Two string arguments are required.";
        ArrayList strings = FunctionHelper.getStrings(arguments, ',');
        if (strings.size() != 2) {
            throw new FunctionException(exceptionMessage);
        }
        try {
            String argumentOne = FunctionHelper.trimAndRemoveQuoteChars((String)strings.get(0), evaluator.getQuoteCharacter());
            String argumentTwo = FunctionHelper.trimAndRemoveQuoteChars((String)strings.get(1), evaluator.getQuoteCharacter());
            result = argumentOne.endsWith(argumentTwo) ? "1.0" : "0.0";
        }
        catch (FunctionException fe) {
            throw new FunctionException(fe.getMessage(), fe);
        }
        catch (Exception e) {
            throw new FunctionException(exceptionMessage, e);
        }
        return new FunctionResult(result, 0);
    }
}

