/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.function.string;

import java.util.ArrayList;
import net.sourceforge.jeval.Evaluator;
import net.sourceforge.jeval.function.Function;
import net.sourceforge.jeval.function.FunctionException;
import net.sourceforge.jeval.function.FunctionHelper;
import net.sourceforge.jeval.function.FunctionResult;

public class Replace
implements Function {
    @Override
    public String getName() {
        return "replace";
    }

    @Override
    public FunctionResult execute(Evaluator evaluator, String arguments) throws FunctionException {
        String result = null;
        String exceptionMessage = "One string argument and two character arguments are required.";
        ArrayList values = FunctionHelper.getStrings(arguments, ',');
        if (values.size() != 3) {
            throw new FunctionException(exceptionMessage);
        }
        try {
            String argumentOne = FunctionHelper.trimAndRemoveQuoteChars((String)values.get(0), evaluator.getQuoteCharacter());
            String argumentTwo = FunctionHelper.trimAndRemoveQuoteChars((String)values.get(1), evaluator.getQuoteCharacter());
            String argumentThree = FunctionHelper.trimAndRemoveQuoteChars((String)values.get(2), evaluator.getQuoteCharacter());
            char oldCharacter = ' ';
            if (argumentTwo.length() != 1) {
                throw new FunctionException(exceptionMessage);
            }
            oldCharacter = argumentTwo.charAt(0);
            char newCharacter = ' ';
            if (argumentThree.length() != 1) {
                throw new FunctionException(exceptionMessage);
            }
            newCharacter = argumentThree.charAt(0);
            result = argumentOne.replace(oldCharacter, newCharacter);
        }
        catch (FunctionException fe) {
            throw new FunctionException(fe.getMessage(), fe);
        }
        catch (Exception e) {
            throw new FunctionException(exceptionMessage, e);
        }
        return new FunctionResult(result, 1);
    }
}

