/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.util.ArrayList;
import java.util.List;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.VariableCompletion;

public class FunctionCompletion
extends VariableCompletion
implements ParameterizedCompletion {
    private List params;
    private String returnValDesc;

    public FunctionCompletion(CompletionProvider provider, String name, String returnType) {
        super(provider, name, returnType);
    }

    @Override
    protected void addDefinitionString(StringBuffer sb) {
        sb.append("<html><b>");
        sb.append(this.getDefinitionString());
        sb.append("</b>");
    }

    protected void addParameters(StringBuffer sb) {
        int paramCount = this.getParamCount();
        if (paramCount > 0) {
            sb.append("<b>Parameters:</b><br>");
            sb.append("<center><table width='90%'><tr><td>");
            int i = 0;
            while (i < paramCount) {
                ParameterizedCompletion.Parameter param = this.getParam(i);
                sb.append("<b>");
                sb.append(param.getName() != null ? param.getName() : param.getType());
                sb.append("</b>&nbsp;");
                String desc = param.getDescription();
                if (desc != null) {
                    sb.append(desc);
                }
                sb.append("<br>");
                ++i;
            }
            sb.append("</td></tr></table></center><br><br>");
        }
        if (this.returnValDesc != null) {
            sb.append("<b>Returns:</b><br><center><table width='90%'><tr><td>");
            sb.append(this.returnValDesc);
            sb.append("</td></tr></table></center><br><br>");
        }
    }

    @Override
    public String getDefinitionString() {
        StringBuffer sb = new StringBuffer();
        String type = this.getType();
        if (type != null) {
            sb.append(type).append(' ');
        }
        sb.append(this.getName());
        CompletionProvider provider = this.getProvider();
        char start = provider.getParameterListStart();
        if (start != '\u0000') {
            sb.append(start);
        }
        int i = 0;
        while (i < this.getParamCount()) {
            ParameterizedCompletion.Parameter param = this.getParam(i);
            type = param.getType();
            String name = param.getName();
            if (type != null) {
                sb.append(type);
                if (name != null) {
                    sb.append(' ');
                }
            }
            if (name != null) {
                sb.append(name);
            }
            if (i < this.params.size() - 1) {
                sb.append(provider.getParameterListSeparator());
            }
            ++i;
        }
        char end = provider.getParameterListEnd();
        if (end != '\u0000') {
            sb.append(end);
        }
        return sb.toString();
    }

    @Override
    public ParameterizedCompletion.Parameter getParam(int index) {
        return (ParameterizedCompletion.Parameter)this.params.get(index);
    }

    @Override
    public int getParamCount() {
        return this.params == null ? 0 : this.params.size();
    }

    public String getReturnValueDescription() {
        return this.returnValDesc;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        this.addDefinitionString(sb);
        if (!this.possiblyAddDescription(sb)) {
            sb.append("<br><br><br>");
        }
        this.addParameters(sb);
        this.possiblyAddDefinedIn(sb);
        return sb.toString();
    }

    @Override
    public String getToolTipText() {
        String text = this.getSummary();
        if (text == null) {
            text = this.getDefinitionString();
        }
        return text;
    }

    public void setParams(List params) {
        this.params = new ArrayList(params);
    }

    public void setReturnValueDescription(String desc) {
        this.returnValDesc = desc;
    }
}

