/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.LocalStorage;
import org.jdesktop.application.session.PropertySupport;
import org.jdesktop.application.session.SplitPaneProperty;
import org.jdesktop.application.session.TabbedPaneProperty;
import org.jdesktop.application.session.TableProperty;
import org.jdesktop.application.session.WindowProperty;
import org.jdesktop.swingx.JXTable;

public class SessionStorage {
    private static Logger logger = Logger.getLogger(SessionStorage.class.getName());
    private final Map<Class, PropertySupport> propertyMap;
    private final ApplicationContext context;

    protected SessionStorage(ApplicationContext context) {
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        this.context = context;
        this.propertyMap = new HashMap<Class, PropertySupport>();
        this.propertyMap.put(Window.class, new WindowProperty());
        this.propertyMap.put(JTabbedPane.class, new TabbedPaneProperty());
        this.propertyMap.put(JSplitPane.class, new SplitPaneProperty());
        this.propertyMap.put(JTable.class, new TableProperty());
    }

    protected final ApplicationContext getContext() {
        return this.context;
    }

    private void checkSaveRestoreArgs(Component root, String fileName) {
        if (root == null) {
            throw new IllegalArgumentException("null root");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("null fileName");
        }
    }

    private String getComponentName(Component c) {
        return c.getName();
    }

    private String getComponentPathname(Component c) {
        String name = this.getComponentName(c);
        if (name == null) {
            return null;
        }
        if (c instanceof JXTable) {
            return name;
        }
        StringBuilder path = new StringBuilder(name);
        while (c.getParent() != null && !(c instanceof Window) && !(c instanceof Applet)) {
            name = this.getComponentName(c = c.getParent());
            if (name == null) {
                int n = c.getParent().getComponentZOrder(c);
                if (n >= 0) {
                    Class<?> cls = c.getClass();
                    name = cls.getSimpleName();
                    if (name.length() == 0) {
                        name = "Anonymous" + cls.getSuperclass().getSimpleName();
                    }
                    name = String.valueOf(name) + n;
                } else {
                    logger.warning("Couldn't compute pathname for " + c);
                    return null;
                }
            }
            path.append("/").append(name);
        }
        return path.toString();
    }

    private void saveTree(List<Component> roots, Map<String, Object> stateMap) {
        ArrayList<Component> allChildren = new ArrayList<Component>();
        for (Component root : roots) {
            Component[] children;
            Object state;
            String pathname;
            PropertySupport p;
            if (root != null && (p = this.getProperty(root)) != null && (pathname = this.getComponentPathname(root)) != null && (state = p.getSessionState(root)) != null) {
                stateMap.put(pathname, state);
            }
            if (!(root instanceof Container) || (children = ((Container)root).getComponents()) == null || children.length <= 0) continue;
            Collections.addAll(allChildren, children);
        }
        if (allChildren.size() > 0) {
            this.saveTree(allChildren, stateMap);
        }
    }

    public void save(Component root, String fileName) throws IOException {
        this.checkSaveRestoreArgs(root, fileName);
        HashMap<String, Object> stateMap = new HashMap<String, Object>();
        this.saveTree(Collections.singletonList(root), stateMap);
        LocalStorage lst = this.getContext().getLocalStorage();
        lst.save(stateMap, fileName);
    }

    private void restoreTree(List<Component> roots, Map<String, Object> stateMap) {
        ArrayList<Component> allChildren = new ArrayList<Component>();
        for (Component root : roots) {
            Component[] children;
            String pathname;
            PropertySupport p;
            if (root != null && (p = this.getProperty(root)) != null && (pathname = this.getComponentPathname(root)) != null) {
                Object state = stateMap.get(pathname);
                if (state != null) {
                    p.setSessionState(root, state);
                } else {
                    logger.warning("No saved state for " + root);
                }
            }
            if (!(root instanceof Container) || (children = ((Container)root).getComponents()) == null || children.length <= 0) continue;
            Collections.addAll(allChildren, children);
        }
        if (allChildren.size() > 0) {
            this.restoreTree(allChildren, stateMap);
        }
    }

    public void restore(Component root, String fileName) throws IOException {
        this.checkSaveRestoreArgs(root, fileName);
        LocalStorage lst = this.getContext().getLocalStorage();
        Map stateMap = (Map)lst.load(fileName);
        if (stateMap != null) {
            this.restoreTree(Collections.singletonList(root), stateMap);
        }
    }

    private void checkClassArg(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("null class");
        }
    }

    public PropertySupport getProperty(Class cls) {
        this.checkClassArg(cls);
        while (cls != null) {
            PropertySupport p = this.propertyMap.get(cls);
            if (p != null) {
                return p;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    public void putProperty(Class cls, PropertySupport propertySupport) {
        this.checkClassArg(cls);
        if (propertySupport == null) {
            this.propertyMap.remove(cls);
            return;
        }
        this.propertyMap.put(cls, propertySupport);
    }

    public final PropertySupport getProperty(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (component instanceof PropertySupport) {
            return (PropertySupport)((Object)component);
        }
        PropertySupport p = null;
        if (component instanceof JComponent) {
            Object v = ((JComponent)component).getClientProperty(PropertySupport.class);
            p = v instanceof PropertySupport ? (PropertySupport)v : null;
        }
        return p != null ? p : this.getProperty(component.getClass());
    }
}

