/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prostoKnjigovodstvo.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Izvodbanke;
import rs.pezar.db.entity.Tekuciracun;
import rs.pezar.prostoKnjigovodstvo.gui.knjizenje.PzDialogIzradaNaloga;
import rs.pezar.prostoKnjigovodstvo.gui.knjizenje.PzDialogNoviNalog;
import rs.pezar.prostoKnjigovodstvo.gui.util.Tools;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBar;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.data.models.PzTableModel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogRegistrovanjeIzvoda
extends PzDialog {
    private static final long serialVersionUID = 4397023903288929764L;
    private final PzPanel mainPanel = new PzPanel();
    private PzToolBar toolbar;
    private JScrollPane scp;
    private PzDoubleField dfStanje;
    private JLabel lblStanje;
    private PzDoubleField dfIzlaz;
    private JLabel lblIzlaz;
    private PzDoubleField dfUlaz;
    private JLabel lblUlaz;
    private JLabel lblTekuci;
    private PzTextField tfTekuci;
    private PzPanel pnlFields;
    private PzTable tblRacuni;
    private JScrollPane scrollPaneRacun;
    private PzPanel pnlRacun;
    private PzTable table;
    private JLabel numUkupnoNaloga;
    private JLabel lblUkupnoNaloga;
    private PzToolBarIcon icnNovNalog;
    private EntityManager em;
    private PzStatusBar statusBar;
    private Tekuciracun racun;
    private PzToolBarIcon icnIzmenaNaloga;

    public static void main(String[] args) {
        try {
            PzDialogRegistrovanjeIzvoda dialog = new PzDialogRegistrovanjeIzvoda();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PzDialogRegistrovanjeIzvoda() {
        this.initGUI();
    }

    public PzDialogRegistrovanjeIzvoda(JFrame frame) {
        super(frame);
    }

    public boolean shouldBeShown() {
        this.mainPanel.setPaintGradient(true);
        this.em = PzEntityManagerFactory.getInstance().createEm();
        this.getSession().putParameter("em", (Object)this.em);
        this.initGUI();
        return true;
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
        this.em.close();
    }

    private void initGUI() {
        try {
            this.setTitle("Registrovanje izvoda teku\u010deg racuna banke");
            this.setBounds(0, 0, 870, 639);
            this.mainPanel.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.1};
            mainPanelLayout.rowHeights = new int[]{7, 194, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            mainPanelLayout.columnWidths = new int[]{573, 212, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.toolbar = new PzToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.toolbar.setFloatable(false);
            this.toolbar.setOpaque(false);
            this.icnNovNalog = new PzToolBarIcon();
            this.icnNovNalog.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = -5378169203543812683L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzDialogRegistrovanjeIzvoda.this.actionPerformedicnNovNalog(arg0);
                }
            });
            this.icnNovNalog.setShortcut("insert");
            this.icnNovNalog.setText("Novi izvod|(INS)");
            this.icnNovNalog.setIcon((Icon)new ImageIcon(PzDialogRegistrovanjeIzvoda.class.getResource("/rs/pezar/prostoKnjigovodstvo/resource/img/nzk.png")));
            this.toolbar.add((Component)this.icnNovNalog);
            this.icnIzmenaNaloga = new PzToolBarIcon();
            this.icnIzmenaNaloga.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = -5378169203543812683L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzDialogRegistrovanjeIzvoda.this.actionPerformedicnIzmenaNaloga(arg0);
                }
            });
            this.icnIzmenaNaloga.setShortcut("f3");
            this.icnIzmenaNaloga.setText("Izmena izvoda|(F3)");
            this.icnIzmenaNaloga.setIcon((Icon)new ImageIcon(PzDialogRegistrovanjeIzvoda.class.getResource("/rs/pezar/prostoKnjigovodstvo/resource/img/nzk.png")));
            this.toolbar.add((Component)this.icnIzmenaNaloga);
            this.toolbar.setFloatable(false);
            this.toolbar.setOpaque(false);
            this.scp = new JScrollPane();
            this.mainPanel.add((Component)this.scp, (Object)new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            GridBagConstraints gbc_scp = new GridBagConstraints();
            gbc_scp.insets = new Insets(10, 10, 10, 10);
            gbc_scp.fill = 1;
            gbc_scp.gridx = 0;
            gbc_scp.gridy = 0;
            this.table = new PzTable();
            this.scp.setViewportView((Component)this.table);
            this.table.setId("TBL_NALOG");
            this.pnlRacun = new PzPanel();
            GridBagLayout pnlRacunLayout = new GridBagLayout();
            this.pnlRacun.setLayout((LayoutManager)pnlRacunLayout);
            this.mainPanel.add((Component)this.pnlRacun, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
            this.pnlRacun.setBorder((Border)BorderFactory.createTitledBorder("Teku\u0107i ra\u010duni"));
            this.pnlRacun.setOpaque(false);
            pnlRacunLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            pnlRacunLayout.rowHeights = new int[]{7, 7, 7, 7};
            pnlRacunLayout.columnWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            pnlRacunLayout.columnWidths = new int[]{104, 7, 7, 7};
            this.scrollPaneRacun = new JScrollPane();
            this.pnlRacun.add((Component)this.scrollPaneRacun, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            List data = PzFirma.getFirma().getTekuciracuns();
            this.tblRacuni = new PzTable(data, Tekuciracun.class);
            this.tblRacuni.hideColumnByName("Podrazumevani");
            if (this.tblRacuni.getDataSize() > 0) {
                int index = -1;
                int i = 0;
                while (i < this.tblRacuni.getDataSize()) {
                    index = Integer.parseInt(this.tblRacuni.getModel().getValueAt(this.tblRacuni.convertRowIndexToModel(i), 0).toString());
                    if (index == 1) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                this.tblRacuni.setRowSelectionInterval(index, index);
            }
            this.tblRacuni.setId("TBL_RACUNI");
            this.scrollPaneRacun.setViewportView((Component)this.tblRacuni);
            this.tblRacuni.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzDialogRegistrovanjeIzvoda.this.racun = (Tekuciracun)PzDialogRegistrovanjeIzvoda.this.tblRacuni.getSelectedEntity();
                    System.out.println("Racun je " + PzDialogRegistrovanjeIzvoda.this.racun.getBrRacuna());
                    PzDialogRegistrovanjeIzvoda.this.tblRacuni.setFocusable(false);
                    PzDialogRegistrovanjeIzvoda.this.tblRacuni.setEnabled(false);
                    PzDialogRegistrovanjeIzvoda.this.tfTekuci.setText(String.valueOf(PzDialogRegistrovanjeIzvoda.this.racun.getBrRacuna()) + ";" + PzDialogRegistrovanjeIzvoda.this.racun.getBanka());
                    PzDialogRegistrovanjeIzvoda.this.setTableData();
                }
            });
            this.lblTekuci = new JLabel();
            this.pnlRacun.add((Component)this.lblTekuci, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.lblTekuci.setName("lblTekuci");
            this.lblTekuci.setFont(new Font("SansSerif", 1, 14));
            this.tfTekuci = new PzTextField();
            this.pnlRacun.add((Component)this.tfTekuci, (Object)new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.tfTekuci.setFocusable(false);
            this.tfTekuci.setEditable(false);
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlFields, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlFieldsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.rowHeights = new int[]{7, 7, 7, 7, 20, 20};
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            pnlFieldsLayout.columnWidths = new int[]{80, 127, 20};
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout);
            this.pnlFields.setOpaque(false);
            this.lblUlaz = new JLabel();
            this.pnlFields.add((Component)this.lblUlaz, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.lblUlaz.setName("lblUlaz");
            this.lblUlaz.setFont(new Font("SansSerif", 1, 14));
            this.dfUlaz = this.table.createExpresionField("$2$");
            this.pnlFields.add((Component)this.dfUlaz, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.dfUlaz.setFocusable(false);
            this.dfUlaz.setEditable(false);
            this.dfUlaz.setFont(new Font("SansSerif", 1, 14));
            this.dfUlaz.setForeground(Color.BLUE);
            this.lblIzlaz = new JLabel();
            this.pnlFields.add((Component)this.lblIzlaz, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.lblIzlaz.setName("lblIzlaz");
            this.dfIzlaz = this.table.createExpresionField("$3$");
            this.pnlFields.add((Component)this.dfIzlaz, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.dfIzlaz.setFocusable(false);
            this.dfIzlaz.setEditable(false);
            this.dfIzlaz.setFont(new Font("SansSerif", 1, 14));
            this.dfIzlaz.setForeground(Color.BLUE);
            this.lblStanje = new JLabel();
            this.pnlFields.add((Component)this.lblStanje, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.lblStanje.setName("lblStanje");
            this.dfStanje = this.table.createExpresionField("$2$-$3$");
            this.pnlFields.add((Component)this.dfStanje, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfStanje.setFocusable(false);
            this.dfStanje.setEditable(false);
            this.dfStanje.setFont(new Font("SansSerif", 1, 14));
            this.dfStanje.setForeground(Color.RED);
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.lblUkupnoNaloga = new JLabel("  Ukupno izvoda:");
            this.statusBar.add((Component)this.lblUkupnoNaloga);
            this.numUkupnoNaloga = new JLabel();
            this.statusBar.add((Component)this.numUkupnoNaloga);
            this.pack();
            this.setSize(870, 639);
            this.setMinimumSize(new Dimension(370, 639));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void setTableData() {
        this.table.setData(Tools.getIzvod(this.em, this.racun.getBrRacuna()), Izvodbanke.class);
        this.table.calculateFields();
        this.table.setEnterAction(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Izvodbanke cfr_ignored_0 = (Izvodbanke)PzDialogRegistrovanjeIzvoda.this.table.getSelectedEntity();
                    PzDialogRegistrovanjeIzvoda.this.getSession().putParameter("izvod", (Object)PzDialogRegistrovanjeIzvoda.this.table.getSelectedEntity());
                    PzDialogRegistrovanjeIzvoda.this.getSession().putParameter("racun", (Object)PzDialogRegistrovanjeIzvoda.this.racun);
                    PzDialogRegistrovanjeIzvoda.this.showDialog(PzDialogIzradaNaloga.class);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((PzTableModel)PzDialogRegistrovanjeIzvoda.this.table.getModel()).fireTableRowsUpdated(PzDialogRegistrovanjeIzvoda.this.table.getSelectedRow(), PzDialogRegistrovanjeIzvoda.this.table.getSelectedRow());
                        }
                    });
                }
                catch (Exception e1) {
                    PzMysqlExceptionHandler.handle((Component)((Object)PzDialogRegistrovanjeIzvoda.this), (Throwable)e1);
                }
            }
        });
        this.refresh();
    }

    public void actionPerformed(ActionEvent e) {
    }

    protected void actionPerformedicnNovNalog(ActionEvent arg0) {
        if (this.racun == null) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Izaberite teku\u0107i ra\u010dun.");
            return;
        }
        int option = JOptionPane.showConfirmDialog((Component)((Object)this), "Otvarate novi izvod?", "Otvaranje novog izvoda", 0);
        if (option != 0) {
            return;
        }
        this.getSession().putParameter("tabela", (Object)this.table);
        this.getSession().putParameter("update", (Object)false);
        this.getSession().putParameter("racun", (Object)this.racun);
        this.showDialog(PzDialogNoviNalog.class);
        this.refresh();
    }

    protected void actionPerformedicnIzmenaNaloga(ActionEvent arg0) {
        if (this.table.getRowCount() != 0) {
            this.getSession().putParameter("update", (Object)true);
            this.getSession().putParameter("tabela", (Object)this.table);
            this.getSession().putParameter("racun", (Object)this.racun);
            this.showDialog(PzDialogNoviNalog.class);
            this.refresh();
        }
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogRegistrovanjeIzvoda.this.numUkupnoNaloga.setText(String.valueOf(PzDialogRegistrovanjeIzvoda.this.table.getRowCount()));
                PzDialogRegistrovanjeIzvoda.this.table.calculateFields();
            }
        });
    }
}

