/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prostoKnjigovodstvo.gui.knjizenje.akcije;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.Application;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Stavkanzk;
import rs.pezar.db.entity.Vananalitike;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.prostoKnjigovodstvo.gui.knjizenje.akcije.PzDialogAkcija;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class KnjizenjeBezAnalitike
extends PzDialogAkcija {
    private static final long serialVersionUID = -4946878880917611410L;
    public static final String NE_IDE_U_PK1 = "Ne ide u PK1";
    public static final String IDE_U_PK1 = "Ide u PK1";
    private final PzPanel contentPanel = new PzPanel();
    private PzPanelHeader pnlHeader;
    private PzComboBox cbBox;
    private PzRadioGroup<String> panelRbs;
    private PzPanel pnlForm;
    private JLabel lblDuguje;
    private PzDoubleField dblUplata;
    private PzDoubleField dblIsplata;
    private JLabel lblPotrazuje;
    private JLabel lblOpis;
    private PzTextField txtOpis;
    private JLabel lblDatum;
    private PzDateField dateField;
    private Stavkanzk stavka = new Stavkanzk();
    private Vananalitike uplata;

    public static void main(String[] args) {
        try {
            KnjizenjeBezAnalitike dialog = new KnjizenjeBezAnalitike();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public KnjizenjeBezAnalitike() {
        this.initGUI();
    }

    private void paintPanel() {
        this.contentPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.contentPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.contentPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    public KnjizenjeBezAnalitike(PzDialog parent) {
        super(parent);
        this.initGUI();
        this.paintPanel();
    }

    private void initGUI() {
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setLayout((LayoutManager)new BorderLayout());
        this.contentPanel.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        buttonPane.setLayout(new FlowLayout(1));
        this.contentPanel.add((Component)buttonPane, (Object)"South");
        JButton okButton = new JButton("OK");
        okButton.setIcon(new ImageIcon(KnjizenjeBezAnalitike.class.getResource("/rs/pezar/prostoKnjigovodstvo/resource/img/check.png")));
        okButton.setActionCommand("OK");
        okButton.addActionListener((ActionListener)((Object)this));
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.pnlHeader = new PzPanelHeader();
        this.pnlHeader.setOpaque(false);
        this.pnlHeader.setTitle("Knji\u017eenje bez analitike");
        this.contentPanel.add((Component)this.pnlHeader, (Object)"North");
        this.pnlForm = new PzPanel();
        GridBagLayout gbl_pnlForm = new GridBagLayout();
        this.pnlForm.setOpaque(false);
        this.contentPanel.add((Component)this.pnlForm, (Object)"Center");
        int[] nArray = new int[8];
        nArray[0] = 93;
        nArray[1] = 99;
        nArray[2] = 32;
        nArray[3] = 66;
        nArray[4] = 128;
        nArray[5] = 36;
        nArray[6] = 52;
        gbl_pnlForm.columnWidths = nArray;
        int[] nArray2 = new int[7];
        nArray2[1] = 20;
        nArray2[2] = -1;
        nArray2[5] = 25;
        nArray2[6] = 20;
        gbl_pnlForm.rowHeights = nArray2;
        gbl_pnlForm.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        gbl_pnlForm.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
        this.pnlForm.setLayout((LayoutManager)gbl_pnlForm);
        this.lblDuguje = new JLabel("Duguje:");
        GridBagConstraints gbc_lblDuguje = new GridBagConstraints();
        gbc_lblDuguje.anchor = 13;
        gbc_lblDuguje.insets = new Insets(0, 0, 5, 5);
        gbc_lblDuguje.gridx = 0;
        gbc_lblDuguje.gridy = 1;
        this.pnlForm.add((Component)this.lblDuguje, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 2, 0, 5), 0, 0));
        this.lblDuguje.setName("lblDuguje");
        this.dblUplata = new PzDoubleField();
        GridBagConstraints gbc_dblUplata = new GridBagConstraints();
        gbc_dblUplata.gridwidth = 2;
        gbc_dblUplata.insets = new Insets(0, 0, 5, 5);
        gbc_dblUplata.fill = 1;
        gbc_dblUplata.gridx = 1;
        gbc_dblUplata.gridy = 1;
        this.pnlForm.add((Component)this.dblUplata, (Object)new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.lblPotrazuje = new JLabel("Potra\u017euje:");
        GridBagConstraints gbc_lblPotrazuje = new GridBagConstraints();
        gbc_lblPotrazuje.insets = new Insets(0, 0, 5, 5);
        gbc_lblPotrazuje.anchor = 13;
        gbc_lblPotrazuje.gridx = 3;
        gbc_lblPotrazuje.gridy = 1;
        this.pnlForm.add((Component)this.lblPotrazuje, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.lblPotrazuje.setName("lblPotrazuje");
        this.dblIsplata = new PzDoubleField();
        GridBagConstraints gbc_dblIsplata = new GridBagConstraints();
        gbc_dblIsplata.insets = new Insets(0, 0, 5, 5);
        gbc_dblIsplata.fill = 1;
        gbc_dblIsplata.gridx = 4;
        gbc_dblIsplata.gridy = 1;
        this.pnlForm.add((Component)this.dblIsplata, (Object)new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.lblOpis = new JLabel("Opis promene:");
        GridBagConstraints gbc_lblOpis = new GridBagConstraints();
        gbc_lblOpis.anchor = 13;
        gbc_lblOpis.insets = new Insets(0, 0, 5, 5);
        gbc_lblOpis.gridx = 0;
        gbc_lblOpis.gridy = 2;
        this.pnlForm.add((Component)this.lblOpis, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 2, 0, 5), 0, 0));
        this.txtOpis = new PzTextField();
        this.txtOpis.setVerifyInput(true);
        this.txtOpis.setMaxLength(255);
        GridBagConstraints gbc_txtOpis = new GridBagConstraints();
        gbc_txtOpis.insets = new Insets(0, 0, 5, 0);
        gbc_txtOpis.gridwidth = 6;
        gbc_txtOpis.fill = 1;
        gbc_txtOpis.gridx = 1;
        gbc_txtOpis.gridy = 2;
        this.pnlForm.add((Component)this.txtOpis, (Object)new GridBagConstraints(1, 3, 6, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.lblDatum = new JLabel("Datum knji\u017eenja:");
        GridBagConstraints gbc_lblDatum = new GridBagConstraints();
        gbc_lblDatum.anchor = 13;
        gbc_lblDatum.insets = new Insets(0, 0, 0, 5);
        gbc_lblDatum.gridx = 0;
        gbc_lblDatum.gridy = 3;
        this.pnlForm.add((Component)this.lblDatum, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 2, 0, 5), 0, 0));
        this.dateField = new PzDateField();
        GridBagConstraints gbc_dateField = new GridBagConstraints();
        gbc_dateField.insets = new Insets(0, 0, 0, 5);
        gbc_dateField.fill = 1;
        gbc_dateField.gridx = 1;
        gbc_dateField.gridy = 3;
        this.pnlForm.add((Component)this.dateField, (Object)new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 5), 0, 0));
        this.cbBox = new PzComboBox();
        this.pnlForm.add((Component)this.cbBox, (Object)new GridBagConstraints(0, 5, 7, 1, 0.0, 0.0, 10, 1, new Insets(0, 2, 0, 0), 0, 0));
        this.cbBox.addItem((Object)new PzChoice("17)Tro\u0161kovi zarade, naknada i ostali li\u010dni rashodi(52)", (Object)17));
        this.cbBox.addItem((Object)new PzChoice("18)Tro\u0161kovi proizvodnih usluga, amortizacija i nematerijalnih tro\u0161kova (grupe 53 do 55)", (Object)18));
        this.cbBox.addItem((Object)new PzChoice("19)Finansijski i ostali rashodi(grupe 56 do 59)", (Object)19));
        this.cbBox.setFocusable(false);
        this.cbBox.setEnabled(false);
        this.panelRbs = new PzRadioGroup((Object[])new String[]{NE_IDE_U_PK1, IDE_U_PK1});
        BoxLayout panelRBsLayout = new BoxLayout((Container)this.panelRbs, 1);
        this.panelRbs.setLayout((LayoutManager)panelRBsLayout);
        this.pnlForm.add(this.panelRbs, (Object)new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelRbs.setBorder((Border)BorderFactory.createTitledBorder("Izbor"));
        this.panelRbs.setSelectedValue((Object)NE_IDE_U_PK1);
        this.panelRbs.setOpaque(false);
        this.panelRbs.addRadioGroupListener(new PzRadioGroupListener(){

            public void selectionChanged(PzRadioGroupEvent evt) {
                if (evt.getStateChange() == 1) {
                    if (evt.getValue().equals(KnjizenjeBezAnalitike.IDE_U_PK1)) {
                        KnjizenjeBezAnalitike.this.cbBox.setFocusable(true);
                        KnjizenjeBezAnalitike.this.cbBox.setEnabled(true);
                        KnjizenjeBezAnalitike.this.dblUplata.setFocusable(false);
                        KnjizenjeBezAnalitike.this.dblUplata.setVal((Object)0.0);
                        KnjizenjeBezAnalitike.this.dblIsplata.requestFocus();
                    } else {
                        KnjizenjeBezAnalitike.this.cbBox.setFocusable(false);
                        KnjizenjeBezAnalitike.this.cbBox.setEnabled(false);
                        KnjizenjeBezAnalitike.this.dblUplata.setFocusable(true);
                        KnjizenjeBezAnalitike.this.dblUplata.setVal((Object)0.0);
                        KnjizenjeBezAnalitike.this.dblUplata.requestFocus();
                    }
                }
            }
        });
        this.pack();
        this.setSize(554, 324);
        Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.pnlForm.validateForm(true)) {
            return;
        }
        if (this.dblUplata.getVal().equals(this.dblIsplata.getVal()) && this.dblIsplata.getVal().equals(0.0)) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Nije dozvoljeno da oba polja, duguje i potra\u017euje, imaju vrednost 0.");
            return;
        }
        this.commit();
    }

    @Override
    public Date getDatKnjizenja() {
        return null;
    }

    @Override
    public PzDokument getNewDokument() {
        this.uplata = new Vananalitike();
        this.uplata.setDatum(this.dateField.getVal());
        this.uplata.setOznDokumenta(this.txtOpis.getVal());
        this.uplata.setIznos(new BigDecimal(this.dblUplata.getVal() - this.dblIsplata.getVal()));
        this.uplata.setTip(TipDokumentConfig.get().VAN_ANALITIKE);
        if (((String)this.panelRbs.getSelectedValue()).equalsIgnoreCase(NE_IDE_U_PK1)) {
            this.uplata.setPodTip(TipDokumentConfig.get().PODTIP_NE_IDE_U_PK1);
            this.uplata.setUplata(this.dblUplata.getVal().doubleValue());
            this.uplata.setIsplata(this.dblIsplata.getVal().doubleValue());
        } else if (this.cbBox.getSelectedChoice().getValue().equals(17)) {
            this.uplata.setPodTip(TipDokumentConfig.get().PODTIP_TROSKOVI_ZARADE);
            this.uplata.setUplata(0.0);
            this.uplata.setIsplata(this.dblIsplata.getVal().doubleValue());
        } else if (this.cbBox.getSelectedChoice().getValue().equals(18)) {
            this.uplata.setUplata(0.0);
            this.uplata.setIsplata(this.dblIsplata.getVal().doubleValue());
            this.uplata.setPodTip(TipDokumentConfig.get().PODTIP_TROSKOVI_USLUGA);
        } else if (this.cbBox.getSelectedChoice().getValue().equals(19)) {
            this.uplata.setUplata(0.0);
            this.uplata.setIsplata(this.dblIsplata.getVal().doubleValue());
            this.uplata.setPodTip(TipDokumentConfig.get().PODTIP_FINANSIJKSI_RASHODI);
        }
        this.uplata.setSfrKnjizenja(Integer.valueOf(this.getSfrKnjizenja()));
        return this.uplata;
    }
}

